/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.opendistroforelasticsearch.sql.legacy.query.join;

import com.amazon.opendistroforelasticsearch.sql.legacy.domain.JoinSelect;
import com.amazon.opendistroforelasticsearch.sql.legacy.domain.Where;
import com.amazon.opendistroforelasticsearch.sql.legacy.domain.hints.Hint;
import com.amazon.opendistroforelasticsearch.sql.legacy.domain.hints.HintType;
import com.amazon.opendistroforelasticsearch.sql.legacy.exception.SqlParseException;
import com.amazon.opendistroforelasticsearch.sql.legacy.query.join.ESJoinQueryAction;
import com.amazon.opendistroforelasticsearch.sql.legacy.query.join.JoinRequestBuilder;
import com.amazon.opendistroforelasticsearch.sql.legacy.query.join.NestedLoopsElasticRequestBuilder;
import org.elasticsearch.client.Client;

public class ESNestedLoopsQueryAction
extends ESJoinQueryAction {
    public ESNestedLoopsQueryAction(Client client, JoinSelect joinSelect) {
        super(client, joinSelect);
    }

    @Override
    protected void fillSpecificRequestBuilder(JoinRequestBuilder requestBuilder) throws SqlParseException {
        NestedLoopsElasticRequestBuilder nestedBuilder = (NestedLoopsElasticRequestBuilder)requestBuilder;
        Where where = this.joinSelect.getConnectedWhere();
        nestedBuilder.setConnectedWhere(where);
    }

    @Override
    protected JoinRequestBuilder createSpecificBuilder() {
        return new NestedLoopsElasticRequestBuilder();
    }

    @Override
    protected void updateRequestWithHints(JoinRequestBuilder requestBuilder) {
        super.updateRequestWithHints(requestBuilder);
        for (Hint hint : this.joinSelect.getHints()) {
            if (hint.getType() != HintType.NL_MULTISEARCH_SIZE) continue;
            Integer multiSearchMaxSize = (Integer)hint.getParams()[0];
            ((NestedLoopsElasticRequestBuilder)requestBuilder).setMultiSearchMaxSize(multiSearchMaxSize);
        }
    }

    private String removeAlias(String field) {
        String alias = this.joinSelect.getFirstTable().getAlias();
        if (!field.startsWith(alias + ".")) {
            alias = this.joinSelect.getSecondTable().getAlias();
        }
        return field.replace(alias + ".", "");
    }
}

