/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.opendistroforelasticsearch.sql.legacy.query.join;

import com.amazon.opendistroforelasticsearch.sql.legacy.domain.Condition;
import com.amazon.opendistroforelasticsearch.sql.legacy.domain.JoinSelect;
import com.amazon.opendistroforelasticsearch.sql.legacy.domain.hints.Hint;
import com.amazon.opendistroforelasticsearch.sql.legacy.domain.hints.HintType;
import com.amazon.opendistroforelasticsearch.sql.legacy.query.QueryAction;
import com.amazon.opendistroforelasticsearch.sql.legacy.query.join.ESHashJoinQueryAction;
import com.amazon.opendistroforelasticsearch.sql.legacy.query.join.ESNestedLoopsQueryAction;
import java.util.List;
import org.elasticsearch.client.Client;

public class ESJoinQueryActionFactory {
    public static QueryAction createJoinAction(Client client, JoinSelect joinSelect) {
        List<Condition> connectedConditions = joinSelect.getConnectedConditions();
        boolean allEqual = true;
        for (Condition condition : connectedConditions) {
            if (condition.getOPERATOR() == Condition.OPERATOR.EQ) continue;
            allEqual = false;
            break;
        }
        if (!allEqual) {
            return new ESNestedLoopsQueryAction(client, joinSelect);
        }
        boolean useNestedLoopsHintExist = false;
        for (Hint hint : joinSelect.getHints()) {
            if (hint.getType() != HintType.USE_NESTED_LOOPS) continue;
            useNestedLoopsHintExist = true;
            break;
        }
        if (useNestedLoopsHintExist) {
            return new ESNestedLoopsQueryAction(client, joinSelect);
        }
        return new ESHashJoinQueryAction(client, joinSelect);
    }
}

