/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.opendistroforelasticsearch.sql.legacy.query.join;

import com.amazon.opendistroforelasticsearch.sql.legacy.domain.Field;
import com.amazon.opendistroforelasticsearch.sql.legacy.domain.JoinSelect;
import com.amazon.opendistroforelasticsearch.sql.legacy.domain.Select;
import com.amazon.opendistroforelasticsearch.sql.legacy.domain.TableOnJoinSelect;
import com.amazon.opendistroforelasticsearch.sql.legacy.domain.hints.Hint;
import com.amazon.opendistroforelasticsearch.sql.legacy.exception.SqlParseException;
import com.amazon.opendistroforelasticsearch.sql.legacy.query.DefaultQueryAction;
import com.amazon.opendistroforelasticsearch.sql.legacy.query.QueryAction;
import com.amazon.opendistroforelasticsearch.sql.legacy.query.SqlElasticRequestBuilder;
import com.amazon.opendistroforelasticsearch.sql.legacy.query.join.JoinRequestBuilder;
import com.amazon.opendistroforelasticsearch.sql.legacy.query.join.TableInJoinRequestBuilder;
import com.amazon.opendistroforelasticsearch.sql.legacy.query.planner.HashJoinQueryPlanRequestBuilder;
import com.amazon.opendistroforelasticsearch.sql.legacy.query.planner.core.Config;
import java.util.List;
import org.elasticsearch.client.Client;

public abstract class ESJoinQueryAction
extends QueryAction {
    protected JoinSelect joinSelect;

    public ESJoinQueryAction(Client client, JoinSelect joinSelect) {
        super(client, joinSelect);
        this.joinSelect = joinSelect;
    }

    @Override
    public SqlElasticRequestBuilder explain() throws SqlParseException {
        JoinRequestBuilder requestBuilder = this.createSpecificBuilder();
        this.fillBasicJoinRequestBuilder(requestBuilder);
        this.fillSpecificRequestBuilder(requestBuilder);
        return requestBuilder;
    }

    protected abstract void fillSpecificRequestBuilder(JoinRequestBuilder var1) throws SqlParseException;

    protected abstract JoinRequestBuilder createSpecificBuilder();

    private void fillBasicJoinRequestBuilder(JoinRequestBuilder requestBuilder) throws SqlParseException {
        this.fillTableInJoinRequestBuilder(requestBuilder.getFirstTable(), this.joinSelect.getFirstTable());
        this.fillTableInJoinRequestBuilder(requestBuilder.getSecondTable(), this.joinSelect.getSecondTable());
        requestBuilder.setJoinType(this.joinSelect.getJoinType());
        requestBuilder.setTotalLimit(this.joinSelect.getTotalLimit());
        this.updateRequestWithHints(requestBuilder);
    }

    protected void updateRequestWithHints(JoinRequestBuilder requestBuilder) {
        for (Hint hint : this.joinSelect.getHints()) {
            Object[] params = hint.getParams();
            switch (hint.getType()) {
                case JOIN_LIMIT: {
                    requestBuilder.getFirstTable().setHintLimit((Integer)params[0]);
                    requestBuilder.getSecondTable().setHintLimit((Integer)params[1]);
                    break;
                }
                case JOIN_ALGORITHM_BLOCK_SIZE: {
                    if (!(requestBuilder instanceof HashJoinQueryPlanRequestBuilder)) break;
                    this.queryPlannerConfig(requestBuilder).configureBlockSize(hint.getParams());
                    break;
                }
                case JOIN_SCROLL_PAGE_SIZE: {
                    if (!(requestBuilder instanceof HashJoinQueryPlanRequestBuilder)) break;
                    this.queryPlannerConfig(requestBuilder).configureScrollPageSize(hint.getParams());
                    break;
                }
                case JOIN_CIRCUIT_BREAK_LIMIT: {
                    if (!(requestBuilder instanceof HashJoinQueryPlanRequestBuilder)) break;
                    this.queryPlannerConfig(requestBuilder).configureCircuitBreakLimit(hint.getParams());
                    break;
                }
                case JOIN_BACK_OFF_RETRY_INTERVALS: {
                    if (!(requestBuilder instanceof HashJoinQueryPlanRequestBuilder)) break;
                    this.queryPlannerConfig(requestBuilder).configureBackOffRetryIntervals(hint.getParams());
                    break;
                }
                case JOIN_TIME_OUT: {
                    if (!(requestBuilder instanceof HashJoinQueryPlanRequestBuilder)) break;
                    this.queryPlannerConfig(requestBuilder).configureTimeOut(hint.getParams());
                }
            }
        }
    }

    private Config queryPlannerConfig(JoinRequestBuilder requestBuilder) {
        return ((HashJoinQueryPlanRequestBuilder)requestBuilder).getConfig();
    }

    private void fillTableInJoinRequestBuilder(TableInJoinRequestBuilder requestBuilder, TableOnJoinSelect tableOnJoinSelect) throws SqlParseException {
        List<Field> connectedFields = tableOnJoinSelect.getConnectedFields();
        this.addFieldsToSelectIfMissing(tableOnJoinSelect, connectedFields);
        requestBuilder.setOriginalSelect(tableOnJoinSelect);
        DefaultQueryAction queryAction = new DefaultQueryAction(this.client, tableOnJoinSelect);
        queryAction.explain();
        requestBuilder.setRequestBuilder(queryAction.getRequestBuilder());
        requestBuilder.setReturnedFields(tableOnJoinSelect.getSelectedFields());
        requestBuilder.setAlias(tableOnJoinSelect.getAlias());
    }

    private void addFieldsToSelectIfMissing(Select select, List<Field> fields) {
        if (select.getFields() == null || select.getFields().size() == 0) {
            return;
        }
        List<Field> selectedFields = select.getFields();
        for (Field field : fields) {
            if (selectedFields.contains(field)) continue;
            selectedFields.add(field);
        }
    }
}

