/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.opendistroforelasticsearch.sql.legacy.query.join;

import com.amazon.opendistroforelasticsearch.sql.legacy.metrics.MetricName;
import com.amazon.opendistroforelasticsearch.sql.legacy.metrics.Metrics;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.IdentityHashMap;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Predicate;
import java.util.function.Supplier;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.common.collect.Tuple;

public class BackOffRetryStrategy {
    private static final Logger LOG = LogManager.getLogger();
    private static final long[] intervals = BackOffRetryStrategy.milliseconds(new double[]{4.0, 12.0, 20.0});
    private static final long delta = 4000L;
    private static final int threshold = 85;
    private static IdentityHashMap<Object, Tuple<Long, Long>> memUse = new IdentityHashMap();
    private static AtomicLong mem = new AtomicLong(0L);
    private static long lastTimeoutCleanTime = System.currentTimeMillis();
    private static final long RELTIMEOUT = 1800000L;
    private static final int MAXRETRIES = 999;
    private static final Object obj = new Object();
    public static final Supplier<Integer> GET_CB_STATE = () -> BackOffRetryStrategy.isMemoryHealthy() ? 0 : 1;

    private BackOffRetryStrategy() {
    }

    private static boolean isMemoryHealthy() {
        long freeMemory = Runtime.getRuntime().freeMemory();
        long totalMemory = Runtime.getRuntime().totalMemory();
        int memoryUsage = (int)Math.round((double)(totalMemory - freeMemory + mem.get()) / (double)totalMemory * 100.0);
        LOG.debug("[MCB1] Memory total, free, allocate: {}, {}, {}", (Object)totalMemory, (Object)freeMemory, (Object)mem.get());
        LOG.debug("[MCB1] Memory usage and limit: {}%, {}%", (Object)memoryUsage, (Object)85);
        return memoryUsage < 85;
    }

    public static boolean isHealthy() {
        for (int i = 0; i < intervals.length; ++i) {
            if (BackOffRetryStrategy.isMemoryHealthy()) {
                return true;
            }
            LOG.warn("[MCB1] Memory monitor is unhealthy now, back off retrying: {} attempt, thread id = {}", (Object)i, (Object)Thread.currentThread().getId());
            if (ThreadLocalRandom.current().nextBoolean()) {
                Metrics.getInstance().getNumericalMetric(MetricName.FAILED_REQ_COUNT_CB).increment();
                LOG.warn("[MCB1] Directly abort on idx {}.", (Object)i);
                return false;
            }
            BackOffRetryStrategy.backOffSleep(intervals[i]);
        }
        boolean isHealthy = BackOffRetryStrategy.isMemoryHealthy();
        if (!isHealthy) {
            Metrics.getInstance().getNumericalMetric(MetricName.FAILED_REQ_COUNT_CB).increment();
        }
        return isHealthy;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    private static boolean isMemoryHealthy(long allocateMemory, int idx, Object key) {
        long logMem = mem.get();
        BackOffRetryStrategy.releaseTimeoutMemory();
        if (idx == 0 && allocateMemory > 0L) {
            logMem = mem.addAndGet(allocateMemory);
            Class<BackOffRetryStrategy> clazz = BackOffRetryStrategy.class;
            // MONITORENTER : com.amazon.opendistroforelasticsearch.sql.legacy.query.join.BackOffRetryStrategy.class
            if (memUse.containsKey(key)) {
                memUse.put(key, (Tuple<Long, Long>)Tuple.tuple((Object)((Long)memUse.get(key).v1()), (Object)((Long)memUse.get(key).v2() + allocateMemory)));
            } else {
                memUse.put(key, (Tuple<Long, Long>)Tuple.tuple((Object)System.currentTimeMillis(), (Object)allocateMemory));
            }
            // MONITOREXIT : clazz
        }
        long freeMemory = Runtime.getRuntime().freeMemory();
        long totalMemory = Runtime.getRuntime().totalMemory();
        int memoryUsage = (int)Math.round((double)(totalMemory - freeMemory + logMem) / (double)totalMemory * 100.0);
        LOG.debug("[MCB] Idx is {}", (Object)idx);
        LOG.debug("[MCB] Memory total, free, allocate: {}, {}, {}, {}", (Object)totalMemory, (Object)freeMemory, (Object)allocateMemory, (Object)logMem);
        LOG.debug("[MCB] Memory usage and limit: {}%, {}%", (Object)memoryUsage, (Object)85);
        if (memoryUsage >= 85) return false;
        return true;
    }

    public static boolean isHealthy(long allocateMemory, Object key) {
        if (key == null) {
            key = obj;
        }
        for (int i = 0; i < intervals.length; ++i) {
            if (BackOffRetryStrategy.isMemoryHealthy(allocateMemory, i, key)) {
                return true;
            }
            LOG.warn("[MCB] Memory monitor is unhealthy now, back off retrying: {} attempt, executor = {}, thread id = {}", (Object)i, key, (Object)Thread.currentThread().getId());
            if (ThreadLocalRandom.current().nextBoolean()) {
                LOG.warn("[MCB] Directly abort on idx {}, executor is {}.", (Object)i, key);
                return false;
            }
            BackOffRetryStrategy.backOffSleep(intervals[i]);
        }
        return BackOffRetryStrategy.isMemoryHealthy(allocateMemory, 999, key);
    }

    public static void backOffSleep(long interval) {
        try {
            long millis = BackOffRetryStrategy.randomize(interval);
            LOG.info("[MCB] Back off sleeping: {} ms", (Object)millis);
            Thread.sleep(millis);
        }
        catch (InterruptedException e) {
            LOG.error("[MCB] Sleep interrupted", (Throwable)e);
        }
    }

    private static long randomize(long interval) {
        return ThreadLocalRandom.current().nextLong(BackOffRetryStrategy.lowerBound(interval), BackOffRetryStrategy.upperBound(interval));
    }

    private static long lowerBound(long interval) {
        return Math.max(0L, interval - 4000L);
    }

    private static long upperBound(long interval) {
        return interval + 4000L;
    }

    private static long[] milliseconds(double[] seconds) {
        return Arrays.stream(seconds).mapToLong(second -> (long)(1000.0 * second)).toArray();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void releaseMem(Object key) {
        LOG.debug("[MCB] mem is {} before release", (Object)mem);
        long v = 0L;
        Class<BackOffRetryStrategy> clazz = BackOffRetryStrategy.class;
        synchronized (BackOffRetryStrategy.class) {
            if (memUse.containsKey(key)) {
                v = (Long)memUse.get(key).v2();
                memUse.remove(key);
            }
            // ** MonitorExit[var3_2] (shouldn't be in output)
            if (v > 0L) {
                BackOffRetryStrategy.atomicMinusLowBoundZero(mem, v);
            }
            LOG.debug("[MCB] mem is {} after release", (Object)mem);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void releaseTimeoutMemory() {
        long cur = System.currentTimeMillis();
        if (cur - lastTimeoutCleanTime < 1800000L) {
            return;
        }
        ArrayList bulks = new ArrayList();
        Predicate<Tuple> isTimeout = t -> cur - (Long)t.v1() > 1800000L;
        Object object = BackOffRetryStrategy.class;
        synchronized (BackOffRetryStrategy.class) {
            memUse.values().stream().filter(isTimeout).forEach(v -> bulks.add((Long)v.v2()));
            memUse.values().removeIf(isTimeout);
            // ** MonitorExit[var4_3] (shouldn't be in output)
            object = bulks.iterator();
            while (object.hasNext()) {
                long v2 = (Long)object.next();
                BackOffRetryStrategy.atomicMinusLowBoundZero(mem, v2);
            }
            lastTimeoutCleanTime = cur;
            return;
        }
    }

    private static void atomicMinusLowBoundZero(AtomicLong x, Long y) {
        long memRes = x.addAndGet(-y.longValue());
        if (memRes < 0L) {
            x.compareAndSet(memRes, 0L);
        }
    }
}

