/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.opendistroforelasticsearch.sql.legacy.query;

import com.alibaba.druid.sql.ast.expr.SQLAggregateExpr;
import com.alibaba.druid.sql.ast.expr.SQLAllColumnExpr;
import com.alibaba.druid.sql.ast.expr.SQLMethodInvokeExpr;
import com.alibaba.druid.sql.ast.expr.SQLQueryExpr;
import com.alibaba.druid.sql.ast.statement.SQLDeleteStatement;
import com.alibaba.druid.sql.ast.statement.SQLJoinTableSource;
import com.alibaba.druid.sql.ast.statement.SQLSelectGroupByClause;
import com.alibaba.druid.sql.ast.statement.SQLSelectItem;
import com.alibaba.druid.sql.ast.statement.SQLUnionQuery;
import com.alibaba.druid.sql.dialect.mysql.ast.statement.MySqlSelectQueryBlock;
import com.alibaba.druid.sql.dialect.mysql.parser.MySqlStatementParser;
import com.alibaba.druid.sql.dialect.mysql.visitor.MySqlASTVisitorAdapter;
import com.alibaba.druid.sql.parser.Lexer;
import com.alibaba.druid.sql.parser.SQLStatementParser;
import com.alibaba.druid.sql.visitor.SQLASTVisitor;
import com.amazon.opendistroforelasticsearch.sql.legacy.domain.ColumnTypeProvider;
import com.amazon.opendistroforelasticsearch.sql.legacy.domain.Delete;
import com.amazon.opendistroforelasticsearch.sql.legacy.domain.IndexStatement;
import com.amazon.opendistroforelasticsearch.sql.legacy.domain.JoinSelect;
import com.amazon.opendistroforelasticsearch.sql.legacy.domain.QueryActionRequest;
import com.amazon.opendistroforelasticsearch.sql.legacy.domain.Select;
import com.amazon.opendistroforelasticsearch.sql.legacy.esdomain.LocalClusterState;
import com.amazon.opendistroforelasticsearch.sql.legacy.exception.SqlParseException;
import com.amazon.opendistroforelasticsearch.sql.legacy.executor.ElasticResultHandler;
import com.amazon.opendistroforelasticsearch.sql.legacy.executor.Format;
import com.amazon.opendistroforelasticsearch.sql.legacy.executor.QueryActionElasticExecutor;
import com.amazon.opendistroforelasticsearch.sql.legacy.executor.adapter.QueryPlanQueryAction;
import com.amazon.opendistroforelasticsearch.sql.legacy.executor.adapter.QueryPlanRequestBuilder;
import com.amazon.opendistroforelasticsearch.sql.legacy.parser.ElasticLexer;
import com.amazon.opendistroforelasticsearch.sql.legacy.parser.SqlParser;
import com.amazon.opendistroforelasticsearch.sql.legacy.parser.SubQueryExpression;
import com.amazon.opendistroforelasticsearch.sql.legacy.query.AggregationQueryAction;
import com.amazon.opendistroforelasticsearch.sql.legacy.query.DefaultQueryAction;
import com.amazon.opendistroforelasticsearch.sql.legacy.query.DeleteQueryAction;
import com.amazon.opendistroforelasticsearch.sql.legacy.query.DescribeQueryAction;
import com.amazon.opendistroforelasticsearch.sql.legacy.query.QueryAction;
import com.amazon.opendistroforelasticsearch.sql.legacy.query.ShowQueryAction;
import com.amazon.opendistroforelasticsearch.sql.legacy.query.join.ESJoinQueryActionFactory;
import com.amazon.opendistroforelasticsearch.sql.legacy.query.multi.MultiQueryAction;
import com.amazon.opendistroforelasticsearch.sql.legacy.query.multi.MultiQuerySelect;
import com.amazon.opendistroforelasticsearch.sql.legacy.query.planner.core.BindingTupleQueryPlanner;
import com.amazon.opendistroforelasticsearch.sql.legacy.rewriter.RewriteRuleExecutor;
import com.amazon.opendistroforelasticsearch.sql.legacy.rewriter.alias.TableAliasPrefixRemoveRule;
import com.amazon.opendistroforelasticsearch.sql.legacy.rewriter.identifier.UnquoteIdentifierRule;
import com.amazon.opendistroforelasticsearch.sql.legacy.rewriter.join.JoinRewriteRule;
import com.amazon.opendistroforelasticsearch.sql.legacy.rewriter.matchtoterm.TermFieldRewriter;
import com.amazon.opendistroforelasticsearch.sql.legacy.rewriter.nestedfield.NestedFieldRewriter;
import com.amazon.opendistroforelasticsearch.sql.legacy.rewriter.ordinal.OrdinalRewriterRule;
import com.amazon.opendistroforelasticsearch.sql.legacy.rewriter.parent.SQLExprParentSetterRule;
import com.amazon.opendistroforelasticsearch.sql.legacy.rewriter.subquery.SubQueryRewriteRule;
import com.amazon.opendistroforelasticsearch.sql.legacy.utils.Util;
import com.google.common.annotations.VisibleForTesting;
import java.sql.SQLFeatureNotSupportedException;
import java.util.ArrayList;
import org.elasticsearch.client.Client;
import org.elasticsearch.search.SearchHit;
import org.elasticsearch.search.SearchHits;

public class ESActionFactory {
    public static QueryAction create(Client client, String sql) throws SqlParseException, SQLFeatureNotSupportedException {
        return ESActionFactory.create(client, new QueryActionRequest(sql, new ColumnTypeProvider(), Format.JSON));
    }

    public static QueryAction create(Client client, QueryActionRequest request) throws SqlParseException, SQLFeatureNotSupportedException {
        String sql = request.getSql();
        if ((sql = sql.replaceAll("\\R", " ").trim()).endsWith(";")) {
            sql = sql.substring(0, sql.length() - 1);
        }
        switch (ESActionFactory.getFirstWord(sql)) {
            case "SELECT": {
                SQLQueryExpr sqlExpr = (SQLQueryExpr)Util.toSqlExpr(sql);
                RewriteRuleExecutor<SQLQueryExpr> ruleExecutor = RewriteRuleExecutor.builder().withRule(new SQLExprParentSetterRule()).withRule(new OrdinalRewriterRule(sql)).withRule(new UnquoteIdentifierRule()).withRule(new TableAliasPrefixRemoveRule()).withRule(new SubQueryRewriteRule()).build();
                ruleExecutor.executeOn(sqlExpr);
                sqlExpr.accept((SQLASTVisitor)new NestedFieldRewriter());
                if (ESActionFactory.isMulti(sqlExpr)) {
                    sqlExpr.accept((SQLASTVisitor)new TermFieldRewriter(TermFieldRewriter.TermRewriterFilter.MULTI_QUERY));
                    MultiQuerySelect multiSelect = new SqlParser().parseMultiSelect((SQLUnionQuery)sqlExpr.getSubQuery().getQuery());
                    return new MultiQueryAction(client, multiSelect);
                }
                if (ESActionFactory.isJoin(sqlExpr, sql)) {
                    new JoinRewriteRule(LocalClusterState.state()).rewrite(sqlExpr);
                    sqlExpr.accept((SQLASTVisitor)new TermFieldRewriter(TermFieldRewriter.TermRewriterFilter.JOIN));
                    JoinSelect joinSelect = new SqlParser().parseJoinSelect(sqlExpr);
                    return ESJoinQueryActionFactory.createJoinAction(client, joinSelect);
                }
                sqlExpr.accept((SQLASTVisitor)new TermFieldRewriter());
                if (ESActionFactory.shouldMigrateToQueryPlan(sqlExpr, request.getFormat())) {
                    return new QueryPlanQueryAction(new QueryPlanRequestBuilder(new BindingTupleQueryPlanner(client, sqlExpr, request.getTypeProvider())));
                }
                Select select = new SqlParser().parseSelect(sqlExpr);
                return ESActionFactory.handleSelect(client, select);
            }
            case "DELETE": {
                SQLStatementParser parser = ESActionFactory.createSqlStatementParser(sql);
                SQLDeleteStatement deleteStatement = parser.parseDeleteStatement();
                Delete delete = new SqlParser().parseDelete(deleteStatement);
                return new DeleteQueryAction(client, delete);
            }
            case "SHOW": {
                IndexStatement showStatement = new IndexStatement(IndexStatement.StatementType.SHOW, sql);
                return new ShowQueryAction(client, showStatement);
            }
            case "DESCRIBE": {
                IndexStatement describeStatement = new IndexStatement(IndexStatement.StatementType.DESCRIBE, sql);
                return new DescribeQueryAction(client, describeStatement);
            }
        }
        throw new SQLFeatureNotSupportedException(String.format("Query must start with SELECT, DELETE, SHOW or DESCRIBE: %s", sql));
    }

    private static String getFirstWord(String sql) {
        int endOfFirstWord = sql.indexOf(32);
        return sql.substring(0, endOfFirstWord > 0 ? endOfFirstWord : sql.length()).toUpperCase();
    }

    private static boolean isMulti(SQLQueryExpr sqlExpr) {
        return sqlExpr.getSubQuery().getQuery() instanceof SQLUnionQuery;
    }

    private static void executeAndFillSubQuery(Client client, SubQueryExpression subQueryExpression, QueryAction queryAction) throws SqlParseException {
        Object queryResult;
        ArrayList<Object> values = new ArrayList<Object>();
        try {
            queryResult = QueryActionElasticExecutor.executeAnyAction(client, queryAction);
        }
        catch (Exception e) {
            throw new SqlParseException("could not execute SubQuery: " + e.getMessage());
        }
        String returnField = subQueryExpression.getReturnField();
        if (queryResult instanceof SearchHits) {
            SearchHits hits = (SearchHits)queryResult;
            for (SearchHit hit : hits) {
                values.add(ElasticResultHandler.getFieldValue(hit, returnField));
            }
        } else {
            throw new SqlParseException("on sub queries only support queries that return Hits and not aggregations");
        }
        subQueryExpression.setValues(values.toArray());
    }

    private static QueryAction handleSelect(Client client, Select select) {
        if (select.isAggregate) {
            return new AggregationQueryAction(client, select);
        }
        return new DefaultQueryAction(client, select);
    }

    private static SQLStatementParser createSqlStatementParser(String sql) {
        ElasticLexer lexer = new ElasticLexer(sql);
        lexer.nextToken();
        return new MySqlStatementParser((Lexer)lexer);
    }

    private static boolean isJoin(SQLQueryExpr sqlExpr, String sql) {
        MySqlSelectQueryBlock query = (MySqlSelectQueryBlock)sqlExpr.getSubQuery().getQuery();
        return query.getFrom() instanceof SQLJoinTableSource && ((SQLJoinTableSource)query.getFrom()).getJoinType() != SQLJoinTableSource.JoinType.COMMA;
    }

    @VisibleForTesting
    public static boolean shouldMigrateToQueryPlan(SQLQueryExpr expr, Format format) {
        if (format == Format.JSON) {
            return false;
        }
        QueryPlannerScopeDecider decider = new QueryPlannerScopeDecider();
        return decider.isInScope(expr);
    }

    private static class QueryPlannerScopeDecider
    extends MySqlASTVisitorAdapter {
        private boolean hasAggregationFunc = false;
        private boolean hasNestedFunction = false;
        private boolean hasGroupBy = false;
        private boolean hasAllColumnExpr = false;

        private QueryPlannerScopeDecider() {
        }

        public boolean isInScope(SQLQueryExpr expr) {
            expr.accept((SQLASTVisitor)this);
            return !this.hasAllColumnExpr && !this.hasNestedFunction && (this.hasGroupBy || this.hasAggregationFunc);
        }

        public boolean visit(SQLSelectItem expr) {
            if (expr.getExpr() instanceof SQLAllColumnExpr) {
                this.hasAllColumnExpr = true;
            }
            return super.visit(expr);
        }

        public boolean visit(SQLSelectGroupByClause expr) {
            this.hasGroupBy = true;
            return super.visit(expr);
        }

        public boolean visit(SQLAggregateExpr expr) {
            this.hasAggregationFunc = true;
            return super.visit(expr);
        }

        public boolean visit(SQLMethodInvokeExpr expr) {
            if (expr.getMethodName().equalsIgnoreCase("nested")) {
                this.hasNestedFunction = true;
            }
            return super.visit(expr);
        }
    }
}

