/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.opendistroforelasticsearch.sql.legacy.query;

import com.amazon.opendistroforelasticsearch.sql.legacy.domain.Delete;
import com.amazon.opendistroforelasticsearch.sql.legacy.domain.Where;
import com.amazon.opendistroforelasticsearch.sql.legacy.exception.SqlParseException;
import com.amazon.opendistroforelasticsearch.sql.legacy.query.QueryAction;
import com.amazon.opendistroforelasticsearch.sql.legacy.query.SqlElasticDeleteByQueryRequestBuilder;
import com.amazon.opendistroforelasticsearch.sql.legacy.query.maker.QueryMaker;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.client.Client;
import org.elasticsearch.client.ElasticsearchClient;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.index.reindex.DeleteByQueryAction;
import org.elasticsearch.index.reindex.DeleteByQueryRequest;
import org.elasticsearch.index.reindex.DeleteByQueryRequestBuilder;

public class DeleteQueryAction
extends QueryAction {
    private final Delete delete;
    private DeleteByQueryRequestBuilder request;

    public DeleteQueryAction(Client client, Delete delete) {
        super(client, delete);
        this.delete = delete;
    }

    @Override
    public SqlElasticDeleteByQueryRequestBuilder explain() throws SqlParseException {
        this.request = new DeleteByQueryRequestBuilder((ElasticsearchClient)this.client, (ActionType)DeleteByQueryAction.INSTANCE);
        this.setIndicesAndTypes();
        this.setWhere(this.delete.getWhere());
        SqlElasticDeleteByQueryRequestBuilder deleteByQueryRequestBuilder = new SqlElasticDeleteByQueryRequestBuilder(this.request);
        return deleteByQueryRequestBuilder;
    }

    private void setIndicesAndTypes() {
        DeleteByQueryRequest innerRequest = (DeleteByQueryRequest)this.request.request();
        innerRequest.indices(this.query.getIndexArr());
        String[] typeArr = this.query.getTypeArr();
        if (typeArr != null) {
            innerRequest.getSearchRequest().types(typeArr);
        }
    }

    private void setWhere(Where where) throws SqlParseException {
        if (where != null) {
            BoolQueryBuilder whereQuery = QueryMaker.explain(where);
            this.request.filter((QueryBuilder)whereQuery);
        } else {
            this.request.filter((QueryBuilder)QueryBuilders.matchAllQuery());
        }
    }
}

