/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.opendistroforelasticsearch.sql.legacy.query;

import com.alibaba.druid.sql.ast.SQLExpr;
import com.alibaba.druid.sql.ast.expr.SQLBinaryOpExpr;
import com.alibaba.druid.sql.ast.expr.SQLBinaryOperator;
import com.alibaba.druid.sql.ast.expr.SQLCastExpr;
import com.amazon.opendistroforelasticsearch.sql.legacy.domain.Field;
import com.amazon.opendistroforelasticsearch.sql.legacy.domain.KVValue;
import com.amazon.opendistroforelasticsearch.sql.legacy.domain.MethodField;
import com.amazon.opendistroforelasticsearch.sql.legacy.domain.Order;
import com.amazon.opendistroforelasticsearch.sql.legacy.domain.Select;
import com.amazon.opendistroforelasticsearch.sql.legacy.domain.Where;
import com.amazon.opendistroforelasticsearch.sql.legacy.esdomain.LocalClusterState;
import com.amazon.opendistroforelasticsearch.sql.legacy.exception.SqlParseException;
import com.amazon.opendistroforelasticsearch.sql.legacy.executor.Format;
import com.amazon.opendistroforelasticsearch.sql.legacy.executor.format.Schema;
import com.amazon.opendistroforelasticsearch.sql.legacy.metrics.MetricName;
import com.amazon.opendistroforelasticsearch.sql.legacy.metrics.Metrics;
import com.amazon.opendistroforelasticsearch.sql.legacy.query.QueryAction;
import com.amazon.opendistroforelasticsearch.sql.legacy.query.SqlElasticSearchRequestBuilder;
import com.amazon.opendistroforelasticsearch.sql.legacy.query.maker.QueryMaker;
import com.amazon.opendistroforelasticsearch.sql.legacy.rewriter.nestedfield.NestedFieldProjection;
import com.amazon.opendistroforelasticsearch.sql.legacy.utils.SQLFunctions;
import com.google.common.annotations.VisibleForTesting;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.elasticsearch.action.ActionRequestBuilder;
import org.elasticsearch.action.search.SearchAction;
import org.elasticsearch.action.search.SearchRequestBuilder;
import org.elasticsearch.action.search.SearchType;
import org.elasticsearch.client.Client;
import org.elasticsearch.client.ElasticsearchClient;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.script.Script;
import org.elasticsearch.script.ScriptType;
import org.elasticsearch.search.sort.FieldSortBuilder;
import org.elasticsearch.search.sort.NestedSortBuilder;
import org.elasticsearch.search.sort.ScriptSortBuilder;
import org.elasticsearch.search.sort.SortBuilder;
import org.elasticsearch.search.sort.SortBuilders;
import org.elasticsearch.search.sort.SortOrder;

public class DefaultQueryAction
extends QueryAction {
    private final Select select;
    private SearchRequestBuilder request;
    private final List<String> fieldNames = new LinkedList<String>();

    public DefaultQueryAction(Client client, Select select) {
        super(client, select);
        this.select = select;
    }

    public void initialize(SearchRequestBuilder request) {
        this.request = request;
    }

    @Override
    public SqlElasticSearchRequestBuilder explain() throws SqlParseException {
        Objects.requireNonNull(this.sqlRequest, "SqlRequest is required for ES request build");
        this.buildRequest();
        this.checkAndSetScroll();
        return new SqlElasticSearchRequestBuilder((ActionRequestBuilder)this.request);
    }

    private void buildRequest() throws SqlParseException {
        this.request = new SearchRequestBuilder((ElasticsearchClient)this.client, SearchAction.INSTANCE);
        this.setIndicesAndTypes();
        this.setFields(this.select.getFields());
        this.setWhere(this.select.getWhere());
        this.setSorts(this.select.getOrderBys());
        this.updateRequestWithIndexAndRoutingOptions(this.select, this.request);
        this.updateRequestWithHighlight(this.select, this.request);
        this.updateRequestWithCollapse(this.select, this.request);
        this.updateRequestWithPostFilter(this.select, this.request);
        this.updateRequestWithInnerHits(this.select, this.request);
    }

    @VisibleForTesting
    public void checkAndSetScroll() {
        LocalClusterState clusterState = LocalClusterState.state();
        Integer fetchSize = this.sqlRequest.fetchSize();
        TimeValue timeValue = (TimeValue)clusterState.getSettingValue("opendistro.sql.cursor.keep_alive");
        Boolean cursorEnabled = (Boolean)clusterState.getSettingValue("opendistro.sql.cursor.enabled");
        Integer rowCount = this.select.getRowCount();
        if (this.checkIfScrollNeeded(cursorEnabled, fetchSize, rowCount)) {
            Metrics.getInstance().getNumericalMetric(MetricName.DEFAULT_CURSOR_REQUEST_COUNT_TOTAL).increment();
            Metrics.getInstance().getNumericalMetric(MetricName.DEFAULT_CURSOR_REQUEST_TOTAL).increment();
            this.request.setSize(fetchSize.intValue()).setScroll(timeValue);
        } else {
            this.request.setSearchType(SearchType.DFS_QUERY_THEN_FETCH);
            this.setLimit(this.select.getOffset(), rowCount != null ? rowCount : 200);
        }
    }

    private boolean checkIfScrollNeeded(boolean cursorEnabled, Integer fetchSize, Integer rowCount) {
        return cursorEnabled && this.format != null && this.format.equals((Object)Format.JDBC) && fetchSize > 0 && (rowCount == null || rowCount > fetchSize);
    }

    @Override
    public Optional<List<String>> getFieldNames() {
        return Optional.of(this.fieldNames);
    }

    public Select getSelect() {
        return this.select;
    }

    private void setIndicesAndTypes() {
        this.request.setIndices(this.query.getIndexArr());
        String[] typeArr = this.query.getTypeArr();
        if (typeArr != null) {
            this.request.setTypes(typeArr);
        }
    }

    public void setFields(List<Field> fields) throws SqlParseException {
        if (!this.select.getFields().isEmpty() && !this.select.isSelectAll()) {
            ArrayList<String> includeFields = new ArrayList<String>();
            ArrayList<String> excludeFields = new ArrayList<String>();
            for (Field field : fields) {
                if (field instanceof MethodField) {
                    MethodField method = (MethodField)field;
                    if (method.getName().toLowerCase().equals("script")) {
                        this.handleScriptField(method);
                        if (!(method.getExpression() instanceof SQLCastExpr)) continue;
                        includeFields.add(method.getParams().get(0).toString());
                        continue;
                    }
                    if (method.getName().equalsIgnoreCase("include")) {
                        for (KVValue kvValue : method.getParams()) {
                            includeFields.add(kvValue.value.toString());
                        }
                        continue;
                    }
                    if (!method.getName().equalsIgnoreCase("exclude")) continue;
                    for (KVValue kvValue : method.getParams()) {
                        excludeFields.add(kvValue.value.toString());
                    }
                    continue;
                }
                if (field == null || !this.isNotNested(field)) continue;
                includeFields.add(field.getName());
            }
            this.fieldNames.addAll(includeFields);
            this.request.setFetchSource(includeFields.toArray(new String[0]), excludeFields.toArray(new String[0]));
        }
    }

    private void handleScriptField(MethodField method) throws SqlParseException {
        List<KVValue> params = method.getParams();
        int numOfParams = params.size();
        if (2 != numOfParams && 3 != numOfParams) {
            throw new SqlParseException("scripted_field only allows 'script(name,script)' or 'script(name,lang,script)'");
        }
        String fieldName = params.get((int)0).value.toString();
        this.fieldNames.add(fieldName);
        String secondParam = params.get((int)1).value.toString();
        Script script = 2 == numOfParams ? new Script(secondParam) : new Script(ScriptType.INLINE, secondParam, params.get((int)2).value.toString(), Collections.emptyMap());
        this.request.addScriptField(fieldName, script);
    }

    private void setWhere(Where where) throws SqlParseException {
        BoolQueryBuilder boolQuery = null;
        if (where != null) {
            boolQuery = QueryMaker.explain(where, this.select.isQuery);
        }
        if (this.sqlRequest != null) {
            boolQuery = this.sqlRequest.checkAndAddFilter(boolQuery);
        }
        this.request.setQuery((QueryBuilder)boolQuery);
    }

    private void setSorts(List<Order> orderBys) {
        HashMap<String, FieldSortBuilder> sortBuilderMap = new HashMap<String, FieldSortBuilder>();
        for (Order order : orderBys) {
            String orderByName = order.getName();
            SortOrder sortOrder = SortOrder.valueOf((String)order.getType());
            if (order.getNestedPath() != null) {
                this.request.addSort((SortBuilder)((FieldSortBuilder)SortBuilders.fieldSort((String)orderByName).order(sortOrder)).setNestedSort(new NestedSortBuilder(order.getNestedPath())));
                continue;
            }
            if (order.isScript()) {
                this.request.addSort(SortBuilders.scriptSort((Script)new Script(orderByName), (ScriptSortBuilder.ScriptSortType)this.getScriptSortType(order)).order(sortOrder));
                continue;
            }
            if (orderByName.equals("_score")) {
                this.request.addSort(orderByName, sortOrder);
                continue;
            }
            FieldSortBuilder fieldSortBuilder = sortBuilderMap.computeIfAbsent(orderByName, key -> {
                FieldSortBuilder fs = SortBuilders.fieldSort((String)key);
                this.request.addSort((SortBuilder)fs);
                return fs;
            });
            this.setSortParams(fieldSortBuilder, order);
        }
    }

    private void setSortParams(FieldSortBuilder fieldSortBuilder, Order order) {
        fieldSortBuilder.order(SortOrder.valueOf((String)order.getType()));
        SQLExpr expr = order.getSortField().getExpression();
        if (expr instanceof SQLBinaryOpExpr) {
            fieldSortBuilder.missing((Object)this.getNullOrderString((SQLBinaryOpExpr)expr));
        }
    }

    private String getNullOrderString(SQLBinaryOpExpr expr) {
        SQLBinaryOperator operator = expr.getOperator();
        return operator == SQLBinaryOperator.IsNot ? "_first" : "_last";
    }

    private ScriptSortBuilder.ScriptSortType getScriptSortType(Order order) {
        ScriptSortBuilder.ScriptSortType scriptSortType;
        Schema.Type scriptFunctionReturnType = SQLFunctions.getOrderByFieldType(order.getSortField());
        switch (scriptFunctionReturnType) {
            case TEXT: {
                scriptSortType = ScriptSortBuilder.ScriptSortType.STRING;
                break;
            }
            case DOUBLE: 
            case FLOAT: 
            case INTEGER: 
            case LONG: {
                scriptSortType = ScriptSortBuilder.ScriptSortType.NUMBER;
                break;
            }
            default: {
                throw new IllegalStateException("Unknown type: " + (Object)((Object)scriptFunctionReturnType));
            }
        }
        return scriptSortType;
    }

    private void setLimit(int from, int size) {
        this.request.setFrom(from);
        if (size > -1) {
            this.request.setSize(size);
        }
    }

    public SearchRequestBuilder getRequestBuilder() {
        return this.request;
    }

    private boolean isNotNested(Field field) {
        return !field.isNested() || field.isReverseNested();
    }

    private void updateRequestWithInnerHits(Select select, SearchRequestBuilder request) {
        new NestedFieldProjection(request).project(select.getFields(), select.getNestedJoinType());
    }
}

