/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.opendistroforelasticsearch.sql.legacy.plugin;

import com.amazon.opendistroforelasticsearch.sql.legacy.executor.Format;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.unit.TimeValue;

public class SqlSettings {
    public static final String SQL_ENABLED = "opendistro.sql.enabled";
    public static final String SQL_NEW_ENGINE_ENABLED = "opendistro.sql.engine.new.enabled";
    public static final String QUERY_SLOWLOG = "opendistro.sql.query.slowlog";
    public static final String QUERY_RESPONSE_FORMAT = "opendistro.sql.query.response.format";
    public static final String QUERY_ANALYSIS_ENABLED = "opendistro.sql.query.analysis.enabled";
    public static final String QUERY_ANALYSIS_SEMANTIC_SUGGESTION = "opendistro.sql.query.analysis.semantic.suggestion";
    public static final String QUERY_ANALYSIS_SEMANTIC_THRESHOLD = "opendistro.sql.query.analysis.semantic.threshold";
    public static final String METRICS_ROLLING_WINDOW = "opendistro.sql.metrics.rollingwindow";
    public static final String METRICS_ROLLING_INTERVAL = "opendistro.sql.metrics.rollinginterval";
    public static final String CURSOR_ENABLED = "opendistro.sql.cursor.enabled";
    public static final String CURSOR_FETCH_SIZE = "opendistro.sql.cursor.fetch_size";
    public static final String CURSOR_KEEPALIVE = "opendistro.sql.cursor.keep_alive";
    private final Map<String, Setting<?>> settings;

    public SqlSettings() {
        HashMap<String, Setting> settings = new HashMap<String, Setting>();
        settings.put(SQL_ENABLED, Setting.boolSetting((String)SQL_ENABLED, (boolean)true, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Dynamic}));
        settings.put(SQL_NEW_ENGINE_ENABLED, Setting.boolSetting((String)SQL_NEW_ENGINE_ENABLED, (boolean)true, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Dynamic}));
        settings.put(QUERY_SLOWLOG, Setting.intSetting((String)QUERY_SLOWLOG, (int)2, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Dynamic}));
        settings.put(QUERY_RESPONSE_FORMAT, Setting.simpleString((String)QUERY_RESPONSE_FORMAT, (String)Format.JDBC.getFormatName(), (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Dynamic}));
        settings.put(QUERY_ANALYSIS_ENABLED, Setting.boolSetting((String)QUERY_ANALYSIS_ENABLED, (boolean)true, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Dynamic}));
        settings.put(QUERY_ANALYSIS_SEMANTIC_SUGGESTION, Setting.boolSetting((String)QUERY_ANALYSIS_SEMANTIC_SUGGESTION, (boolean)false, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Dynamic}));
        settings.put(QUERY_ANALYSIS_SEMANTIC_THRESHOLD, Setting.intSetting((String)QUERY_ANALYSIS_SEMANTIC_THRESHOLD, (int)200, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Dynamic}));
        settings.put(METRICS_ROLLING_WINDOW, Setting.longSetting((String)METRICS_ROLLING_WINDOW, (long)3600L, (long)2L, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Dynamic}));
        settings.put(METRICS_ROLLING_INTERVAL, Setting.longSetting((String)METRICS_ROLLING_INTERVAL, (long)60L, (long)1L, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Dynamic}));
        settings.put(CURSOR_ENABLED, Setting.boolSetting((String)CURSOR_ENABLED, (boolean)false, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Dynamic}));
        settings.put(CURSOR_FETCH_SIZE, Setting.intSetting((String)CURSOR_FETCH_SIZE, (int)1000, (int)1, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Dynamic}));
        settings.put(CURSOR_KEEPALIVE, Setting.positiveTimeSetting((String)CURSOR_KEEPALIVE, (TimeValue)TimeValue.timeValueMinutes((long)1L), (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Dynamic}));
        this.settings = Collections.unmodifiableMap(settings);
    }

    public SqlSettings(Map<String, Setting<?>> settings) {
        this.settings = Collections.unmodifiableMap(settings);
    }

    public Setting<?> getSetting(String key) {
        if (this.settings.containsKey(key)) {
            return this.settings.get(key);
        }
        throw new IllegalArgumentException("Cannot find setting by key [" + key + "]");
    }

    public List<Setting<?>> getSettings() {
        return new ArrayList(this.settings.values());
    }
}

