/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.opendistroforelasticsearch.sql.legacy.plugin;

import com.amazon.opendistroforelasticsearch.sql.legacy.executor.format.ErrorMessageFactory;
import com.amazon.opendistroforelasticsearch.sql.legacy.utils.LogUtils;
import com.google.common.collect.ImmutableList;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.ElasticsearchGenerationException;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.admin.cluster.settings.ClusterUpdateSettingsRequest;
import org.elasticsearch.client.Requests;
import org.elasticsearch.client.node.NodeClient;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentFactory;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.common.xcontent.XContentType;
import org.elasticsearch.rest.BaseRestHandler;
import org.elasticsearch.rest.BytesRestResponse;
import org.elasticsearch.rest.RestController;
import org.elasticsearch.rest.RestHandler;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.RestResponse;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.rest.action.RestToXContentListener;

public class RestSqlSettingsAction
extends BaseRestHandler {
    private static final Logger LOG = LogManager.getLogger(RestSqlSettingsAction.class);
    private static final String PERSISTENT = "persistent";
    private static final String TRANSIENT = "transient";
    private static final String SQL_SETTINGS_PREFIX = "opendistro.sql.";
    public static final String SETTINGS_API_ENDPOINT = "/_opendistro/_sql/settings";

    public RestSqlSettingsAction(Settings settings, RestController restController) {
    }

    public String getName() {
        return "sql_settings_action";
    }

    public List<RestHandler.Route> routes() {
        return ImmutableList.of((Object)new RestHandler.Route(RestRequest.Method.PUT, SETTINGS_API_ENDPOINT));
    }

    protected BaseRestHandler.RestChannelConsumer prepareRequest(RestRequest request, NodeClient client) throws IOException {
        Map source;
        LogUtils.addRequestId();
        ClusterUpdateSettingsRequest clusterUpdateSettingsRequest = Requests.clusterUpdateSettingsRequest();
        clusterUpdateSettingsRequest.timeout(request.paramAsTime("timeout", clusterUpdateSettingsRequest.timeout()));
        clusterUpdateSettingsRequest.masterNodeTimeout(request.paramAsTime("master_timeout", clusterUpdateSettingsRequest.masterNodeTimeout()));
        try (XContentParser parser = request.contentParser();){
            source = parser.map();
        }
        try {
            if (source.containsKey(TRANSIENT)) {
                clusterUpdateSettingsRequest.transientSettings(this.getAndFilterSettings((Map)source.get(TRANSIENT)));
            }
            if (source.containsKey(PERSISTENT)) {
                clusterUpdateSettingsRequest.persistentSettings(this.getAndFilterSettings((Map)source.get(PERSISTENT)));
            }
            return channel -> client.admin().cluster().updateSettings(clusterUpdateSettingsRequest, (ActionListener)new RestToXContentListener(channel));
        }
        catch (Exception e) {
            LOG.error("Error changing OpenDistro SQL plugin cluster settings", (Throwable)e);
            return channel -> channel.sendResponse((RestResponse)new BytesRestResponse(RestStatus.INTERNAL_SERVER_ERROR, ErrorMessageFactory.createErrorMessage(e, RestStatus.INTERNAL_SERVER_ERROR.getStatus()).toString()));
        }
    }

    protected Set<String> responseParams() {
        HashSet<String> responseParams = new HashSet<String>(super.responseParams());
        responseParams.addAll(Arrays.asList("sql", "flat", "separator", "_score", "_type", "_id", "newLine", "format"));
        return responseParams;
    }

    private Settings getAndFilterSettings(Map<String, ?> source) {
        try {
            XContentBuilder builder = XContentFactory.contentBuilder((XContentType)XContentType.JSON);
            builder.map(source);
            Settings.Builder settingsBuilder = Settings.builder().loadFromSource(Strings.toString((XContentBuilder)builder), builder.contentType());
            settingsBuilder.keys().removeIf(key -> !key.startsWith(SQL_SETTINGS_PREFIX));
            return settingsBuilder.build();
        }
        catch (IOException e) {
            throw new ElasticsearchGenerationException("Failed to generate [" + source + "]", (Throwable)e);
        }
    }
}

