/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.opendistroforelasticsearch.sql.legacy.plugin;

import com.alibaba.druid.sql.parser.ParserException;
import com.amazon.opendistroforelasticsearch.sql.common.antlr.SyntaxCheckException;
import com.amazon.opendistroforelasticsearch.sql.exception.SemanticCheckException;
import com.amazon.opendistroforelasticsearch.sql.legacy.antlr.OpenDistroSqlAnalyzer;
import com.amazon.opendistroforelasticsearch.sql.legacy.antlr.SqlAnalysisConfig;
import com.amazon.opendistroforelasticsearch.sql.legacy.antlr.SqlAnalysisException;
import com.amazon.opendistroforelasticsearch.sql.legacy.antlr.semantic.types.Type;
import com.amazon.opendistroforelasticsearch.sql.legacy.domain.ColumnTypeProvider;
import com.amazon.opendistroforelasticsearch.sql.legacy.domain.QueryActionRequest;
import com.amazon.opendistroforelasticsearch.sql.legacy.esdomain.LocalClusterState;
import com.amazon.opendistroforelasticsearch.sql.legacy.exception.SQLFeatureDisabledException;
import com.amazon.opendistroforelasticsearch.sql.legacy.exception.SqlParseException;
import com.amazon.opendistroforelasticsearch.sql.legacy.executor.ActionRequestRestExecutorFactory;
import com.amazon.opendistroforelasticsearch.sql.legacy.executor.Format;
import com.amazon.opendistroforelasticsearch.sql.legacy.executor.RestExecutor;
import com.amazon.opendistroforelasticsearch.sql.legacy.executor.cursor.CursorActionRequestRestExecutorFactory;
import com.amazon.opendistroforelasticsearch.sql.legacy.executor.cursor.CursorAsyncRestExecutor;
import com.amazon.opendistroforelasticsearch.sql.legacy.executor.format.ErrorMessageFactory;
import com.amazon.opendistroforelasticsearch.sql.legacy.metrics.MetricName;
import com.amazon.opendistroforelasticsearch.sql.legacy.metrics.Metrics;
import com.amazon.opendistroforelasticsearch.sql.legacy.plugin.RestSQLQueryAction;
import com.amazon.opendistroforelasticsearch.sql.legacy.plugin.SearchDao;
import com.amazon.opendistroforelasticsearch.sql.legacy.query.QueryAction;
import com.amazon.opendistroforelasticsearch.sql.legacy.request.SqlRequest;
import com.amazon.opendistroforelasticsearch.sql.legacy.request.SqlRequestFactory;
import com.amazon.opendistroforelasticsearch.sql.legacy.request.SqlRequestParam;
import com.amazon.opendistroforelasticsearch.sql.legacy.rewriter.matchtoterm.VerificationException;
import com.amazon.opendistroforelasticsearch.sql.legacy.utils.JsonPrettyFormatter;
import com.amazon.opendistroforelasticsearch.sql.legacy.utils.LogUtils;
import com.amazon.opendistroforelasticsearch.sql.legacy.utils.QueryDataAnonymizer;
import com.amazon.opendistroforelasticsearch.sql.sql.domain.SQLQueryRequest;
import com.google.common.collect.ImmutableList;
import java.sql.SQLFeatureNotSupportedException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.client.Client;
import org.elasticsearch.client.node.NodeClient;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.index.IndexNotFoundException;
import org.elasticsearch.rest.BaseRestHandler;
import org.elasticsearch.rest.BytesRestResponse;
import org.elasticsearch.rest.RestChannel;
import org.elasticsearch.rest.RestHandler;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.RestResponse;
import org.elasticsearch.rest.RestStatus;

public class RestSqlAction
extends BaseRestHandler {
    private static final Logger LOG = LogManager.getLogger(RestSqlAction.class);
    private final boolean allowExplicitIndex;
    private static final Predicate<String> CONTAINS_SUBQUERY = Pattern.compile("\\(\\s*select ").asPredicate();
    public static final String QUERY_API_ENDPOINT = "/_opendistro/_sql";
    public static final String EXPLAIN_API_ENDPOINT = "/_opendistro/_sql/_explain";
    public static final String CURSOR_CLOSE_ENDPOINT = "/_opendistro/_sql/close";
    private final RestSQLQueryAction newSqlQueryHandler;

    public RestSqlAction(Settings settings, ClusterService clusterService, com.amazon.opendistroforelasticsearch.sql.common.setting.Settings pluginSettings) {
        this.allowExplicitIndex = (Boolean)MULTI_ALLOW_EXPLICIT_INDEX.get(settings);
        this.newSqlQueryHandler = new RestSQLQueryAction(clusterService, pluginSettings);
    }

    public List<RestHandler.Route> routes() {
        return ImmutableList.of((Object)new RestHandler.Route(RestRequest.Method.POST, QUERY_API_ENDPOINT), (Object)new RestHandler.Route(RestRequest.Method.POST, EXPLAIN_API_ENDPOINT), (Object)new RestHandler.Route(RestRequest.Method.POST, CURSOR_CLOSE_ENDPOINT));
    }

    public String getName() {
        return "sql_action";
    }

    protected BaseRestHandler.RestChannelConsumer prepareRequest(RestRequest request, NodeClient client) {
        Metrics.getInstance().getNumericalMetric(MetricName.REQ_TOTAL).increment();
        Metrics.getInstance().getNumericalMetric(MetricName.REQ_COUNT_TOTAL).increment();
        LogUtils.addRequestId();
        try {
            if (!this.isSQLFeatureEnabled()) {
                throw new SQLFeatureDisabledException("Either opendistro.sql.enabled or rest.action.multi.allow_explicit_index setting is false");
            }
            SqlRequest sqlRequest = SqlRequestFactory.getSqlRequest(request);
            if (sqlRequest.cursor() != null) {
                if (RestSqlAction.isExplainRequest(request)) {
                    throw new IllegalArgumentException("Invalid request. Cannot explain cursor");
                }
                LOG.info("[{}] Cursor request {}: {}", (Object)LogUtils.getRequestId(), (Object)request.uri(), (Object)sqlRequest.cursor());
                return channel -> this.handleCursorRequest(request, sqlRequest.cursor(), (Client)client, (RestChannel)channel);
            }
            LOG.info("[{}] Incoming request {}: {}", (Object)LogUtils.getRequestId(), (Object)request.uri(), (Object)QueryDataAnonymizer.anonymizeData(sqlRequest.getSql()));
            Format format = SqlRequestParam.getFormat(request.params());
            if (this.isNewEngineEnabled() && this.isCursorDisabled()) {
                SQLQueryRequest newSqlRequest = new SQLQueryRequest(sqlRequest.getJsonContent(), sqlRequest.getSql(), request.path(), request.params());
                BaseRestHandler.RestChannelConsumer result = this.newSqlQueryHandler.prepareRequest(newSqlRequest, client);
                if (result != RestSQLQueryAction.NOT_SUPPORTED_YET) {
                    LOG.info("[{}] Request is handled by new SQL query engine", (Object)LogUtils.getRequestId());
                    return result;
                }
                LOG.debug("[{}] Request {} is not supported and falling back to old SQL engine", (Object)LogUtils.getRequestId(), (Object)newSqlRequest);
            }
            QueryAction queryAction = RestSqlAction.explainRequest(client, sqlRequest, format);
            return channel -> this.executeSqlRequest(request, queryAction, (Client)client, (RestChannel)channel);
        }
        catch (Exception e) {
            RestSqlAction.logAndPublishMetrics(e);
            return channel -> this.reportError((RestChannel)channel, e, RestSqlAction.isClientError(e) ? RestStatus.BAD_REQUEST : RestStatus.SERVICE_UNAVAILABLE);
        }
    }

    protected Set<String> responseParams() {
        HashSet<String> responseParams = new HashSet<String>(super.responseParams());
        responseParams.addAll(Arrays.asList("sql", "flat", "separator", "_score", "_type", "_id", "newLine", "format", "sanitize"));
        return responseParams;
    }

    private void handleCursorRequest(RestRequest request, String cursor, Client client, RestChannel channel) throws Exception {
        CursorAsyncRestExecutor cursorRestExecutor = CursorActionRequestRestExecutorFactory.createExecutor(request, cursor, SqlRequestParam.getFormat(request.params()));
        cursorRestExecutor.execute(client, request.params(), channel);
    }

    private static void logAndPublishMetrics(Exception e) {
        if (RestSqlAction.isClientError(e)) {
            LOG.error(LogUtils.getRequestId() + " Client side error during query execution", (Throwable)e);
            Metrics.getInstance().getNumericalMetric(MetricName.FAILED_REQ_COUNT_CUS).increment();
        } else {
            LOG.error(LogUtils.getRequestId() + " Server side error during query execution", (Throwable)e);
            Metrics.getInstance().getNumericalMetric(MetricName.FAILED_REQ_COUNT_SYS).increment();
        }
    }

    private static QueryAction explainRequest(NodeClient client, SqlRequest sqlRequest, Format format) throws SQLFeatureNotSupportedException, SqlParseException {
        ColumnTypeProvider typeProvider = RestSqlAction.performAnalysis(sqlRequest.getSql());
        QueryAction queryAction = new SearchDao((Client)client).explain(new QueryActionRequest(sqlRequest.getSql(), typeProvider, format));
        queryAction.setSqlRequest(sqlRequest);
        queryAction.setFormat(format);
        queryAction.setColumnTypeProvider(typeProvider);
        return queryAction;
    }

    private void executeSqlRequest(RestRequest request, QueryAction queryAction, Client client, RestChannel channel) throws Exception {
        Map params = request.params();
        if (RestSqlAction.isExplainRequest(request)) {
            String jsonExplanation = queryAction.explain().explain();
            String result = SqlRequestParam.isPrettyFormat(params) ? JsonPrettyFormatter.format(jsonExplanation) : jsonExplanation;
            channel.sendResponse((RestResponse)new BytesRestResponse(RestStatus.OK, "application/json; charset=UTF-8", result));
        } else {
            RestExecutor restExecutor = ActionRequestRestExecutorFactory.createExecutor(SqlRequestParam.getFormat(params), queryAction);
            HashMap<String, String> additionalParams = new HashMap<String, String>();
            for (String paramName : this.responseParams()) {
                if (!request.hasParam(paramName)) continue;
                additionalParams.put(paramName, request.param(paramName));
            }
            restExecutor.execute(client, additionalParams, queryAction, channel);
        }
    }

    private static boolean isExplainRequest(RestRequest request) {
        return request.path().endsWith("/_explain");
    }

    private static boolean isClientError(Exception e) {
        return e instanceof NullPointerException || e instanceof SqlParseException || e instanceof ParserException || e instanceof SQLFeatureNotSupportedException || e instanceof SQLFeatureDisabledException || e instanceof IllegalArgumentException || e instanceof IndexNotFoundException || e instanceof VerificationException || e instanceof SqlAnalysisException || e instanceof SyntaxCheckException || e instanceof SemanticCheckException;
    }

    private void sendResponse(RestChannel channel, String message, RestStatus status) {
        channel.sendResponse((RestResponse)new BytesRestResponse(status, message));
    }

    private void reportError(RestChannel channel, Exception e, RestStatus status) {
        this.sendResponse(channel, ErrorMessageFactory.createErrorMessage(e, status.getStatus()).toString(), status);
    }

    private boolean isSQLFeatureEnabled() {
        boolean isSqlEnabled = (Boolean)LocalClusterState.state().getSettingValue("opendistro.sql.enabled");
        return this.allowExplicitIndex && isSqlEnabled;
    }

    private boolean isNewEngineEnabled() {
        return (Boolean)LocalClusterState.state().getSettingValue("opendistro.sql.engine.new.enabled");
    }

    private boolean isCursorDisabled() {
        Boolean isEnabled = (Boolean)LocalClusterState.state().getSettingValue("opendistro.sql.cursor.enabled");
        return Boolean.FALSE.equals(isEnabled);
    }

    private static ColumnTypeProvider performAnalysis(String sql) {
        LocalClusterState clusterState = LocalClusterState.state();
        SqlAnalysisConfig config = new SqlAnalysisConfig((Boolean)clusterState.getSettingValue("opendistro.sql.query.analysis.enabled"), (Boolean)clusterState.getSettingValue("opendistro.sql.query.analysis.semantic.suggestion"), (Integer)clusterState.getSettingValue("opendistro.sql.query.analysis.semantic.threshold"));
        OpenDistroSqlAnalyzer analyzer = new OpenDistroSqlAnalyzer(config);
        Optional<Type> outputColumnType = analyzer.analyze(sql, clusterState);
        if (outputColumnType.isPresent()) {
            return new ColumnTypeProvider(outputColumnType.get());
        }
        return new ColumnTypeProvider();
    }
}

