/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.opendistroforelasticsearch.sql.legacy.parser;

import com.alibaba.druid.sql.ast.SQLExpr;
import com.alibaba.druid.sql.ast.expr.SQLIdentifierExpr;
import com.alibaba.druid.sql.ast.expr.SQLMethodInvokeExpr;
import com.alibaba.druid.sql.ast.expr.SQLPropertyExpr;
import com.alibaba.druid.sql.ast.expr.SQLTextLiteralExpr;
import com.amazon.opendistroforelasticsearch.sql.legacy.domain.Where;
import com.amazon.opendistroforelasticsearch.sql.legacy.domain.bucketpath.BucketPath;
import com.amazon.opendistroforelasticsearch.sql.legacy.domain.bucketpath.Path;
import com.amazon.opendistroforelasticsearch.sql.legacy.exception.SqlParseException;
import com.amazon.opendistroforelasticsearch.sql.legacy.parser.SqlParser;
import com.amazon.opendistroforelasticsearch.sql.legacy.parser.WhereParser;
import com.amazon.opendistroforelasticsearch.sql.legacy.utils.Util;
import java.util.List;

public class NestedType {
    public String field;
    public String path;
    public Where where;
    private boolean reverse;
    private boolean simple;
    private final BucketPath bucketPath = new BucketPath();

    public boolean tryFillFromExpr(SQLExpr expr) throws SqlParseException {
        String field;
        if (!(expr instanceof SQLMethodInvokeExpr)) {
            return false;
        }
        SQLMethodInvokeExpr method = (SQLMethodInvokeExpr)expr;
        String methodNameLower = method.getMethodName().toLowerCase();
        if (!methodNameLower.equals("nested") && !methodNameLower.equals("reverse_nested")) {
            return false;
        }
        this.reverse = methodNameLower.equals("reverse_nested");
        List parameters = method.getParameters();
        if (parameters.size() != 2 && parameters.size() != 1) {
            throw new IllegalArgumentException("on nested object only allowed 2 parameters (field,path)/(path,conditions..) or 1 parameter (field) ");
        }
        this.field = field = Util.extendedToString((SQLExpr)parameters.get(0));
        if (parameters.size() == 1) {
            if (!field.contains(".")) {
                if (!this.reverse) {
                    throw new IllegalArgumentException("Illegal nested field name: " + field);
                }
                this.path = null;
                this.simple = true;
            } else {
                int lastDot = field.lastIndexOf(".");
                this.path = field.substring(0, lastDot);
                this.simple = true;
            }
        } else if (parameters.size() == 2) {
            SQLExpr secondParameter = (SQLExpr)parameters.get(1);
            if (secondParameter instanceof SQLTextLiteralExpr || secondParameter instanceof SQLIdentifierExpr || secondParameter instanceof SQLPropertyExpr) {
                String pathString = Util.extendedToString(secondParameter);
                this.path = pathString.equals("") ? null : pathString;
                this.simple = true;
            } else {
                this.path = field;
                Where where = Where.newInstance();
                new WhereParser(new SqlParser()).parseWhere(secondParameter, where);
                if (where.getWheres().size() == 0) {
                    throw new SqlParseException("Failed to parse filter condition");
                }
                this.where = where;
                this.simple = false;
            }
        }
        return true;
    }

    public boolean isSimple() {
        return this.simple;
    }

    public boolean isReverse() {
        return this.reverse;
    }

    public String getNestedAggName() {
        return this.field + "@NESTED";
    }

    public String getFilterAggName() {
        return this.field + "@FILTER";
    }

    public void addBucketPath(Path path) {
        this.bucketPath.add(path);
    }

    public String getBucketPath() {
        return this.bucketPath.getBucketPath();
    }

    public boolean isNestedField() {
        return !this.field.contains(".") && this.field.equalsIgnoreCase(this.path);
    }
}

