/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.opendistroforelasticsearch.sql.legacy.parser;

import com.alibaba.druid.sql.ast.SQLExpr;
import com.alibaba.druid.sql.ast.SQLObject;
import com.alibaba.druid.sql.ast.expr.SQLAggregateExpr;
import com.alibaba.druid.sql.ast.expr.SQLBetweenExpr;
import com.alibaba.druid.sql.ast.expr.SQLBinaryOpExpr;
import com.alibaba.druid.sql.ast.expr.SQLIdentifierExpr;
import com.alibaba.druid.sql.ast.expr.SQLInListExpr;
import com.alibaba.druid.sql.ast.expr.SQLNotExpr;
import com.alibaba.druid.sql.dialect.mysql.visitor.MySqlASTVisitorAdapter;
import com.alibaba.druid.sql.visitor.SQLASTVisitor;
import com.amazon.opendistroforelasticsearch.sql.legacy.domain.Field;
import com.amazon.opendistroforelasticsearch.sql.legacy.domain.Where;
import com.amazon.opendistroforelasticsearch.sql.legacy.exception.SqlParseException;
import com.amazon.opendistroforelasticsearch.sql.legacy.parser.FieldMaker;
import com.amazon.opendistroforelasticsearch.sql.legacy.parser.WhereParser;
import java.util.ArrayList;
import java.util.List;

public class HavingParser {
    private final WhereParser whereParser;
    private final List<Field> havingFields;
    private final HavingConditionRewriter havingConditionRewriter;

    public HavingParser(WhereParser whereParser) {
        this.whereParser = whereParser;
        this.havingFields = new ArrayList<Field>();
        this.havingConditionRewriter = new HavingConditionRewriter();
    }

    public void parseWhere(SQLExpr expr, Where where) throws SqlParseException {
        expr.accept((SQLASTVisitor)this.havingConditionRewriter);
        this.whereParser.parseWhere(expr, where);
    }

    public List<Field> getHavingFields() {
        return this.havingFields;
    }

    private class HavingConditionRewriter
    extends MySqlASTVisitorAdapter {
        private int aliasSuffix = 0;

        private HavingConditionRewriter() {
        }

        public boolean visit(SQLAggregateExpr expr) {
            SQLIdentifierExpr translatedExpr = this.translateAggExpr(expr);
            SQLObject parent = expr.getParent();
            if (parent instanceof SQLBinaryOpExpr) {
                SQLBinaryOpExpr parentOpExpr = (SQLBinaryOpExpr)parent;
                if (parentOpExpr.getLeft() == expr) {
                    parentOpExpr.setLeft((SQLExpr)translatedExpr);
                } else {
                    parentOpExpr.setRight((SQLExpr)translatedExpr);
                }
            } else if (parent instanceof SQLNotExpr) {
                SQLNotExpr parentNotExpr = (SQLNotExpr)parent;
                parentNotExpr.setExpr((SQLExpr)translatedExpr);
            } else if (parent instanceof SQLInListExpr) {
                SQLInListExpr parentInListExpr = (SQLInListExpr)parent;
                parentInListExpr.setExpr((SQLExpr)translatedExpr);
            } else if (parent instanceof SQLBetweenExpr) {
                SQLBetweenExpr parentBetweenExpr = (SQLBetweenExpr)parent;
                parentBetweenExpr.setTestExpr((SQLExpr)translatedExpr);
            } else {
                throw new IllegalStateException("Unsupported aggregation function in having clause " + parent.getClass());
            }
            return true;
        }

        private SQLIdentifierExpr translateAggExpr(SQLAggregateExpr expr) {
            String methodAlias = this.methodAlias(expr.getMethodName());
            SQLIdentifierExpr sqlExpr = new SQLIdentifierExpr(methodAlias);
            try {
                HavingParser.this.havingFields.add(new FieldMaker().makeField((SQLExpr)expr, methodAlias, null));
                return sqlExpr;
            }
            catch (SqlParseException e) {
                throw new IllegalStateException(e);
            }
        }

        private String methodAlias(String methodName) {
            return String.format("%s_%d", methodName.toLowerCase(), this.nextAlias());
        }

        private Integer nextAlias() {
            return this.aliasSuffix++;
        }
    }
}

