/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.opendistroforelasticsearch.sql.legacy.parser;

import com.alibaba.druid.sql.ast.SQLExpr;
import com.alibaba.druid.sql.ast.SQLObject;
import com.alibaba.druid.sql.ast.expr.SQLAggregateExpr;
import com.alibaba.druid.sql.ast.expr.SQLAggregateOption;
import com.alibaba.druid.sql.ast.expr.SQLAllColumnExpr;
import com.alibaba.druid.sql.ast.expr.SQLBinaryOpExpr;
import com.alibaba.druid.sql.ast.expr.SQLCaseExpr;
import com.alibaba.druid.sql.ast.expr.SQLCastExpr;
import com.alibaba.druid.sql.ast.expr.SQLCharExpr;
import com.alibaba.druid.sql.ast.expr.SQLIdentifierExpr;
import com.alibaba.druid.sql.ast.expr.SQLMethodInvokeExpr;
import com.alibaba.druid.sql.ast.expr.SQLNumericLiteralExpr;
import com.alibaba.druid.sql.ast.expr.SQLPropertyExpr;
import com.alibaba.druid.sql.ast.expr.SQLQueryExpr;
import com.alibaba.druid.sql.ast.expr.SQLVariantRefExpr;
import com.alibaba.druid.sql.ast.statement.SQLSelectGroupByClause;
import com.alibaba.druid.sql.ast.statement.SQLSelectItem;
import com.alibaba.druid.sql.ast.statement.SQLSelectQueryBlock;
import com.amazon.opendistroforelasticsearch.sql.legacy.domain.Field;
import com.amazon.opendistroforelasticsearch.sql.legacy.domain.KVValue;
import com.amazon.opendistroforelasticsearch.sql.legacy.domain.MethodField;
import com.amazon.opendistroforelasticsearch.sql.legacy.domain.ScriptMethodField;
import com.amazon.opendistroforelasticsearch.sql.legacy.domain.Where;
import com.amazon.opendistroforelasticsearch.sql.legacy.exception.SqlFeatureNotImplementedException;
import com.amazon.opendistroforelasticsearch.sql.legacy.exception.SqlParseException;
import com.amazon.opendistroforelasticsearch.sql.legacy.parser.CaseWhenParser;
import com.amazon.opendistroforelasticsearch.sql.legacy.parser.ChildrenType;
import com.amazon.opendistroforelasticsearch.sql.legacy.parser.NestedType;
import com.amazon.opendistroforelasticsearch.sql.legacy.parser.SqlParser;
import com.amazon.opendistroforelasticsearch.sql.legacy.parser.WhereParser;
import com.amazon.opendistroforelasticsearch.sql.legacy.utils.SQLFunctions;
import com.amazon.opendistroforelasticsearch.sql.legacy.utils.Util;
import com.google.common.base.Strings;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import org.elasticsearch.common.collect.Tuple;

public class FieldMaker {
    private SQLFunctions sqlFunctions = new SQLFunctions();

    public Field makeField(SQLExpr expr, String alias, String tableAlias) throws SqlParseException {
        Field field = this.makeFieldImpl(expr, alias, tableAlias);
        this.addGroupByForDistinctFieldsInSelect(expr, field);
        if (field != null) {
            field.setExpression(expr);
        }
        return field;
    }

    private Field makeFieldImpl(SQLExpr expr, String alias, String tableAlias) throws SqlParseException {
        if (expr instanceof SQLIdentifierExpr || expr instanceof SQLPropertyExpr || expr instanceof SQLVariantRefExpr) {
            return FieldMaker.handleIdentifier(expr, alias, tableAlias);
        }
        if (expr instanceof SQLQueryExpr) {
            throw new SqlParseException("unknown field name : " + expr);
        }
        if (expr instanceof SQLBinaryOpExpr) {
            return this.makeFieldImpl((SQLExpr)this.makeBinaryMethodField((SQLBinaryOpExpr)expr, alias, true), alias, tableAlias);
        }
        if (expr instanceof SQLAllColumnExpr) {
            return Field.STAR;
        }
        if (expr instanceof SQLMethodInvokeExpr) {
            SQLMethodInvokeExpr mExpr = (SQLMethodInvokeExpr)expr;
            String methodName = mExpr.getMethodName();
            if (methodName.equalsIgnoreCase("nested") || methodName.equalsIgnoreCase("reverse_nested")) {
                NestedType nestedType = new NestedType();
                if (nestedType.tryFillFromExpr((SQLExpr)mExpr)) {
                    return FieldMaker.handleIdentifier(nestedType, alias, tableAlias);
                }
            } else if (methodName.equalsIgnoreCase("children")) {
                ChildrenType childrenType = new ChildrenType();
                if (childrenType.tryFillFromExpr((SQLExpr)mExpr)) {
                    return FieldMaker.handleIdentifier(childrenType, alias, tableAlias);
                }
            } else if (methodName.equalsIgnoreCase("filter")) {
                return FieldMaker.makeFilterMethodField(mExpr, alias);
            }
            if (SQLFunctions.builtInFunctions.contains(methodName.toLowerCase()) && Strings.isNullOrEmpty((String)alias)) {
                alias = mExpr.toString();
            }
            return this.makeMethodField(methodName, mExpr.getParameters(), null, alias, tableAlias, true);
        }
        if (expr instanceof SQLAggregateExpr) {
            SQLAggregateExpr sExpr = (SQLAggregateExpr)expr;
            return this.makeMethodField(sExpr.getMethodName(), sExpr.getArguments(), sExpr.getOption(), alias, tableAlias, true);
        }
        if (expr instanceof SQLCaseExpr) {
            String scriptCode = new CaseWhenParser((SQLCaseExpr)expr, alias, tableAlias).parse();
            ArrayList<KVValue> methodParameters = new ArrayList<KVValue>();
            methodParameters.add(new KVValue(alias));
            methodParameters.add(new KVValue(scriptCode));
            return new MethodField("script", methodParameters, null, alias);
        }
        if (expr instanceof SQLCastExpr) {
            SQLCastExpr castExpr = (SQLCastExpr)expr;
            if (alias == null) {
                alias = "cast_" + castExpr.getExpr().toString();
            }
            ArrayList<SQLExpr> methodParameters = new ArrayList<SQLExpr>();
            methodParameters.add(((SQLCastExpr)expr).getExpr());
            return this.makeMethodField("CAST", methodParameters, null, alias, tableAlias, true);
        }
        if (expr instanceof SQLNumericLiteralExpr) {
            SQLMethodInvokeExpr methodInvokeExpr = new SQLMethodInvokeExpr("assign", null);
            methodInvokeExpr.addParameter(expr);
            return this.makeMethodField(methodInvokeExpr.getMethodName(), methodInvokeExpr.getParameters(), null, alias, tableAlias, true);
        }
        throw new SqlParseException("unknown field name : " + expr);
    }

    private void addGroupByForDistinctFieldsInSelect(SQLExpr expr, Field field) {
        SQLSelectQueryBlock queryBlock;
        if (expr.getParent() != null && expr.getParent() instanceof SQLSelectItem && expr.getParent().getParent() != null && expr.getParent().getParent() instanceof SQLSelectQueryBlock && (queryBlock = (SQLSelectQueryBlock)expr.getParent().getParent()).getDistionOption() == 2) {
            SQLAggregateOption option = SQLAggregateOption.DISTINCT;
            field.setAggregationOption(option);
            if (queryBlock.getGroupBy() == null) {
                queryBlock.setGroupBy(new SQLSelectGroupByClause());
            }
            SQLSelectGroupByClause groupByClause = queryBlock.getGroupBy();
            groupByClause.addItem(expr);
            queryBlock.setGroupBy(groupByClause);
        }
    }

    private static Object getScriptValue(SQLExpr expr) throws SqlParseException {
        return Util.getScriptValue(expr);
    }

    private Field makeScriptMethodField(SQLBinaryOpExpr binaryExpr, String alias, String tableAlias) throws SqlParseException {
        ArrayList<SQLExpr> params = new ArrayList<SQLExpr>();
        String scriptFieldAlias = alias == null || alias.equals("") ? binaryExpr.toString() : alias;
        params.add((SQLExpr)new SQLCharExpr(scriptFieldAlias));
        Object left = FieldMaker.getScriptValue(binaryExpr.getLeft());
        Object right = FieldMaker.getScriptValue(binaryExpr.getRight());
        String script = String.format("%s %s %s", left, binaryExpr.getOperator().getName(), right);
        params.add((SQLExpr)new SQLCharExpr(script));
        return this.makeMethodField("script", params, null, null, tableAlias, false);
    }

    private static Field makeFilterMethodField(SQLMethodInvokeExpr filterMethod, String alias) throws SqlParseException {
        List parameters = filterMethod.getParameters();
        int parametersSize = parameters.size();
        if (parametersSize != 1 && parametersSize != 2) {
            throw new SqlParseException("filter group by field should only have one or 2 parameters filter(Expr) or filter(name,Expr)");
        }
        String filterAlias = filterMethod.getMethodName();
        SQLExpr exprToCheck = null;
        if (parametersSize == 1) {
            exprToCheck = (SQLExpr)parameters.get(0);
            filterAlias = "filter(" + exprToCheck.toString().replaceAll("\n", " ") + ")";
        }
        if (parametersSize == 2) {
            filterAlias = Util.extendedToString((SQLExpr)parameters.get(0));
            exprToCheck = (SQLExpr)parameters.get(1);
        }
        Where where = Where.newInstance();
        new WhereParser(new SqlParser()).parseWhere(exprToCheck, where);
        if (where.getWheres().size() == 0) {
            throw new SqlParseException("Failed to parse filter condition");
        }
        ArrayList<KVValue> methodParameters = new ArrayList<KVValue>();
        methodParameters.add(new KVValue("where", where));
        methodParameters.add(new KVValue("alias", filterAlias + "@FILTER"));
        return new MethodField("filter", methodParameters, null, alias);
    }

    private static Field handleIdentifier(NestedType nestedType, String alias, String tableAlias) {
        Field field = FieldMaker.handleIdentifier((SQLExpr)new SQLIdentifierExpr(nestedType.field), alias, tableAlias);
        field.setNested(nestedType);
        field.setChildren(null);
        return field;
    }

    private static Field handleIdentifier(ChildrenType childrenType, String alias, String tableAlias) {
        Field field = FieldMaker.handleIdentifier((SQLExpr)new SQLIdentifierExpr(childrenType.field), alias, tableAlias);
        field.setNested(null);
        field.setChildren(childrenType);
        return field;
    }

    public SQLMethodInvokeExpr makeBinaryMethodField(SQLBinaryOpExpr expr, String alias, boolean first) throws SqlParseException {
        ArrayList<SQLCharExpr> params = new ArrayList<SQLCharExpr>();
        String scriptFieldAlias = first && (alias == null || alias.equals("")) ? this.sqlFunctions.nextId("field") : alias;
        params.add(new SQLCharExpr(scriptFieldAlias));
        switch (expr.getOperator()) {
            case Add: {
                return FieldMaker.convertBinaryOperatorToMethod("add", expr);
            }
            case Multiply: {
                return FieldMaker.convertBinaryOperatorToMethod("multiply", expr);
            }
            case Divide: {
                return FieldMaker.convertBinaryOperatorToMethod("divide", expr);
            }
            case Modulus: {
                return FieldMaker.convertBinaryOperatorToMethod("modulus", expr);
            }
            case Subtract: {
                return FieldMaker.convertBinaryOperatorToMethod("subtract", expr);
            }
        }
        throw new SqlParseException("Unsupported operator: " + expr.getOperator().getName());
    }

    private static SQLMethodInvokeExpr convertBinaryOperatorToMethod(String operator, SQLBinaryOpExpr expr) {
        SQLMethodInvokeExpr methodInvokeExpr = new SQLMethodInvokeExpr(operator, null);
        methodInvokeExpr.addParameter(expr.getLeft());
        methodInvokeExpr.addParameter(expr.getRight());
        methodInvokeExpr.putAttribute("source", (Object)expr);
        return methodInvokeExpr;
    }

    private static Field handleIdentifier(SQLExpr expr, String alias, String tableAlias) {
        String aliasPrefix;
        String name;
        String newFieldName = name = expr.toString().replace("`", "");
        Field field = null;
        if (tableAlias != null && name.startsWith(aliasPrefix = tableAlias + ".")) {
            newFieldName = name.replaceFirst(aliasPrefix, "");
            field = new Field(newFieldName, alias);
        }
        if (tableAlias == null) {
            field = new Field(newFieldName, alias);
        }
        return field;
    }

    public MethodField makeMethodField(String name, List<SQLExpr> arguments, SQLAggregateOption option, String alias, String tableAlias, boolean first) throws SqlParseException {
        LinkedList<KVValue> paramers = new LinkedList<KVValue>();
        for (SQLExpr object : arguments) {
            MethodField abc;
            if (object instanceof SQLBinaryOpExpr) {
                SQLBinaryOpExpr binaryOpExpr = (SQLBinaryOpExpr)object;
                if (SQLFunctions.isFunctionTranslatedToScript(binaryOpExpr.getOperator().toString())) {
                    SQLMethodInvokeExpr mExpr = this.makeBinaryMethodField(binaryOpExpr, alias, first);
                    abc = this.makeMethodField(mExpr.getMethodName(), mExpr.getParameters(), null, null, tableAlias, false);
                    paramers.add(new KVValue(abc.getParams().get(0).toString(), new SQLCharExpr(abc.getParams().get(1).toString())));
                    continue;
                }
                if (!binaryOpExpr.getOperator().getName().equals("=")) {
                    paramers.add(new KVValue("script", this.makeScriptMethodField(binaryOpExpr, null, tableAlias)));
                    continue;
                }
                SQLExpr right = binaryOpExpr.getRight();
                Object value = Util.expr2Object(right);
                paramers.add(new KVValue(binaryOpExpr.getLeft().toString(), value));
                continue;
            }
            if (object instanceof SQLMethodInvokeExpr) {
                SQLMethodInvokeExpr mExpr = (SQLMethodInvokeExpr)object;
                String methodName = mExpr.getMethodName().toLowerCase();
                if (methodName.equals("script")) {
                    KVValue script = new KVValue("script", this.makeMethodField(mExpr.getMethodName(), mExpr.getParameters(), null, alias, tableAlias, true));
                    paramers.add(script);
                    continue;
                }
                if (methodName.equals("nested") || methodName.equals("reverse_nested")) {
                    NestedType nestedType = new NestedType();
                    if (!nestedType.tryFillFromExpr(object)) {
                        throw new SqlParseException("Failed to parse nested expression: " + object);
                    }
                    paramers.add(new KVValue(methodName, nestedType));
                    continue;
                }
                if (methodName.equals("children")) {
                    ChildrenType childrenType = new ChildrenType();
                    if (!childrenType.tryFillFromExpr(object)) {
                        throw new SqlParseException("Failed to parse children expression: " + object);
                    }
                    paramers.add(new KVValue("children", childrenType));
                    continue;
                }
                if (SQLFunctions.isFunctionTranslatedToScript(methodName)) {
                    abc = this.makeMethodField(methodName, mExpr.getParameters(), null, null, tableAlias, false);
                    paramers.add(new KVValue(abc.getParams().get(0).toString(), new SQLCharExpr(abc.getParams().get(1).toString())));
                    continue;
                }
                throw new SqlParseException("only support script/nested/children as inner functions");
            }
            if (object instanceof SQLCaseExpr) {
                String scriptCode = new CaseWhenParser((SQLCaseExpr)object, alias, tableAlias).parse();
                paramers.add(new KVValue("script", new SQLCharExpr(scriptCode)));
                continue;
            }
            if (object instanceof SQLCastExpr) {
                String castName = this.sqlFunctions.nextId("cast");
                ArrayList<KVValue> methodParameters = new ArrayList<KVValue>();
                methodParameters.add(new KVValue(((SQLCastExpr)object).getExpr().toString()));
                String castType = ((SQLCastExpr)object).getDataType().getName();
                String scriptCode = this.sqlFunctions.getCastScriptStatement(castName, castType, methodParameters);
                if (first) {
                    scriptCode = scriptCode + "; return " + castName;
                }
                methodParameters.add(new KVValue(scriptCode));
                paramers.add(new KVValue("script", new SQLCharExpr(scriptCode)));
                continue;
            }
            if (object instanceof SQLAggregateExpr) {
                SQLObject parent = object.getParent();
                SQLExpr source = (SQLExpr)parent.getAttribute("source");
                if (parent instanceof SQLMethodInvokeExpr && source == null) {
                    throw new SqlFeatureNotImplementedException("Function calls of form '" + ((SQLMethodInvokeExpr)parent).getMethodName() + "(" + ((SQLAggregateExpr)object).getMethodName() + "(...))' are not implemented yet");
                }
                throw new SqlFeatureNotImplementedException("The complex aggregate expressions are not implemented yet: " + source);
            }
            paramers.add(new KVValue(Util.removeTableAilasFromField(object, tableAlias)));
        }
        boolean builtInScriptFunction = SQLFunctions.isFunctionTranslatedToScript(name);
        if (builtInScriptFunction) {
            if (alias == null && first) {
                alias = this.sqlFunctions.nextId(name);
            }
            Tuple<String, String> newFunctions = this.sqlFunctions.function(name.toLowerCase(), paramers, paramers.isEmpty() ? null : ((KVValue)paramers.get((int)0)).key, first);
            paramers.clear();
            if (!first) {
                paramers.add(new KVValue(newFunctions.v1()));
            } else {
                paramers.add(new KVValue(alias));
            }
            paramers.add(new KVValue(newFunctions.v2()));
        }
        if (first) {
            LinkedList<KVValue> tempParamers = new LinkedList<KVValue>();
            for (KVValue temp : paramers) {
                if (temp.value instanceof SQLExpr) {
                    tempParamers.add(new KVValue(temp.key, Util.expr2Object((SQLExpr)temp.value)));
                    continue;
                }
                tempParamers.add(new KVValue(temp.key, temp.value));
            }
            paramers.clear();
            paramers.addAll(tempParamers);
        }
        if (builtInScriptFunction) {
            return new ScriptMethodField(name, paramers, option, alias);
        }
        return new MethodField(name, paramers, option, alias);
    }
}

