/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.opendistroforelasticsearch.sql.legacy.expression.model;

import com.amazon.opendistroforelasticsearch.sql.legacy.expression.model.ExprValue;
import com.google.common.annotations.VisibleForTesting;
import java.util.List;
import java.util.Map;

public class ExprValueUtils {
    public static Integer getIntegerValue(ExprValue exprValue) {
        return ExprValueUtils.getNumberValue(exprValue).intValue();
    }

    public static Double getDoubleValue(ExprValue exprValue) {
        return ExprValueUtils.getNumberValue(exprValue).doubleValue();
    }

    public static Long getLongValue(ExprValue exprValue) {
        return ExprValueUtils.getNumberValue(exprValue).longValue();
    }

    public static Float getFloatValue(ExprValue exprValue) {
        return Float.valueOf(ExprValueUtils.getNumberValue(exprValue).floatValue());
    }

    public static String getStringValue(ExprValue exprValue) {
        return (String)ExprValueUtils.convert(exprValue, ExprValue.ExprValueKind.STRING_VALUE);
    }

    public static List<ExprValue> getCollectionValue(ExprValue exprValue) {
        return (List)ExprValueUtils.convert(exprValue, ExprValue.ExprValueKind.COLLECTION_VALUE);
    }

    public static Map<String, ExprValue> getTupleValue(ExprValue exprValue) {
        return (Map)ExprValueUtils.convert(exprValue, ExprValue.ExprValueKind.TUPLE_VALUE);
    }

    public static Boolean getBooleanValue(ExprValue exprValue) {
        return (Boolean)ExprValueUtils.convert(exprValue, ExprValue.ExprValueKind.BOOLEAN_VALUE);
    }

    @VisibleForTesting
    public static Number getNumberValue(ExprValue exprValue) {
        switch (exprValue.kind()) {
            case INTEGER_VALUE: 
            case DOUBLE_VALUE: 
            case LONG_VALUE: 
            case FLOAT_VALUE: {
                return (Number)exprValue.value();
            }
        }
        throw new IllegalStateException(String.format("invalid to get NUMBER_VALUE from expr type of %s", new Object[]{exprValue.kind()}));
    }

    private static <T> T convert(ExprValue exprValue, ExprValue.ExprValueKind toType) {
        if (exprValue.kind() == toType) {
            return (T)exprValue.value();
        }
        throw new IllegalStateException(String.format("invalid to get %s from expr type of %s", new Object[]{toType, exprValue.kind()}));
    }
}

