/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.opendistroforelasticsearch.sql.legacy.expression.model;

import com.amazon.opendistroforelasticsearch.sql.legacy.expression.model.ExprBooleanValue;
import com.amazon.opendistroforelasticsearch.sql.legacy.expression.model.ExprCollectionValue;
import com.amazon.opendistroforelasticsearch.sql.legacy.expression.model.ExprDoubleValue;
import com.amazon.opendistroforelasticsearch.sql.legacy.expression.model.ExprIntegerValue;
import com.amazon.opendistroforelasticsearch.sql.legacy.expression.model.ExprLongValue;
import com.amazon.opendistroforelasticsearch.sql.legacy.expression.model.ExprStringValue;
import com.amazon.opendistroforelasticsearch.sql.legacy.expression.model.ExprTupleValue;
import com.amazon.opendistroforelasticsearch.sql.legacy.expression.model.ExprValue;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ExprValueFactory {
    public static ExprValue booleanValue(Boolean value) {
        return new ExprBooleanValue(value);
    }

    public static ExprValue integerValue(Integer value) {
        return new ExprIntegerValue(value);
    }

    public static ExprValue doubleValue(Double value) {
        return new ExprDoubleValue(value);
    }

    public static ExprValue stringValue(String value) {
        return new ExprStringValue(value);
    }

    public static ExprValue longValue(Long value) {
        return new ExprLongValue(value);
    }

    public static ExprValue tupleValue(Map<String, Object> map) {
        HashMap<String, ExprValue> valueMap = new HashMap<String, ExprValue>();
        map.forEach((k, v) -> valueMap.put((String)k, ExprValueFactory.from(v)));
        return new ExprTupleValue(valueMap);
    }

    public static ExprValue collectionValue(List<Object> list) {
        ArrayList<ExprValue> valueList = new ArrayList<ExprValue>();
        list.forEach(o -> valueList.add(ExprValueFactory.from(o)));
        return new ExprCollectionValue(valueList);
    }

    public static ExprValue from(Object o) {
        if (o instanceof Map) {
            return ExprValueFactory.tupleValue((Map)o);
        }
        if (o instanceof List) {
            return ExprValueFactory.collectionValue((List)o);
        }
        if (o instanceof Integer) {
            return ExprValueFactory.integerValue((Integer)o);
        }
        if (o instanceof Long) {
            return ExprValueFactory.longValue((Long)o);
        }
        if (o instanceof Boolean) {
            return ExprValueFactory.booleanValue((Boolean)o);
        }
        if (o instanceof Double) {
            return ExprValueFactory.doubleValue((Double)o);
        }
        if (o instanceof String) {
            return ExprValueFactory.stringValue((String)o);
        }
        throw new IllegalStateException("unsupported type " + o.getClass());
    }
}

