/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.opendistroforelasticsearch.sql.legacy.expression.core.operator;

import com.amazon.opendistroforelasticsearch.sql.legacy.expression.core.operator.ScalarOperation;
import com.amazon.opendistroforelasticsearch.sql.legacy.expression.core.operator.ScalarOperator;
import com.amazon.opendistroforelasticsearch.sql.legacy.expression.model.ExprValue;
import com.amazon.opendistroforelasticsearch.sql.legacy.expression.model.ExprValueFactory;
import com.amazon.opendistroforelasticsearch.sql.legacy.expression.model.ExprValueUtils;
import java.util.List;
import java.util.function.Function;

public class UnaryScalarOperator
implements ScalarOperator {
    private final ScalarOperation op;
    private final Function<Integer, Integer> integerFunc;
    private final Function<Long, Long> longFunc;
    private final Function<Double, Double> doubleFunc;
    private final Function<Float, Float> floatFunc;

    @Override
    public ExprValue apply(List<ExprValue> exprValues) {
        ExprValue exprValue = exprValues.get(0);
        switch (exprValue.kind()) {
            case DOUBLE_VALUE: {
                return ExprValueFactory.from(this.doubleFunc.apply(ExprValueUtils.getDoubleValue(exprValue)));
            }
            case INTEGER_VALUE: {
                return ExprValueFactory.from(this.integerFunc.apply(ExprValueUtils.getIntegerValue(exprValue)));
            }
            case LONG_VALUE: {
                return ExprValueFactory.from(this.longFunc.apply(ExprValueUtils.getLongValue(exprValue)));
            }
            case FLOAT_VALUE: {
                return ExprValueFactory.from(this.floatFunc.apply(ExprValueUtils.getFloatValue(exprValue)));
            }
        }
        throw new RuntimeException(String.format("unexpected operation type: %s(%s)", new Object[]{this.op.name(), exprValue.kind()}));
    }

    @Override
    public String name() {
        return this.op.name();
    }

    public UnaryScalarOperator(ScalarOperation op, Function<Integer, Integer> integerFunc, Function<Long, Long> longFunc, Function<Double, Double> doubleFunc, Function<Float, Float> floatFunc) {
        this.op = op;
        this.integerFunc = integerFunc;
        this.longFunc = longFunc;
        this.doubleFunc = doubleFunc;
        this.floatFunc = floatFunc;
    }
}

