/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.opendistroforelasticsearch.sql.legacy.expression.core.operator;

import com.amazon.opendistroforelasticsearch.sql.legacy.expression.core.operator.ScalarOperation;
import com.amazon.opendistroforelasticsearch.sql.legacy.expression.core.operator.ScalarOperator;
import com.amazon.opendistroforelasticsearch.sql.legacy.expression.model.ExprValue;
import com.amazon.opendistroforelasticsearch.sql.legacy.expression.model.ExprValueFactory;
import com.amazon.opendistroforelasticsearch.sql.legacy.expression.model.ExprValueUtils;
import java.util.List;
import java.util.function.Function;

public class DoubleUnaryScalarOperator
implements ScalarOperator {
    private final ScalarOperation op;
    private final Function<Double, Double> doubleFunc;

    @Override
    public ExprValue apply(List<ExprValue> exprValues) {
        ExprValue exprValue = exprValues.get(0);
        switch (exprValue.kind()) {
            case DOUBLE_VALUE: 
            case INTEGER_VALUE: 
            case LONG_VALUE: 
            case FLOAT_VALUE: {
                return ExprValueFactory.from(this.doubleFunc.apply(ExprValueUtils.getDoubleValue(exprValue)));
            }
        }
        throw new RuntimeException(String.format("unexpected operation type: %s(%s)", new Object[]{this.op.name(), exprValue.kind()}));
    }

    @Override
    public String name() {
        return this.op.name();
    }

    public DoubleUnaryScalarOperator(ScalarOperation op, Function<Double, Double> doubleFunc) {
        this.op = op;
        this.doubleFunc = doubleFunc;
    }
}

