/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.opendistroforelasticsearch.sql.legacy.expression.core.operator;

import com.amazon.opendistroforelasticsearch.sql.legacy.expression.core.operator.ScalarOperation;
import com.amazon.opendistroforelasticsearch.sql.legacy.expression.core.operator.ScalarOperator;
import com.amazon.opendistroforelasticsearch.sql.legacy.expression.model.ExprValue;
import com.amazon.opendistroforelasticsearch.sql.legacy.expression.model.ExprValueFactory;
import com.amazon.opendistroforelasticsearch.sql.legacy.expression.model.ExprValueUtils;
import java.util.List;
import java.util.function.BiFunction;

public class DoubleBinaryScalarOperator
implements ScalarOperator {
    private final ScalarOperation op;
    private final BiFunction<Double, Double, Double> doubleFunc;

    @Override
    public ExprValue apply(List<ExprValue> exprValues) {
        ExprValue exprValue1 = exprValues.get(0);
        ExprValue exprValue2 = exprValues.get(1);
        if (exprValue1.kind() != exprValue2.kind()) {
            throw new RuntimeException(String.format("unexpected operation type: %s(%s,%s)", new Object[]{this.op.name(), exprValue1.kind(), exprValue2.kind()}));
        }
        switch (exprValue1.kind()) {
            case DOUBLE_VALUE: 
            case INTEGER_VALUE: 
            case LONG_VALUE: 
            case FLOAT_VALUE: {
                return ExprValueFactory.from(this.doubleFunc.apply(ExprValueUtils.getDoubleValue(exprValue1), ExprValueUtils.getDoubleValue(exprValue2)));
            }
        }
        throw new RuntimeException(String.format("unexpected operation type: %s(%s,%s)", new Object[]{this.op.name(), exprValue1.kind(), exprValue2.kind()}));
    }

    @Override
    public String name() {
        return this.op.name();
    }

    public DoubleBinaryScalarOperator(ScalarOperation op, BiFunction<Double, Double, Double> doubleFunc) {
        this.op = op;
        this.doubleFunc = doubleFunc;
    }
}

