/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.opendistroforelasticsearch.sql.legacy.executor.format;

import com.amazon.opendistroforelasticsearch.sql.legacy.cursor.Cursor;
import com.amazon.opendistroforelasticsearch.sql.legacy.cursor.DefaultCursor;
import com.amazon.opendistroforelasticsearch.sql.legacy.exception.SqlParseException;
import com.amazon.opendistroforelasticsearch.sql.legacy.executor.QueryActionElasticExecutor;
import com.amazon.opendistroforelasticsearch.sql.legacy.executor.RestExecutor;
import com.amazon.opendistroforelasticsearch.sql.legacy.executor.format.Protocol;
import com.amazon.opendistroforelasticsearch.sql.legacy.query.DefaultQueryAction;
import com.amazon.opendistroforelasticsearch.sql.legacy.query.QueryAction;
import com.amazon.opendistroforelasticsearch.sql.legacy.query.join.BackOffRetryStrategy;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.client.Client;
import org.elasticsearch.common.Strings;
import org.elasticsearch.rest.BytesRestResponse;
import org.elasticsearch.rest.RestChannel;
import org.elasticsearch.rest.RestResponse;
import org.elasticsearch.rest.RestStatus;

public class PrettyFormatRestExecutor
implements RestExecutor {
    private static final Logger LOG = LogManager.getLogger();
    private final String format;

    public PrettyFormatRestExecutor(String format) {
        this.format = format.toLowerCase();
    }

    @Override
    public void execute(Client client, Map<String, String> params, QueryAction queryAction, RestChannel channel) {
        String formattedResponse = this.execute(client, params, queryAction);
        BytesRestResponse bytesRestResponse = this.format.equals("jdbc") ? new BytesRestResponse(RestStatus.OK, "application/json; charset=UTF-8", formattedResponse) : new BytesRestResponse(RestStatus.OK, formattedResponse);
        if (!BackOffRetryStrategy.isHealthy(2 * bytesRestResponse.content().length(), this)) {
            throw new IllegalStateException("[PrettyFormatRestExecutor] Memory could be insufficient when sendResponse().");
        }
        channel.sendResponse((RestResponse)bytesRestResponse);
    }

    @Override
    public String execute(Client client, Map<String, String> params, QueryAction queryAction) {
        Protocol protocol;
        try {
            if (queryAction instanceof DefaultQueryAction) {
                protocol = this.buildProtocolForDefaultQuery(client, (DefaultQueryAction)queryAction);
            } else {
                Object queryResult = QueryActionElasticExecutor.executeAnyAction(client, queryAction);
                protocol = new Protocol(client, queryAction, queryResult, this.format, Cursor.NULL_CURSOR);
            }
        }
        catch (Exception e) {
            if (e instanceof ElasticsearchException) {
                LOG.warn("An error occurred in Elasticsearch engine: " + ((ElasticsearchException)((Object)e)).getDetailedMessage(), (Throwable)e);
            } else {
                LOG.warn("Error happened in pretty formatter", (Throwable)e);
            }
            protocol = new Protocol(e);
        }
        return protocol.format();
    }

    private Protocol buildProtocolForDefaultQuery(Client client, DefaultQueryAction queryAction) throws SqlParseException {
        Protocol protocol;
        SearchResponse response = (SearchResponse)queryAction.explain().get();
        String scrollId = response.getScrollId();
        if (!Strings.isNullOrEmpty((String)scrollId)) {
            DefaultCursor defaultCursor = new DefaultCursor();
            defaultCursor.setScrollId(scrollId);
            defaultCursor.setLimit(queryAction.getSelect().getRowCount());
            defaultCursor.setFetchSize(queryAction.getSqlRequest().fetchSize());
            protocol = new Protocol(client, queryAction, response.getHits(), this.format, defaultCursor);
        } else {
            protocol = new Protocol(client, queryAction, response.getHits(), this.format, Cursor.NULL_CURSOR);
        }
        return protocol;
    }
}

