/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.opendistroforelasticsearch.sql.legacy.executor.format;

import com.amazon.opendistroforelasticsearch.sql.legacy.executor.format.ErrorMessage;
import com.amazon.opendistroforelasticsearch.sql.legacy.utils.StringUtils;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.action.search.SearchPhaseExecutionException;
import org.elasticsearch.action.search.ShardSearchFailure;

public class ElasticsearchErrorMessage
extends ErrorMessage<ElasticsearchException> {
    ElasticsearchErrorMessage(ElasticsearchException exception, int status) {
        super(exception, status);
    }

    @Override
    protected String fetchReason() {
        return "Error occurred in Elasticsearch engine: " + ((ElasticsearchException)((Object)this.exception)).getMessage();
    }

    @Override
    protected String fetchDetails() {
        StringBuilder details = new StringBuilder();
        if (this.exception instanceof SearchPhaseExecutionException) {
            details.append(this.fetchSearchPhaseExecutionExceptionDetails((SearchPhaseExecutionException)this.exception));
        } else {
            details.append(this.defaultDetails((ElasticsearchException)((Object)this.exception)));
        }
        details.append("\nFor more details, please send request for Json format to see the raw response from elasticsearch engine.");
        return details.toString();
    }

    private String defaultDetails(ElasticsearchException exception) {
        return exception.getDetailedMessage();
    }

    private String fetchSearchPhaseExecutionExceptionDetails(SearchPhaseExecutionException exception) {
        ShardSearchFailure[] shardFailures;
        StringBuilder details = new StringBuilder();
        for (ShardSearchFailure failure : shardFailures = exception.shardFailures()) {
            details.append(StringUtils.format("Shard[%d]: %s\n", failure.shardId(), failure.getCause().toString()));
        }
        return details.toString();
    }
}

