/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.opendistroforelasticsearch.sql.legacy.executor.cursor;

import com.amazon.opendistroforelasticsearch.sql.legacy.cursor.CursorType;
import com.amazon.opendistroforelasticsearch.sql.legacy.cursor.DefaultCursor;
import com.amazon.opendistroforelasticsearch.sql.legacy.esdomain.LocalClusterState;
import com.amazon.opendistroforelasticsearch.sql.legacy.executor.Format;
import com.amazon.opendistroforelasticsearch.sql.legacy.executor.cursor.CursorRestExecutor;
import com.amazon.opendistroforelasticsearch.sql.legacy.executor.format.Protocol;
import com.amazon.opendistroforelasticsearch.sql.legacy.metrics.MetricName;
import com.amazon.opendistroforelasticsearch.sql.legacy.metrics.Metrics;
import com.amazon.opendistroforelasticsearch.sql.legacy.rewriter.matchtoterm.VerificationException;
import java.util.Arrays;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.action.search.ClearScrollResponse;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.client.Client;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.rest.BytesRestResponse;
import org.elasticsearch.rest.RestChannel;
import org.elasticsearch.rest.RestResponse;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.search.SearchHit;
import org.elasticsearch.search.SearchHits;
import org.json.JSONException;

public class CursorResultExecutor
implements CursorRestExecutor {
    private String cursorId;
    private Format format;
    private static final Logger LOG = LogManager.getLogger(CursorResultExecutor.class);

    public CursorResultExecutor(String cursorId, Format format) {
        this.cursorId = cursorId;
        this.format = format;
    }

    @Override
    public void execute(Client client, Map<String, String> params, RestChannel channel) throws Exception {
        try {
            String formattedResponse = this.execute(client, params);
            channel.sendResponse((RestResponse)new BytesRestResponse(RestStatus.OK, "application/json; charset=UTF-8", formattedResponse));
        }
        catch (IllegalArgumentException | JSONException e) {
            Metrics.getInstance().getNumericalMetric(MetricName.FAILED_REQ_COUNT_CUS).increment();
            LOG.error("Error parsing the cursor", e);
            channel.sendResponse((RestResponse)new BytesRestResponse(channel, (Exception)e));
        }
        catch (ElasticsearchException e) {
            int status = e.status().getStatus();
            if (status > 399 && status < 500) {
                Metrics.getInstance().getNumericalMetric(MetricName.FAILED_REQ_COUNT_CUS).increment();
            } else if (status > 499) {
                Metrics.getInstance().getNumericalMetric(MetricName.FAILED_REQ_COUNT_SYS).increment();
            }
            LOG.error("Error completing cursor request", (Throwable)e);
            channel.sendResponse((RestResponse)new BytesRestResponse(channel, (Exception)((Object)e)));
        }
    }

    @Override
    public String execute(Client client, Map<String, String> params) throws Exception {
        String[] splittedCursor = this.cursorId.split(":", 2);
        if (splittedCursor.length != 2) {
            throw new VerificationException("Not able to parse invalid cursor");
        }
        String type = splittedCursor[0];
        CursorType cursorType = CursorType.getById(type);
        switch (cursorType) {
            case DEFAULT: {
                DefaultCursor defaultCursor = DefaultCursor.from(splittedCursor[1]);
                return this.handleDefaultCursorRequest(client, defaultCursor);
            }
        }
        throw new VerificationException("Unsupported cursor type [" + type + "]");
    }

    private String handleDefaultCursorRequest(Client client, DefaultCursor cursor) {
        ClearScrollResponse clearScrollResponse;
        int fetch;
        String previousScrollId = cursor.getScrollId();
        LocalClusterState clusterState = LocalClusterState.state();
        TimeValue scrollTimeout = (TimeValue)clusterState.getSettingValue("opendistro.sql.cursor.keep_alive");
        SearchResponse scrollResponse = (SearchResponse)client.prepareSearchScroll(previousScrollId).setScroll(scrollTimeout).get();
        SearchHits searchHits = scrollResponse.getHits();
        SearchHit[] searchHitArray = searchHits.getHits();
        String newScrollId = scrollResponse.getScrollId();
        int rowsLeft = (int)cursor.getRowsLeft();
        if (rowsLeft < (fetch = cursor.getFetchSize().intValue()) && rowsLeft < searchHitArray.length) {
            SearchHit[] newSearchHits = Arrays.copyOf(searchHitArray, rowsLeft);
            searchHits = new SearchHits(newSearchHits, searchHits.getTotalHits(), searchHits.getMaxScore());
        }
        if ((rowsLeft -= fetch) <= 0 && !(clearScrollResponse = (ClearScrollResponse)client.prepareClearScroll().addScrollId(newScrollId).get()).isSucceeded()) {
            Metrics.getInstance().getNumericalMetric(MetricName.FAILED_REQ_COUNT_SYS).increment();
            LOG.info("Error closing the cursor context {} ", (Object)newScrollId);
        }
        cursor.setRowsLeft(rowsLeft);
        cursor.setScrollId(newScrollId);
        Protocol protocol = new Protocol(client, searchHits, this.format.name().toLowerCase(), cursor);
        return protocol.cursorFormat();
    }
}

