/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.opendistroforelasticsearch.sql.legacy.executor.cursor;

import com.amazon.opendistroforelasticsearch.sql.legacy.esdomain.LocalClusterState;
import com.amazon.opendistroforelasticsearch.sql.legacy.executor.cursor.CursorRestExecutor;
import com.amazon.opendistroforelasticsearch.sql.legacy.metrics.MetricName;
import com.amazon.opendistroforelasticsearch.sql.legacy.metrics.Metrics;
import com.amazon.opendistroforelasticsearch.sql.legacy.query.join.BackOffRetryStrategy;
import com.amazon.opendistroforelasticsearch.sql.legacy.utils.LogUtils;
import java.io.IOException;
import java.time.Duration;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.client.Client;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.rest.BytesRestResponse;
import org.elasticsearch.rest.RestChannel;
import org.elasticsearch.rest.RestResponse;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.threadpool.ThreadPool;

public class CursorAsyncRestExecutor {
    public static final String SQL_WORKER_THREAD_POOL_NAME = "sql-worker";
    private static final Logger LOG = LogManager.getLogger(CursorAsyncRestExecutor.class);
    private final CursorRestExecutor executor;

    CursorAsyncRestExecutor(CursorRestExecutor executor) {
        this.executor = executor;
    }

    public void execute(Client client, Map<String, String> params, RestChannel channel) {
        this.async(client, params, channel);
    }

    private void async(Client client, Map<String, String> params, RestChannel channel) {
        ThreadPool threadPool = client.threadPool();
        Runnable runnable = () -> {
            try {
                this.doExecuteWithTimeMeasured(client, params, channel);
            }
            catch (IOException e) {
                Metrics.getInstance().getNumericalMetric(MetricName.FAILED_REQ_COUNT_SYS).increment();
                LOG.warn("[{}] [MCB] async task got an IO/SQL exception: {}", (Object)LogUtils.getRequestId(), (Object)e.getMessage());
                e.printStackTrace();
                channel.sendResponse((RestResponse)new BytesRestResponse(RestStatus.INTERNAL_SERVER_ERROR, e.getMessage()));
            }
            catch (IllegalStateException e) {
                Metrics.getInstance().getNumericalMetric(MetricName.FAILED_REQ_COUNT_SYS).increment();
                LOG.warn("[{}] [MCB] async task got a runtime exception: {}", (Object)LogUtils.getRequestId(), (Object)e.getMessage());
                e.printStackTrace();
                channel.sendResponse((RestResponse)new BytesRestResponse(RestStatus.INSUFFICIENT_STORAGE, "Memory circuit is broken."));
            }
            catch (Throwable t) {
                Metrics.getInstance().getNumericalMetric(MetricName.FAILED_REQ_COUNT_SYS).increment();
                LOG.warn("[{}] [MCB] async task got an unknown throwable: {}", (Object)LogUtils.getRequestId(), (Object)t.getMessage());
                t.printStackTrace();
                channel.sendResponse((RestResponse)new BytesRestResponse(RestStatus.INTERNAL_SERVER_ERROR, String.valueOf(t.getMessage())));
            }
            finally {
                BackOffRetryStrategy.releaseMem(this.executor);
            }
        };
        threadPool.schedule(LogUtils.withCurrentContext(runnable), new TimeValue(0L), SQL_WORKER_THREAD_POOL_NAME);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doExecuteWithTimeMeasured(Client client, Map<String, String> params, RestChannel channel) throws Exception {
        long startTime = System.nanoTime();
        try {
            this.executor.execute(client, params, channel);
        }
        finally {
            Duration elapsed = Duration.ofNanos(System.nanoTime() - startTime);
            int slowLogThreshold = (Integer)LocalClusterState.state().getSettingValue("opendistro.sql.query.slowlog");
            if (elapsed.getSeconds() >= (long)slowLogThreshold) {
                LOG.warn("[{}] Slow query: elapsed={} (ms)", (Object)LogUtils.getRequestId(), (Object)elapsed.toMillis());
            }
        }
    }
}

