/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.opendistroforelasticsearch.sql.legacy.executor.csv;

import com.amazon.opendistroforelasticsearch.sql.legacy.executor.csv.CSVResult;
import com.amazon.opendistroforelasticsearch.sql.legacy.executor.csv.CsvExtractorException;
import com.amazon.opendistroforelasticsearch.sql.legacy.expression.model.ExprValue;
import com.amazon.opendistroforelasticsearch.sql.legacy.utils.Util;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.elasticsearch.common.document.DocumentField;
import org.elasticsearch.search.SearchHit;
import org.elasticsearch.search.SearchHits;
import org.elasticsearch.search.aggregations.Aggregation;
import org.elasticsearch.search.aggregations.Aggregations;
import org.elasticsearch.search.aggregations.bucket.MultiBucketsAggregation;
import org.elasticsearch.search.aggregations.bucket.SingleBucketAggregation;
import org.elasticsearch.search.aggregations.metrics.ExtendedStats;
import org.elasticsearch.search.aggregations.metrics.GeoBounds;
import org.elasticsearch.search.aggregations.metrics.NumericMetricsAggregation;
import org.elasticsearch.search.aggregations.metrics.Percentile;
import org.elasticsearch.search.aggregations.metrics.Percentiles;
import org.elasticsearch.search.aggregations.metrics.Stats;
import org.elasticsearch.search.aggregations.metrics.TopHits;

public class CSVResultsExtractor {
    private final boolean includeType;
    private final boolean includeScore;
    private final boolean includeId;
    private int currentLineIndex;

    public CSVResultsExtractor(boolean includeScore, boolean includeType, boolean includeId) {
        this.includeScore = includeScore;
        this.includeType = includeType;
        this.includeId = includeId;
        this.currentLineIndex = 0;
    }

    public CSVResult extractResults(Object queryResult, boolean flat, String separator, List<String> fieldNames) throws CsvExtractorException {
        if (queryResult instanceof SearchHits) {
            SearchHit[] hits = ((SearchHits)queryResult).getHits();
            ArrayList<Map<String, Object>> docsAsMap = new ArrayList<Map<String, Object>>();
            List<String> headers = this.createHeadersAndFillDocsMap(flat, hits, docsAsMap, fieldNames);
            List<List<String>> csvLines = this.createCSVLinesFromDocs(flat, separator, docsAsMap, headers);
            return new CSVResult(separator, headers, csvLines);
        }
        if (queryResult instanceof Aggregations) {
            ArrayList<String> headers = new ArrayList<String>();
            ArrayList<List<String>> lines = new ArrayList<List<String>>();
            lines.add(new ArrayList());
            this.handleAggregations((Aggregations)queryResult, headers, lines);
            return new CSVResult(separator, headers, lines);
        }
        if (queryResult instanceof List) {
            List bindingTuples = (List)queryResult;
            List<List<String>> csvLines = bindingTuples.stream().map(tuple -> {
                Map<String, ExprValue> bindingMap = tuple.getBindingMap();
                ArrayList<String> rowValues = new ArrayList<String>();
                for (String fieldName : fieldNames) {
                    if (bindingMap.containsKey(fieldName)) {
                        rowValues.add(String.valueOf(bindingMap.get(fieldName).value()));
                        continue;
                    }
                    rowValues.add("");
                }
                return rowValues;
            }).collect(Collectors.toList());
            return new CSVResult(separator, fieldNames, csvLines);
        }
        return null;
    }

    private void handleAggregations(Aggregations aggregations, List<String> headers, List<List<String>> lines) throws CsvExtractorException {
        if (this.allNumericAggregations(aggregations)) {
            lines.get(this.currentLineIndex).addAll(this.fillHeaderAndCreateLineForNumericAggregations(aggregations, headers));
            return;
        }
        List aggregationList = aggregations.asList();
        if (aggregationList.size() > 1) {
            throw new CsvExtractorException("currently support only one aggregation at same level (Except for numeric metrics)");
        }
        Aggregation aggregation = (Aggregation)aggregationList.get(0);
        if (aggregation instanceof SingleBucketAggregation) {
            Aggregations singleBucketAggs = ((SingleBucketAggregation)aggregation).getAggregations();
            this.handleAggregations(singleBucketAggs, headers, lines);
            return;
        }
        if (aggregation instanceof NumericMetricsAggregation) {
            this.handleNumericMetricAggregation(headers, lines.get(this.currentLineIndex), aggregation);
            return;
        }
        if (aggregation instanceof GeoBounds) {
            this.handleGeoBoundsAggregation(headers, lines, (GeoBounds)aggregation);
            return;
        }
        if (aggregation instanceof TopHits) {
            // empty if block
        }
        if (aggregation instanceof MultiBucketsAggregation) {
            MultiBucketsAggregation bucketsAggregation = (MultiBucketsAggregation)aggregation;
            String name = bucketsAggregation.getName();
            if (!headers.contains(name)) {
                headers.add(name);
            }
            List buckets = bucketsAggregation.getBuckets();
            List<String> currentLine = lines.get(this.currentLineIndex);
            ArrayList<String> clonedLine = new ArrayList<String>(currentLine);
            boolean firstLine = true;
            for (MultiBucketsAggregation.Bucket bucket : buckets) {
                String key = bucket.getKeyAsString();
                if (firstLine) {
                    firstLine = false;
                } else {
                    ++this.currentLineIndex;
                    currentLine = new ArrayList<String>(clonedLine);
                    lines.add(currentLine);
                }
                currentLine.add(key);
                this.handleAggregations(bucket.getAggregations(), headers, lines);
            }
        }
    }

    private void handleGeoBoundsAggregation(List<String> headers, List<List<String>> lines, GeoBounds geoBoundsAggregation) {
        String geoBoundAggName = geoBoundsAggregation.getName();
        headers.add(geoBoundAggName + ".topLeft.lon");
        headers.add(geoBoundAggName + ".topLeft.lat");
        headers.add(geoBoundAggName + ".bottomRight.lon");
        headers.add(geoBoundAggName + ".bottomRight.lat");
        List<String> line = lines.get(this.currentLineIndex);
        line.add(String.valueOf(geoBoundsAggregation.topLeft().getLon()));
        line.add(String.valueOf(geoBoundsAggregation.topLeft().getLat()));
        line.add(String.valueOf(geoBoundsAggregation.bottomRight().getLon()));
        line.add(String.valueOf(geoBoundsAggregation.bottomRight().getLat()));
        lines.add(line);
    }

    private List<String> fillHeaderAndCreateLineForNumericAggregations(Aggregations aggregations, List<String> header) throws CsvExtractorException {
        ArrayList<String> line = new ArrayList<String>();
        List aggregationList = aggregations.asList();
        for (Aggregation aggregation : aggregationList) {
            this.handleNumericMetricAggregation(header, line, aggregation);
        }
        return line;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void handleNumericMetricAggregation(List<String> header, List<String> line, Aggregation aggregation) throws CsvExtractorException {
        String name = aggregation.getName();
        if (aggregation instanceof NumericMetricsAggregation.SingleValue) {
            NumericMetricsAggregation.SingleValue agg;
            if (!header.contains(name)) {
                header.add(name);
            }
            line.add(!Double.isInfinite((agg = (NumericMetricsAggregation.SingleValue)aggregation).value()) ? agg.getValueAsString() : "null");
            return;
        } else {
            if (!(aggregation instanceof NumericMetricsAggregation.MultiValue)) throw new CsvExtractorException("unknown NumericMetricsAggregation" + aggregation.getClass());
            if (aggregation instanceof Stats) {
                String[] statsHeaders = new String[]{"count", "sum", "avg", "min", "max"};
                boolean isExtendedStats = aggregation instanceof ExtendedStats;
                if (isExtendedStats) {
                    String[] extendedHeaders = new String[]{"sumOfSquares", "variance", "stdDeviation"};
                    statsHeaders = Util.concatStringsArrays(statsHeaders, extendedHeaders);
                }
                this.mergeHeadersWithPrefix(header, name, statsHeaders);
                Stats stats = (Stats)aggregation;
                line.add(String.valueOf(stats.getCount()));
                line.add(stats.getSumAsString());
                line.add(stats.getAvgAsString());
                line.add(stats.getMinAsString());
                line.add(stats.getMaxAsString());
                if (!isExtendedStats) return;
                ExtendedStats extendedStats = (ExtendedStats)aggregation;
                line.add(extendedStats.getSumOfSquaresAsString());
                line.add(extendedStats.getVarianceAsString());
                line.add(extendedStats.getStdDeviationAsString());
                return;
            } else {
                if (!(aggregation instanceof Percentiles)) throw new CsvExtractorException("unknown NumericMetricsAggregation.MultiValue:" + aggregation.getClass());
                ArrayList<String> percentileHeaders = new ArrayList<String>(7);
                Percentiles percentiles = (Percentiles)aggregation;
                for (Percentile p : percentiles) {
                    percentileHeaders.add(String.valueOf(p.getPercent()));
                    line.add(percentiles.percentileAsString(p.getPercent()));
                }
                this.mergeHeadersWithPrefix(header, name, percentileHeaders.toArray(new String[0]));
            }
        }
    }

    private void mergeHeadersWithPrefix(List<String> header, String prefix, String[] newHeaders) {
        for (int i = 0; i < newHeaders.length; ++i) {
            String newHeader = newHeaders[i];
            if (prefix != null && !prefix.equals("")) {
                newHeader = prefix + "." + newHeader;
            }
            if (header.contains(newHeader)) continue;
            header.add(newHeader);
        }
    }

    private boolean allNumericAggregations(Aggregations aggregations) {
        List aggregationList = aggregations.asList();
        for (Aggregation aggregation : aggregationList) {
            if (aggregation instanceof NumericMetricsAggregation) continue;
            return false;
        }
        return true;
    }

    private Aggregation skipAggregations(Aggregation firstAggregation) {
        while (firstAggregation instanceof SingleBucketAggregation) {
            firstAggregation = this.getFirstAggregation(((SingleBucketAggregation)firstAggregation).getAggregations());
        }
        return firstAggregation;
    }

    private Aggregation getFirstAggregation(Aggregations aggregations) {
        return (Aggregation)aggregations.asList().get(0);
    }

    private List<List<String>> createCSVLinesFromDocs(boolean flat, String separator, List<Map<String, Object>> docsAsMap, List<String> headers) {
        ArrayList<List<String>> csvLines = new ArrayList<List<String>>();
        for (Map<String, Object> doc : docsAsMap) {
            ArrayList<String> line = new ArrayList<String>();
            for (String header : headers) {
                line.add(this.findFieldValue(header, doc, flat, separator));
            }
            csvLines.add(line);
        }
        return csvLines;
    }

    private List<String> createHeadersAndFillDocsMap(boolean flat, SearchHit[] hits, List<Map<String, Object>> docsAsMap, List<String> fieldNames) {
        LinkedHashSet<String> csvHeaders = new LinkedHashSet<String>();
        if (fieldNames != null) {
            csvHeaders.addAll(fieldNames);
        }
        for (SearchHit hit : hits) {
            Map doc = hit.getSourceAsMap();
            Map fields = hit.getFields();
            for (DocumentField searchHitField : fields.values()) {
                doc.put(searchHitField.getName(), searchHitField.getValue());
            }
            if (this.includeId) {
                doc.put("_id", hit.getId());
            }
            if (this.includeScore) {
                doc.put("_score", Float.valueOf(hit.getScore()));
            }
            if (this.includeType) {
                doc.put("_type", hit.getType());
            }
            if (fields.isEmpty()) {
                this.mergeHeaders(csvHeaders, doc, flat);
            }
            docsAsMap.add(doc);
        }
        return new ArrayList<String>(csvHeaders);
    }

    private String findFieldValue(String header, Map<String, Object> doc, boolean flat, String separator) {
        if (flat && header.contains(".")) {
            String[] split = header.split("\\.");
            Object innerDoc = doc;
            for (String innerField : split) {
                if (!(innerDoc instanceof Map)) {
                    return "";
                }
                if ((innerDoc = innerDoc.get(innerField)) != null) continue;
                return "";
            }
            return innerDoc.toString();
        }
        if (doc.containsKey(header)) {
            return String.valueOf(doc.get(header));
        }
        return "";
    }

    private void mergeHeaders(Set<String> headers, Map<String, Object> doc, boolean flat) {
        if (!flat) {
            headers.addAll(doc.keySet());
            return;
        }
        this.mergeFieldNamesRecursive(headers, doc, "");
    }

    private void mergeFieldNamesRecursive(Set<String> headers, Map<String, Object> doc, String prefix) {
        for (Map.Entry<String, Object> field : doc.entrySet()) {
            Object value = field.getValue();
            if (value instanceof Map) {
                this.mergeFieldNamesRecursive(headers, (Map)value, prefix + field.getKey() + ".");
                continue;
            }
            headers.add(prefix + field.getKey());
        }
    }
}

