/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.opendistroforelasticsearch.sql.legacy.executor.csv;

import com.amazon.opendistroforelasticsearch.sql.legacy.executor.QueryActionElasticExecutor;
import com.amazon.opendistroforelasticsearch.sql.legacy.executor.RestExecutor;
import com.amazon.opendistroforelasticsearch.sql.legacy.executor.csv.CSVResult;
import com.amazon.opendistroforelasticsearch.sql.legacy.executor.csv.CSVResultsExtractor;
import com.amazon.opendistroforelasticsearch.sql.legacy.query.QueryAction;
import com.amazon.opendistroforelasticsearch.sql.legacy.query.join.BackOffRetryStrategy;
import com.google.common.base.Joiner;
import java.util.List;
import java.util.Map;
import org.elasticsearch.client.Client;
import org.elasticsearch.rest.BytesRestResponse;
import org.elasticsearch.rest.RestChannel;
import org.elasticsearch.rest.RestResponse;
import org.elasticsearch.rest.RestStatus;

public class CSVResultRestExecutor
implements RestExecutor {
    @Override
    public void execute(Client client, Map<String, String> params, QueryAction queryAction, RestChannel channel) throws Exception {
        String csvString = this.execute(client, params, queryAction);
        BytesRestResponse bytesRestResponse = new BytesRestResponse(RestStatus.OK, csvString);
        if (!BackOffRetryStrategy.isHealthy(2 * bytesRestResponse.content().length(), this)) {
            throw new IllegalStateException("[CSVResultRestExecutor] Memory could be insufficient when sendResponse().");
        }
        channel.sendResponse((RestResponse)bytesRestResponse);
    }

    @Override
    public String execute(Client client, Map<String, String> params, QueryAction queryAction) throws Exception {
        Object queryResult = QueryActionElasticExecutor.executeAnyAction(client, queryAction);
        String separator = params.getOrDefault("separator", ",");
        String newLine = params.getOrDefault("newLine", "\n");
        boolean flat = this.getBooleanOrDefault(params, "flat", false);
        boolean includeScore = this.getBooleanOrDefault(params, "_score", false);
        boolean includeType = this.getBooleanOrDefault(params, "_type", false);
        boolean includeId = this.getBooleanOrDefault(params, "_id", false);
        List fieldNames = queryAction.getFieldNames().orElse(null);
        CSVResult result = new CSVResultsExtractor(includeScore, includeType, includeId).extractResults(queryResult, flat, separator, fieldNames);
        return this.buildString(separator, result, newLine);
    }

    private boolean getBooleanOrDefault(Map<String, String> params, String param, boolean defaultValue) {
        boolean flat = defaultValue;
        if (params.containsKey(param)) {
            flat = Boolean.parseBoolean(params.get(param));
        }
        return flat;
    }

    private String buildString(String separator, CSVResult result, String newLine) {
        StringBuilder csv = new StringBuilder();
        csv.append(Joiner.on((String)separator).join(result.getHeaders()));
        csv.append(newLine);
        csv.append(Joiner.on((String)newLine).join(result.getLines()));
        return csv.toString();
    }
}

