/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.opendistroforelasticsearch.sql.legacy.executor;

import com.amazon.opendistroforelasticsearch.sql.legacy.exception.SqlParseException;
import com.amazon.opendistroforelasticsearch.sql.legacy.executor.ElasticHitsExecutor;
import com.amazon.opendistroforelasticsearch.sql.legacy.executor.adapter.QueryPlanQueryAction;
import com.amazon.opendistroforelasticsearch.sql.legacy.executor.adapter.QueryPlanRequestBuilder;
import com.amazon.opendistroforelasticsearch.sql.legacy.executor.join.ElasticJoinExecutor;
import com.amazon.opendistroforelasticsearch.sql.legacy.executor.multi.MultiRequestExecutorFactory;
import com.amazon.opendistroforelasticsearch.sql.legacy.expression.domain.BindingTuple;
import com.amazon.opendistroforelasticsearch.sql.legacy.query.AggregationQueryAction;
import com.amazon.opendistroforelasticsearch.sql.legacy.query.DefaultQueryAction;
import com.amazon.opendistroforelasticsearch.sql.legacy.query.DeleteQueryAction;
import com.amazon.opendistroforelasticsearch.sql.legacy.query.DescribeQueryAction;
import com.amazon.opendistroforelasticsearch.sql.legacy.query.QueryAction;
import com.amazon.opendistroforelasticsearch.sql.legacy.query.ShowQueryAction;
import com.amazon.opendistroforelasticsearch.sql.legacy.query.SqlElasticRequestBuilder;
import com.amazon.opendistroforelasticsearch.sql.legacy.query.SqlElasticSearchRequestBuilder;
import com.amazon.opendistroforelasticsearch.sql.legacy.query.join.ESJoinQueryAction;
import com.amazon.opendistroforelasticsearch.sql.legacy.query.multi.MultiQueryAction;
import com.amazon.opendistroforelasticsearch.sql.legacy.query.multi.MultiQueryRequestBuilder;
import java.io.IOException;
import java.util.List;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.client.Client;
import org.elasticsearch.search.SearchHits;
import org.elasticsearch.search.aggregations.Aggregations;

public class QueryActionElasticExecutor {
    public static SearchHits executeSearchAction(DefaultQueryAction searchQueryAction) throws SqlParseException {
        SqlElasticSearchRequestBuilder builder = searchQueryAction.explain();
        return ((SearchResponse)builder.get()).getHits();
    }

    public static SearchHits executeJoinSearchAction(Client client, ESJoinQueryAction joinQueryAction) throws IOException, SqlParseException {
        SqlElasticRequestBuilder joinRequestBuilder = joinQueryAction.explain();
        ElasticJoinExecutor executor = ElasticJoinExecutor.createJoinExecutor(client, joinRequestBuilder);
        executor.run();
        return executor.getHits();
    }

    public static Aggregations executeAggregationAction(AggregationQueryAction aggregationQueryAction) throws SqlParseException {
        SqlElasticSearchRequestBuilder select = aggregationQueryAction.explain();
        return ((SearchResponse)select.get()).getAggregations();
    }

    public static List<BindingTuple> executeQueryPlanQueryAction(QueryPlanQueryAction queryPlanQueryAction) {
        QueryPlanRequestBuilder select = (QueryPlanRequestBuilder)queryPlanQueryAction.explain();
        return select.execute();
    }

    public static ActionResponse executeShowQueryAction(ShowQueryAction showQueryAction) {
        return showQueryAction.explain().get();
    }

    public static ActionResponse executeDescribeQueryAction(DescribeQueryAction describeQueryAction) {
        return describeQueryAction.explain().get();
    }

    public static ActionResponse executeDeleteAction(DeleteQueryAction deleteQueryAction) throws SqlParseException {
        return deleteQueryAction.explain().get();
    }

    public static SearchHits executeMultiQueryAction(Client client, MultiQueryAction queryAction) throws SqlParseException, IOException {
        SqlElasticRequestBuilder multiRequestBuilder = queryAction.explain();
        ElasticHitsExecutor executor = MultiRequestExecutorFactory.createExecutor(client, (MultiQueryRequestBuilder)multiRequestBuilder);
        executor.run();
        return executor.getHits();
    }

    public static Object executeAnyAction(Client client, QueryAction queryAction) throws SqlParseException, IOException {
        if (queryAction instanceof DefaultQueryAction) {
            return QueryActionElasticExecutor.executeSearchAction((DefaultQueryAction)queryAction);
        }
        if (queryAction instanceof AggregationQueryAction) {
            return QueryActionElasticExecutor.executeAggregationAction((AggregationQueryAction)queryAction);
        }
        if (queryAction instanceof QueryPlanQueryAction) {
            return QueryActionElasticExecutor.executeQueryPlanQueryAction((QueryPlanQueryAction)queryAction);
        }
        if (queryAction instanceof ShowQueryAction) {
            return QueryActionElasticExecutor.executeShowQueryAction((ShowQueryAction)queryAction);
        }
        if (queryAction instanceof DescribeQueryAction) {
            return QueryActionElasticExecutor.executeDescribeQueryAction((DescribeQueryAction)queryAction);
        }
        if (queryAction instanceof ESJoinQueryAction) {
            return QueryActionElasticExecutor.executeJoinSearchAction(client, (ESJoinQueryAction)queryAction);
        }
        if (queryAction instanceof MultiQueryAction) {
            return QueryActionElasticExecutor.executeMultiQueryAction(client, (MultiQueryAction)queryAction);
        }
        if (queryAction instanceof DeleteQueryAction) {
            return QueryActionElasticExecutor.executeDeleteAction((DeleteQueryAction)queryAction);
        }
        return null;
    }
}

