/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.opendistroforelasticsearch.sql.legacy.executor;

import com.amazon.opendistroforelasticsearch.sql.legacy.antlr.semantic.SemanticAnalysisException;
import com.carrotsearch.hppc.cursors.ObjectObjectCursor;
import java.io.IOException;
import java.util.List;
import org.elasticsearch.action.admin.indices.get.GetIndexRequest;
import org.elasticsearch.action.admin.indices.get.GetIndexResponse;
import org.elasticsearch.cluster.metadata.AliasMetadata;
import org.elasticsearch.cluster.metadata.MappingMetadata;
import org.elasticsearch.common.collect.ImmutableOpenMap;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.rest.BytesRestResponse;
import org.elasticsearch.rest.RestChannel;
import org.elasticsearch.rest.RestResponse;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.rest.action.RestBuilderListener;

public class GetIndexRequestRestListener
extends RestBuilderListener<GetIndexResponse> {
    private GetIndexRequest getIndexRequest;

    public GetIndexRequestRestListener(RestChannel channel, GetIndexRequest getIndexRequest) {
        super(channel);
        this.getIndexRequest = getIndexRequest;
    }

    public RestResponse buildResponse(GetIndexResponse getIndexResponse, XContentBuilder builder) throws Exception {
        GetIndexRequest.Feature[] features = this.getIndexRequest.features();
        String[] indices = getIndexResponse.indices();
        builder.startObject();
        for (String index : indices) {
            builder.startObject(index);
            block6: for (GetIndexRequest.Feature feature : features) {
                switch (feature) {
                    case ALIASES: {
                        this.writeAliases((List)getIndexResponse.aliases().get((Object)index), builder, (ToXContent.Params)this.channel.request());
                        continue block6;
                    }
                    case MAPPINGS: {
                        this.writeMappings((ImmutableOpenMap<String, MappingMetadata>)((ImmutableOpenMap)getIndexResponse.mappings().get((Object)index)), builder, (ToXContent.Params)this.channel.request());
                        continue block6;
                    }
                    case SETTINGS: {
                        this.writeSettings((Settings)getIndexResponse.settings().get((Object)index), builder, (ToXContent.Params)this.channel.request());
                        continue block6;
                    }
                    default: {
                        throw new SemanticAnalysisException("Unsupported feature: " + feature);
                    }
                }
            }
            builder.endObject();
        }
        builder.endObject();
        return new BytesRestResponse(RestStatus.OK, builder);
    }

    private void writeAliases(List<AliasMetadata> aliases, XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject("aliases");
        if (aliases != null) {
            for (AliasMetadata alias : aliases) {
                AliasMetadata.Builder.toXContent((AliasMetadata)alias, (XContentBuilder)builder, (ToXContent.Params)params);
            }
        }
        builder.endObject();
    }

    private void writeMappings(ImmutableOpenMap<String, MappingMetadata> mappings, XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject("mappings");
        if (mappings != null) {
            for (ObjectObjectCursor typeEntry : mappings) {
                builder.field((String)typeEntry.key);
                builder.map(((MappingMetadata)typeEntry.value).sourceAsMap());
            }
        }
        builder.endObject();
    }

    private void writeSettings(Settings settings, XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject("settings");
        settings.toXContent(builder, params);
        builder.endObject();
    }

    static class Fields {
        static final String ALIASES = "aliases";
        static final String MAPPINGS = "mappings";
        static final String SETTINGS = "settings";
        static final String WARMERS = "warmers";

        Fields() {
        }
    }
}

