/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.opendistroforelasticsearch.sql.legacy.executor;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.Optional;

public enum Format {
    JDBC("jdbc"),
    JSON("json"),
    CSV("csv"),
    RAW("raw"),
    TABLE("table");

    private final String formatName;
    private static final Map<String, Format> ALL_FORMATS;

    public static Optional<Format> of(String formatName) {
        return Optional.ofNullable(ALL_FORMATS.getOrDefault(formatName, null));
    }

    private Format(String formatName) {
        this.formatName = formatName;
    }

    public String getFormatName() {
        return this.formatName;
    }

    static {
        ImmutableMap.Builder builder = new ImmutableMap.Builder();
        for (Format format : Format.values()) {
            builder.put((Object)format.formatName, (Object)format);
        }
        ALL_FORMATS = builder.build();
    }
}

