/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.opendistroforelasticsearch.sql.legacy.executor;

import com.amazon.opendistroforelasticsearch.sql.legacy.exception.SqlParseException;
import com.amazon.opendistroforelasticsearch.sql.legacy.executor.ElasticHitsExecutor;
import com.amazon.opendistroforelasticsearch.sql.legacy.executor.GetIndexRequestRestListener;
import com.amazon.opendistroforelasticsearch.sql.legacy.executor.RestExecutor;
import com.amazon.opendistroforelasticsearch.sql.legacy.executor.join.ElasticJoinExecutor;
import com.amazon.opendistroforelasticsearch.sql.legacy.executor.join.ElasticUtils;
import com.amazon.opendistroforelasticsearch.sql.legacy.executor.join.MetaSearchResult;
import com.amazon.opendistroforelasticsearch.sql.legacy.executor.multi.MultiRequestExecutorFactory;
import com.amazon.opendistroforelasticsearch.sql.legacy.query.QueryAction;
import com.amazon.opendistroforelasticsearch.sql.legacy.query.SqlElasticRequestBuilder;
import com.amazon.opendistroforelasticsearch.sql.legacy.query.join.JoinRequestBuilder;
import com.amazon.opendistroforelasticsearch.sql.legacy.query.multi.MultiQueryRequestBuilder;
import com.google.common.collect.Maps;
import java.io.IOException;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.action.ActionFuture;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.admin.indices.get.GetIndexRequest;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.action.search.SearchScrollRequest;
import org.elasticsearch.client.Client;
import org.elasticsearch.index.reindex.BulkIndexByScrollResponseContentListener;
import org.elasticsearch.index.reindex.DeleteByQueryRequest;
import org.elasticsearch.rest.BytesRestResponse;
import org.elasticsearch.rest.RestChannel;
import org.elasticsearch.rest.RestResponse;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.rest.action.RestStatusToXContentListener;
import org.elasticsearch.search.SearchHits;

public class ElasticDefaultRestExecutor
implements RestExecutor {
    private final SqlElasticRequestBuilder requestBuilder;
    private static final Logger LOG = LogManager.getLogger(ElasticDefaultRestExecutor.class);

    public ElasticDefaultRestExecutor(QueryAction queryAction) {
        try {
            this.requestBuilder = queryAction.explain();
        }
        catch (SqlParseException e) {
            throw new IllegalStateException("Failed to explain query action", e);
        }
    }

    @Override
    public void execute(Client client, Map<String, String> params, QueryAction queryAction, RestChannel channel) throws Exception {
        ActionRequest request = this.requestBuilder.request();
        if (this.requestBuilder instanceof JoinRequestBuilder) {
            ElasticJoinExecutor executor = ElasticJoinExecutor.createJoinExecutor(client, this.requestBuilder);
            executor.run();
            executor.sendResponse(channel);
        } else if (this.requestBuilder instanceof MultiQueryRequestBuilder) {
            ElasticHitsExecutor executor = MultiRequestExecutorFactory.createExecutor(client, (MultiQueryRequestBuilder)this.requestBuilder);
            executor.run();
            this.sendDefaultResponse(executor.getHits(), channel);
        } else if (request instanceof SearchRequest) {
            client.search((SearchRequest)request, (ActionListener)new RestStatusToXContentListener(channel));
        } else if (request instanceof DeleteByQueryRequest) {
            this.requestBuilder.getBuilder().execute((ActionListener)new BulkIndexByScrollResponseContentListener(channel, (Map)Maps.newHashMap()));
        } else if (request instanceof GetIndexRequest) {
            this.requestBuilder.getBuilder().execute((ActionListener)new GetIndexRequestRestListener(channel, (GetIndexRequest)request));
        } else if (request instanceof SearchScrollRequest) {
            client.searchScroll((SearchScrollRequest)request, (ActionListener)new RestStatusToXContentListener(channel));
        } else {
            throw new Exception(String.format("Unsupported ActionRequest provided: %s", request.getClass().getName()));
        }
    }

    @Override
    public String execute(Client client, Map<String, String> params, QueryAction queryAction) throws Exception {
        ActionRequest request = this.requestBuilder.request();
        if (this.requestBuilder instanceof JoinRequestBuilder) {
            ElasticJoinExecutor executor = ElasticJoinExecutor.createJoinExecutor(client, this.requestBuilder);
            executor.run();
            return ElasticUtils.hitsAsStringResult(executor.getHits(), new MetaSearchResult());
        }
        if (this.requestBuilder instanceof MultiQueryRequestBuilder) {
            ElasticHitsExecutor executor = MultiRequestExecutorFactory.createExecutor(client, (MultiQueryRequestBuilder)this.requestBuilder);
            executor.run();
            return ElasticUtils.hitsAsStringResult(executor.getHits(), new MetaSearchResult());
        }
        if (request instanceof SearchRequest) {
            ActionFuture future = client.search((SearchRequest)request);
            SearchResponse response = (SearchResponse)future.actionGet();
            return response.toString();
        }
        if (request instanceof DeleteByQueryRequest) {
            return this.requestBuilder.get().toString();
        }
        if (request instanceof GetIndexRequest) {
            return this.requestBuilder.getBuilder().execute().actionGet().toString();
        }
        throw new Exception(String.format("Unsupported ActionRequest provided: %s", request.getClass().getName()));
    }

    private void sendDefaultResponse(SearchHits hits, RestChannel channel) {
        try {
            String json = ElasticUtils.hitsAsStringResult(hits, new MetaSearchResult());
            BytesRestResponse bytesRestResponse = new BytesRestResponse(RestStatus.OK, json);
            channel.sendResponse((RestResponse)bytesRestResponse);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

