/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.opendistroforelasticsearch.sql.legacy.executor;

import com.amazon.opendistroforelasticsearch.sql.legacy.esdomain.LocalClusterState;
import com.amazon.opendistroforelasticsearch.sql.legacy.exception.SqlParseException;
import com.amazon.opendistroforelasticsearch.sql.legacy.executor.RestExecutor;
import com.amazon.opendistroforelasticsearch.sql.legacy.metrics.MetricName;
import com.amazon.opendistroforelasticsearch.sql.legacy.metrics.Metrics;
import com.amazon.opendistroforelasticsearch.sql.legacy.query.QueryAction;
import com.amazon.opendistroforelasticsearch.sql.legacy.query.join.BackOffRetryStrategy;
import com.amazon.opendistroforelasticsearch.sql.legacy.utils.LogUtils;
import java.io.IOException;
import java.time.Duration;
import java.util.Map;
import java.util.function.Predicate;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.client.Client;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.rest.BytesRestResponse;
import org.elasticsearch.rest.RestChannel;
import org.elasticsearch.rest.RestResponse;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.Transports;

public class AsyncRestExecutor
implements RestExecutor {
    public static final String SQL_WORKER_THREAD_POOL_NAME = "sql-worker";
    private static final Logger LOG = LogManager.getLogger(AsyncRestExecutor.class);
    private static final Predicate<QueryAction> ALL_ACTION_IS_BLOCKING = anyAction -> true;
    private final RestExecutor executor;
    private final Predicate<QueryAction> isBlocking;

    AsyncRestExecutor(RestExecutor executor) {
        this(executor, ALL_ACTION_IS_BLOCKING);
    }

    AsyncRestExecutor(RestExecutor executor, Predicate<QueryAction> isBlocking) {
        this.executor = executor;
        this.isBlocking = isBlocking;
    }

    @Override
    public void execute(Client client, Map<String, String> params, QueryAction queryAction, RestChannel channel) throws Exception {
        if (this.isBlockingAction(queryAction) && this.isRunningInTransportThread()) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("[{}] Async blocking query action [{}] for executor [{}] in current thread [{}]", (Object)LogUtils.getRequestId(), (Object)this.name(this.executor), (Object)this.name(queryAction), (Object)Thread.currentThread().getName());
            }
            this.async(client, params, queryAction, channel);
        } else {
            if (LOG.isDebugEnabled()) {
                LOG.debug("[{}] Continue running query action [{}] for executor [{}] in current thread [{}]", (Object)LogUtils.getRequestId(), (Object)this.name(this.executor), (Object)this.name(queryAction), (Object)Thread.currentThread().getName());
            }
            this.doExecuteWithTimeMeasured(client, params, queryAction, channel);
        }
    }

    @Override
    public String execute(Client client, Map<String, String> params, QueryAction queryAction) throws Exception {
        return this.executor.execute(client, params, queryAction);
    }

    private boolean isBlockingAction(QueryAction queryAction) {
        return this.isBlocking.test(queryAction);
    }

    private boolean isRunningInTransportThread() {
        return Transports.isTransportThread((Thread)Thread.currentThread());
    }

    private void async(Client client, Map<String, String> params, QueryAction queryAction, RestChannel channel) {
        ThreadPool threadPool = client.threadPool();
        Runnable runnable = () -> {
            try {
                this.doExecuteWithTimeMeasured(client, params, queryAction, channel);
            }
            catch (SqlParseException | IOException | ElasticsearchException e) {
                Metrics.getInstance().getNumericalMetric(MetricName.FAILED_REQ_COUNT_SYS).increment();
                LOG.warn("[{}] [MCB] async task got an IO/SQL exception: {}", (Object)LogUtils.getRequestId(), (Object)e.getMessage());
                channel.sendResponse((RestResponse)new BytesRestResponse(RestStatus.INTERNAL_SERVER_ERROR, e.getMessage()));
            }
            catch (IllegalStateException e) {
                Metrics.getInstance().getNumericalMetric(MetricName.FAILED_REQ_COUNT_SYS).increment();
                LOG.warn("[{}] [MCB] async task got a runtime exception: {}", (Object)LogUtils.getRequestId(), (Object)e.getMessage());
                channel.sendResponse((RestResponse)new BytesRestResponse(RestStatus.INSUFFICIENT_STORAGE, "Memory circuit is broken."));
            }
            catch (Throwable t) {
                Metrics.getInstance().getNumericalMetric(MetricName.FAILED_REQ_COUNT_SYS).increment();
                LOG.warn("[{}] [MCB] async task got an unknown throwable: {}", (Object)LogUtils.getRequestId(), (Object)t.getMessage());
                channel.sendResponse((RestResponse)new BytesRestResponse(RestStatus.INTERNAL_SERVER_ERROR, String.valueOf(t.getMessage())));
            }
            finally {
                BackOffRetryStrategy.releaseMem(this.executor);
            }
        };
        threadPool.schedule(LogUtils.withCurrentContext(runnable), new TimeValue(0L), SQL_WORKER_THREAD_POOL_NAME);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doExecuteWithTimeMeasured(Client client, Map<String, String> params, QueryAction action, RestChannel channel) throws Exception {
        long startTime = System.nanoTime();
        try {
            this.executor.execute(client, params, action, channel);
        }
        finally {
            Duration elapsed = Duration.ofNanos(System.nanoTime() - startTime);
            int slowLogThreshold = (Integer)LocalClusterState.state().getSettingValue("opendistro.sql.query.slowlog");
            if (elapsed.getSeconds() >= (long)slowLogThreshold) {
                LOG.warn("[{}] Slow query: elapsed={} (ms)", (Object)LogUtils.getRequestId(), (Object)elapsed.toMillis());
            }
        }
    }

    private String name(Object object) {
        return object.getClass().getSimpleName();
    }
}

