/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.opendistroforelasticsearch.sql.legacy.executor;

import com.amazon.opendistroforelasticsearch.sql.legacy.executor.AsyncRestExecutor;
import com.amazon.opendistroforelasticsearch.sql.legacy.executor.ElasticDefaultRestExecutor;
import com.amazon.opendistroforelasticsearch.sql.legacy.executor.Format;
import com.amazon.opendistroforelasticsearch.sql.legacy.executor.RestExecutor;
import com.amazon.opendistroforelasticsearch.sql.legacy.executor.csv.CSVResultRestExecutor;
import com.amazon.opendistroforelasticsearch.sql.legacy.executor.format.PrettyFormatRestExecutor;
import com.amazon.opendistroforelasticsearch.sql.legacy.query.QueryAction;
import com.amazon.opendistroforelasticsearch.sql.legacy.query.join.ESJoinQueryAction;
import com.amazon.opendistroforelasticsearch.sql.legacy.query.multi.MultiQueryAction;

public class ActionRequestRestExecutorFactory {
    public static RestExecutor createExecutor(Format format, QueryAction queryAction) {
        switch (format) {
            case CSV: {
                return new AsyncRestExecutor(new CSVResultRestExecutor());
            }
            case JSON: {
                return new AsyncRestExecutor(new ElasticDefaultRestExecutor(queryAction), action -> ActionRequestRestExecutorFactory.isJoin(action) || ActionRequestRestExecutorFactory.isUnionMinus(action));
            }
        }
        return new AsyncRestExecutor(new PrettyFormatRestExecutor(format.getFormatName()));
    }

    private static boolean isJoin(QueryAction queryAction) {
        return queryAction instanceof ESJoinQueryAction;
    }

    private static boolean isUnionMinus(QueryAction queryAction) {
        return queryAction instanceof MultiQueryAction;
    }
}

