/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.opendistroforelasticsearch.sql.legacy.esdomain.mapping;

import com.amazon.opendistroforelasticsearch.sql.legacy.domain.Field;
import com.amazon.opendistroforelasticsearch.sql.legacy.utils.StringUtils;
import java.util.Collections;
import java.util.Map;
import org.elasticsearch.action.admin.indices.mapping.get.GetFieldMappingsResponse;

public class FieldMapping {
    private final String fieldName;
    private final Map<String, GetFieldMappingsResponse.FieldMappingMetadata> typeMappings;
    private final Map<String, Field> specifiedFieldsByName;

    public FieldMapping(String fieldName) {
        this(fieldName, Collections.emptyMap(), Collections.emptyMap());
    }

    public FieldMapping(String fieldName, Map<String, GetFieldMappingsResponse.FieldMappingMetadata> typeMappings, Map<String, Field> specifiedFieldByNames) {
        this.fieldName = fieldName;
        this.typeMappings = typeMappings;
        this.specifiedFieldsByName = specifiedFieldByNames;
    }

    public boolean isSpecified() {
        return this.specifiedFieldsByName.containsKey(this.fieldName);
    }

    public boolean isWildcardSpecified() {
        return this.specifiedFieldsByName.containsKey(this.path() + ".*");
    }

    public boolean isPropertyField() {
        int numOfDots = StringUtils.countMatches(this.fieldName, '.');
        return numOfDots > 1 || numOfDots == 1 && !this.isMultiField();
    }

    public boolean isMultiField() {
        return this.fieldName.endsWith(".keyword");
    }

    public boolean isMetaField() {
        return this.fieldName.startsWith("_");
    }

    public String path() {
        int lastDot = this.fieldName.lastIndexOf(".");
        if (lastDot == -1) {
            throw new IllegalStateException("path() is being invoked on the wrong field [" + this.fieldName + "]");
        }
        return this.fieldName.substring(0, lastDot);
    }

    public String type() {
        GetFieldMappingsResponse.FieldMappingMetadata metaData = this.typeMappings.getOrDefault(this.fieldName, GetFieldMappingsResponse.FieldMappingMetadata.NULL);
        if (metaData.isNull()) {
            return "object";
        }
        Map source = metaData.sourceAsMap();
        String[] fieldPath = this.fieldName.split("\\.");
        String innermostFieldName = fieldPath.length == 1 ? this.fieldName : fieldPath[fieldPath.length - 1];
        Map fieldMapping = (Map)source.get(innermostFieldName);
        return (String)fieldMapping.get("type");
    }
}

