/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.opendistroforelasticsearch.sql.legacy.esdomain;

import com.amazon.opendistroforelasticsearch.sql.legacy.esdomain.mapping.IndexMappings;
import com.amazon.opendistroforelasticsearch.sql.legacy.plugin.SqlSettings;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.function.Function;
import java.util.function.Predicate;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.action.support.IndicesOptions;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.metadata.MappingMetadata;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.collect.ImmutableOpenMap;
import org.elasticsearch.common.collect.Tuple;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.index.IndexNotFoundException;

public class LocalClusterState {
    private static final Logger LOG = LogManager.getLogger();
    private static final String[] ALL_TYPES = new String[0];
    private static final Function<String, Predicate<String>> ALL_FIELDS = anyIndex -> anyField -> true;
    private static LocalClusterState INSTANCE;
    private ClusterService clusterService;
    private SqlSettings sqlSettings;
    private IndexNameExpressionResolver resolver;
    private final Cache<Tuple<List<String>, List<String>>, IndexMappings> cache;
    private final Map<String, Object> latestSettings = new ConcurrentHashMap<String, Object>();

    public static synchronized LocalClusterState state() {
        if (INSTANCE == null) {
            INSTANCE = new LocalClusterState();
        }
        return INSTANCE;
    }

    public static synchronized void state(LocalClusterState instance) {
        INSTANCE = instance;
    }

    public void setClusterService(ClusterService clusterService) {
        this.clusterService = clusterService;
        clusterService.addListener(event -> {
            if (event.metadataChanged()) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Metadata in cluster state changed: {}", (Object)new IndexMappings(clusterService.state().metadata()));
                }
                this.cache.invalidateAll();
            }
        });
    }

    public void setSqlSettings(SqlSettings sqlSettings) {
        this.sqlSettings = sqlSettings;
        for (Setting<?> setting : sqlSettings.getSettings()) {
            this.clusterService.getClusterSettings().addSettingsUpdateConsumer(setting, newVal -> {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("The value of setting [{}] changed to [{}]", (Object)setting.getKey(), newVal);
                }
                this.latestSettings.put(setting.getKey(), newVal);
            });
        }
    }

    public void setResolver(IndexNameExpressionResolver resolver) {
        this.resolver = resolver;
    }

    private LocalClusterState() {
        this.cache = CacheBuilder.newBuilder().maximumSize(100L).build();
    }

    public <T> T getSettingValue(String key) {
        Objects.requireNonNull(this.sqlSettings, "SQL setting is null");
        return (T)this.latestSettings.getOrDefault(key, this.sqlSettings.getSetting(key).getDefault(Settings.EMPTY));
    }

    public IndexMappings getFieldMappings(String[] indices) {
        return this.getFieldMappings(indices, ALL_TYPES, ALL_FIELDS);
    }

    public IndexMappings getFieldMappings(String[] indices, String[] types) {
        return this.getFieldMappings(indices, types, ALL_FIELDS);
    }

    public IndexMappings getFieldMappings(String[] indices, String[] types, Function<String, Predicate<String>> fieldFilter) {
        Objects.requireNonNull(this.clusterService, "Cluster service is null");
        Objects.requireNonNull(this.resolver, "Index name expression resolver is null");
        try {
            ClusterState state = this.clusterService.state();
            String[] concreteIndices = this.resolveIndexExpression(state, indices);
            IndexMappings mappings = fieldFilter == ALL_FIELDS ? this.findMappingsInCache(state, concreteIndices, types) : this.findMappings(state, concreteIndices, types, fieldFilter);
            LOG.debug("Found mappings: {}", (Object)mappings);
            return mappings;
        }
        catch (IndexNotFoundException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to read mapping in cluster state for indices=" + Arrays.toString(indices) + ", types=" + Arrays.toString(types), e);
        }
    }

    private String[] resolveIndexExpression(ClusterState state, String[] indices) {
        Object[] concreteIndices = this.resolver.concreteIndexNames(state, IndicesOptions.strictExpandOpen(), indices);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Resolved index expression {} to concrete index names {}", (Object)Arrays.toString(indices), (Object)Arrays.toString(concreteIndices));
        }
        return concreteIndices;
    }

    private IndexMappings findMappings(ClusterState state, String[] indices, String[] types, Function<String, Predicate<String>> fieldFilter) throws IOException {
        LOG.debug("Cache didn't help. Load and parse mapping in cluster state");
        return new IndexMappings((ImmutableOpenMap<String, ImmutableOpenMap<String, MappingMetadata>>)state.metadata().findMappings(indices, types, fieldFilter));
    }

    private IndexMappings findMappingsInCache(ClusterState state, String[] indices, String[] types) throws ExecutionException {
        LOG.debug("Looking for mapping in cache: {}", (Object)this.cache.asMap());
        return (IndexMappings)this.cache.get((Object)new Tuple(this.sortToList(indices), this.sortToList(types)), () -> this.findMappings(state, indices, types, ALL_FIELDS));
    }

    private <T> List<T> sortToList(T[] array) {
        Arrays.sort(array);
        return Arrays.asList(array);
    }
}

