/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.opendistroforelasticsearch.sql.legacy.esdomain;

import com.amazon.opendistroforelasticsearch.sql.legacy.query.join.BackOffRetryStrategy;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.action.search.MultiSearchRequest;
import org.elasticsearch.action.search.MultiSearchResponse;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.client.Client;

public class ESClient {
    private static final Logger LOG = LogManager.getLogger();
    private static final int[] retryIntervals = new int[]{4, 12, 20, 20};
    private final Client client;

    public ESClient(Client client) {
        this.client = client;
    }

    public MultiSearchResponse.Item[] multiSearch(MultiSearchRequest multiSearchRequest) {
        MultiSearchResponse.Item[] responses = new MultiSearchResponse.Item[multiSearchRequest.requests().size()];
        this.multiSearchRetry(responses, multiSearchRequest, IntStream.range(0, multiSearchRequest.requests().size()).boxed().collect(Collectors.toList()), 0);
        return responses;
    }

    private void multiSearchRetry(MultiSearchResponse.Item[] responses, MultiSearchRequest multiSearchRequest, List<Integer> indices, int retry) {
        MultiSearchRequest multiSearchRequestRetry = new MultiSearchRequest();
        for (int i : indices) {
            multiSearchRequestRetry.add((SearchRequest)multiSearchRequest.requests().get(i));
        }
        MultiSearchResponse.Item[] res = ((MultiSearchResponse)this.client.multiSearch(multiSearchRequestRetry).actionGet()).getResponses();
        ArrayList<Integer> indicesFailure = new ArrayList<Integer>();
        for (int i = 0; i < res.length; ++i) {
            if (res[i].isFailure()) {
                indicesFailure.add(indices.get(i));
                if (retry != 3) continue;
                responses[indices.get((int)i).intValue()] = res[i];
                continue;
            }
            responses[indices.get((int)i).intValue()] = res[i];
        }
        if (!indicesFailure.isEmpty()) {
            LOG.info("ES multisearch has failures on retry {}", (Object)retry);
            if (retry < 3) {
                BackOffRetryStrategy.backOffSleep(retryIntervals[retry]);
                this.multiSearchRetry(responses, multiSearchRequest, indicesFailure, retry + 1);
            }
        }
    }
}

