/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.opendistroforelasticsearch.sql.legacy.domain;

import com.amazon.opendistroforelasticsearch.sql.legacy.domain.QueryStatement;

public class IndexStatement
implements QueryStatement {
    private StatementType statementType;
    private String query;
    private String indexPattern;
    private String columnPattern;

    public IndexStatement(StatementType statementType, String query) {
        this.statementType = statementType;
        this.query = query;
        this.parseQuery();
    }

    private void parseQuery() {
        String[] statement = this.query.split(" ");
        int tokenLength = statement.length;
        try {
            block10: for (int i = 1; i < tokenLength; ++i) {
                switch (statement[i].toUpperCase()) {
                    case "TABLES": {
                        if (i + 1 >= tokenLength || !statement[i + 1].equalsIgnoreCase("LIKE") || i + 2 >= tokenLength) continue block10;
                        this.indexPattern = this.replaceWildcard(statement[i + 2]);
                        i += 2;
                        continue block10;
                    }
                    case "COLUMNS": {
                        if (i + 1 >= tokenLength || !statement[i + 1].equalsIgnoreCase("LIKE") || i + 2 >= tokenLength) continue block10;
                        this.columnPattern = this.replaceWildcard(statement[i + 2]);
                        i += 2;
                    }
                }
            }
            if (this.indexPattern == null) {
                throw new IllegalArgumentException();
            }
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Expected syntax example: " + this.syntaxString(), e);
        }
    }

    private String replaceWildcard(String str) {
        return str.replace("%", ".*").replace("_", ".");
    }

    private String syntaxString() {
        if (this.statementType.equals((Object)StatementType.SHOW)) {
            return "'SHOW TABLES LIKE <table pattern>'";
        }
        return "'DESCRIBE TABLES LIKE <table pattern> [COLUMNS LIKE <column pattern>]'";
    }

    public StatementType getStatementType() {
        return this.statementType;
    }

    public String getQuery() {
        return this.query;
    }

    public String getIndexPattern() {
        return this.indexPattern;
    }

    public String getColumnPattern() {
        return this.columnPattern;
    }

    public static enum StatementType {
        SHOW,
        DESCRIBE;

    }
}

