/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.opendistroforelasticsearch.sql.legacy.domain;

import com.amazon.opendistroforelasticsearch.sql.legacy.antlr.semantic.types.Type;
import com.amazon.opendistroforelasticsearch.sql.legacy.antlr.semantic.types.base.ESDataType;
import com.amazon.opendistroforelasticsearch.sql.legacy.antlr.semantic.types.special.Product;
import com.amazon.opendistroforelasticsearch.sql.legacy.executor.format.Schema;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class ColumnTypeProvider {
    private final List<Schema.Type> typeList;
    private static final Map<ESDataType, Schema.Type> TYPE_MAP = new ImmutableMap.Builder().put((Object)ESDataType.SHORT, (Object)Schema.Type.SHORT).put((Object)ESDataType.LONG, (Object)Schema.Type.LONG).put((Object)ESDataType.INTEGER, (Object)Schema.Type.INTEGER).put((Object)ESDataType.FLOAT, (Object)Schema.Type.FLOAT).put((Object)ESDataType.DOUBLE, (Object)Schema.Type.DOUBLE).put((Object)ESDataType.KEYWORD, (Object)Schema.Type.KEYWORD).put((Object)ESDataType.TEXT, (Object)Schema.Type.TEXT).put((Object)ESDataType.STRING, (Object)Schema.Type.TEXT).put((Object)ESDataType.DATE, (Object)Schema.Type.DATE).put((Object)ESDataType.BOOLEAN, (Object)Schema.Type.BOOLEAN).put((Object)ESDataType.UNKNOWN, (Object)Schema.Type.DOUBLE).build();
    public static final Schema.Type COLUMN_DEFAULT_TYPE = Schema.Type.DOUBLE;

    public ColumnTypeProvider(Type type) {
        this.typeList = this.convertOutputColumnType(type);
    }

    public ColumnTypeProvider() {
        this.typeList = new ArrayList<Schema.Type>();
    }

    public Schema.Type get(int index) {
        if (this.typeList.isEmpty()) {
            return COLUMN_DEFAULT_TYPE;
        }
        return this.typeList.get(index);
    }

    private List<Schema.Type> convertOutputColumnType(Type type) {
        if (type instanceof Product) {
            List<Type> types = ((Product)type).getTypes();
            return types.stream().map(t -> this.convertType((Type)t)).collect(Collectors.toList());
        }
        if (type instanceof ESDataType) {
            return ImmutableList.of((Object)((Object)this.convertType(type)));
        }
        return ImmutableList.of((Object)((Object)COLUMN_DEFAULT_TYPE));
    }

    private Schema.Type convertType(Type type) {
        try {
            return TYPE_MAP.getOrDefault(type, COLUMN_DEFAULT_TYPE);
        }
        catch (Exception e) {
            return COLUMN_DEFAULT_TYPE;
        }
    }
}

