/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.opendistroforelasticsearch.sql.legacy.antlr.visitor;

import com.amazon.opendistroforelasticsearch.sql.legacy.antlr.parser.OpenDistroSqlParser;
import com.amazon.opendistroforelasticsearch.sql.legacy.antlr.parser.OpenDistroSqlParserBaseVisitor;
import com.amazon.opendistroforelasticsearch.sql.legacy.antlr.visitor.EarlyExitAnalysisException;
import com.amazon.opendistroforelasticsearch.sql.legacy.antlr.visitor.GenericSqlParseTreeVisitor;
import com.amazon.opendistroforelasticsearch.sql.legacy.antlr.visitor.Reducible;
import com.amazon.opendistroforelasticsearch.sql.legacy.antlr.visitor.UnsupportedSemanticVerifier;
import com.google.common.base.Strings;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.antlr.v4.runtime.ParserRuleContext;
import org.antlr.v4.runtime.tree.ParseTree;

public class AntlrSqlParseTreeVisitor<T extends Reducible>
extends OpenDistroSqlParserBaseVisitor<T> {
    private final GenericSqlParseTreeVisitor<T> visitor;

    public AntlrSqlParseTreeVisitor(GenericSqlParseTreeVisitor<T> visitor) {
        this.visitor = visitor;
    }

    @Override
    public T visitRoot(OpenDistroSqlParser.RootContext ctx) {
        this.visitor.visitRoot();
        return (T)((Reducible)super.visitRoot(ctx));
    }

    @Override
    public T visitUnionSelect(OpenDistroSqlParser.UnionSelectContext ctx) {
        Reducible union = (Reducible)this.visitor.visitOperator("UNION");
        return (T)this.reduce(union, this.asList(ctx.querySpecification(), ctx.unionStatement()));
    }

    @Override
    public T visitMinusSelect(OpenDistroSqlParser.MinusSelectContext ctx) {
        Reducible minus = (Reducible)this.visitor.visitOperator("MINUS");
        return (T)this.reduce(minus, this.asList(ctx.querySpecification(), ctx.minusStatement()));
    }

    @Override
    public T visitInPredicate(OpenDistroSqlParser.InPredicateContext ctx) {
        Reducible in = (Reducible)this.visitor.visitOperator("IN");
        OpenDistroSqlParser.PredicateContext field = ctx.predicate();
        ParserRuleContext subquery = ctx.selectStatement() != null ? ctx.selectStatement() : ctx.expressions();
        return (T)this.reduce(in, Arrays.asList(new ParserRuleContext[]{field, subquery}));
    }

    @Override
    public T visitTableSources(OpenDistroSqlParser.TableSourcesContext ctx) {
        if (ctx.tableSource().size() < 2) {
            return (T)((Reducible)super.visitTableSources(ctx));
        }
        Reducible commaJoin = (Reducible)this.visitor.visitOperator("JOIN");
        return (T)this.reduce(commaJoin, ctx.tableSource());
    }

    @Override
    public T visitTableSourceBase(OpenDistroSqlParser.TableSourceBaseContext ctx) {
        if (ctx.joinPart().isEmpty()) {
            return (T)((Reducible)super.visitTableSourceBase(ctx));
        }
        Reducible join = (Reducible)this.visitor.visitOperator("JOIN");
        return (T)this.reduce(join, this.asList(ctx.tableSourceItem(), ctx.joinPart()));
    }

    @Override
    public T visitInnerJoin(OpenDistroSqlParser.InnerJoinContext ctx) {
        return this.visitJoin(ctx.children, ctx.tableSourceItem());
    }

    @Override
    public T visitOuterJoin(OpenDistroSqlParser.OuterJoinContext ctx) {
        return this.visitJoin(ctx.children, ctx.tableSourceItem());
    }

    @Override
    public T visitQuerySpecification(OpenDistroSqlParser.QuerySpecificationContext ctx) {
        this.visitor.visitQuery();
        OpenDistroSqlParser.FromClauseContext fromClause = ctx.fromClause();
        this.visit((ParseTree)fromClause.tableSources());
        if (fromClause.whereExpr != null) {
            this.visit((ParseTree)fromClause.whereExpr);
        }
        Object result = this.visitSelectElements(ctx.selectElements());
        fromClause.groupByItem().forEach(arg_0 -> ((AntlrSqlParseTreeVisitor)this).visit(arg_0));
        if (fromClause.havingExpr != null) {
            this.visit((ParseTree)fromClause.havingExpr);
        }
        if (ctx.orderByClause() != null) {
            this.visitOrderByClause(ctx.orderByClause());
        }
        if (ctx.limitClause() != null) {
            this.visitLimitClause(ctx.limitClause());
        }
        this.visitor.endVisitQuery();
        return (T)result;
    }

    @Override
    public T visitSubqueryTableItem(OpenDistroSqlParser.SubqueryTableItemContext ctx) {
        throw new EarlyExitAnalysisException("Exit when meeting subquery in from");
    }

    @Override
    public T visitAtomTableItem(OpenDistroSqlParser.AtomTableItemContext ctx) {
        String alias = ctx.alias == null ? "" : ctx.alias.getText();
        Reducible result = (Reducible)this.visit((ParseTree)ctx.tableName());
        this.visitor.visitAs(alias, result);
        return (T)result;
    }

    @Override
    public T visitSimpleTableName(OpenDistroSqlParser.SimpleTableNameContext ctx) {
        return (T)((Reducible)this.visitor.visitIndexName(ctx.getText()));
    }

    @Override
    public T visitTableNamePattern(OpenDistroSqlParser.TableNamePatternContext ctx) {
        return (T)((Reducible)this.visitor.visitIndexName(ctx.getText()));
    }

    @Override
    public T visitTableAndTypeName(OpenDistroSqlParser.TableAndTypeNameContext ctx) {
        return (T)((Reducible)this.visitor.visitIndexName(ctx.uid(0).getText()));
    }

    @Override
    public T visitFullColumnName(OpenDistroSqlParser.FullColumnNameContext ctx) {
        return (T)((Reducible)this.visitor.visitFieldName(ctx.getText()));
    }

    @Override
    public T visitUdfFunctionCall(OpenDistroSqlParser.UdfFunctionCallContext ctx) {
        String funcName = ctx.fullId().getText();
        Reducible func = (Reducible)this.visitor.visitFunctionName(funcName);
        return (T)this.reduce(func, ctx.functionArgs());
    }

    @Override
    public T visitScalarFunctionCall(OpenDistroSqlParser.ScalarFunctionCallContext ctx) {
        UnsupportedSemanticVerifier.verify(ctx);
        Reducible func = (Reducible)this.visit((ParseTree)ctx.scalarFunctionName());
        return (T)this.reduce(func, ctx.functionArgs());
    }

    @Override
    public T visitMathOperator(OpenDistroSqlParser.MathOperatorContext ctx) {
        UnsupportedSemanticVerifier.verify(ctx);
        return (T)((Reducible)super.visitMathOperator(ctx));
    }

    @Override
    public T visitRegexpPredicate(OpenDistroSqlParser.RegexpPredicateContext ctx) {
        UnsupportedSemanticVerifier.verify(ctx);
        return (T)((Reducible)super.visitRegexpPredicate(ctx));
    }

    @Override
    public T visitSelectElements(OpenDistroSqlParser.SelectElementsContext ctx) {
        return (T)((Reducible)this.visitor.visitSelect(ctx.selectElement().stream().map(arg_0 -> ((AntlrSqlParseTreeVisitor)this).visit(arg_0)).collect(Collectors.toList())));
    }

    @Override
    public T visitSelectStarElement(OpenDistroSqlParser.SelectStarElementContext ctx) {
        return (T)((Reducible)this.visitor.visitSelectAllColumn());
    }

    @Override
    public T visitSelectColumnElement(OpenDistroSqlParser.SelectColumnElementContext ctx) {
        return this.visitSelectItem(ctx.fullColumnName(), ctx.uid());
    }

    @Override
    public T visitSelectFunctionElement(OpenDistroSqlParser.SelectFunctionElementContext ctx) {
        return this.visitSelectItem(ctx.functionCall(), ctx.uid());
    }

    @Override
    public T visitSelectExpressionElement(OpenDistroSqlParser.SelectExpressionElementContext ctx) {
        return this.visitSelectItem(ctx.expression(), ctx.uid());
    }

    @Override
    public T visitAggregateWindowedFunction(OpenDistroSqlParser.AggregateWindowedFunctionContext ctx) {
        String funcName = ctx.getChild(0).getText();
        Reducible func = (Reducible)this.visitor.visitFunctionName(funcName);
        return (T)this.reduce(func, ctx.functionArg());
    }

    @Override
    public T visitFunctionNameBase(OpenDistroSqlParser.FunctionNameBaseContext ctx) {
        return (T)((Reducible)this.visitor.visitFunctionName(ctx.getText()));
    }

    @Override
    public T visitBinaryComparisonPredicate(OpenDistroSqlParser.BinaryComparisonPredicateContext ctx) {
        if (this.isNamedArgument(ctx)) {
            return (T)this.defaultResult();
        }
        Reducible op = (Reducible)this.visit((ParseTree)ctx.comparisonOperator());
        return (T)this.reduce(op, Arrays.asList(ctx.left, ctx.right));
    }

    @Override
    public T visitIsExpression(OpenDistroSqlParser.IsExpressionContext ctx) {
        Reducible op = (Reducible)this.visitor.visitOperator("IS");
        return (T)op.reduce(Arrays.asList((Reducible)this.visit((ParseTree)ctx.predicate()), (Reducible)this.visitor.visitBoolean(ctx.testValue.getText())));
    }

    @Override
    public T visitConvertedDataType(OpenDistroSqlParser.ConvertedDataTypeContext ctx) {
        if (ctx.getChild(0) != null && !Strings.isNullOrEmpty((String)ctx.getChild(0).getText())) {
            return (T)((Reducible)this.visitor.visitConvertedType(ctx.getChild(0).getText()));
        }
        return (T)((Reducible)super.visitConvertedDataType(ctx));
    }

    @Override
    public T visitComparisonOperator(OpenDistroSqlParser.ComparisonOperatorContext ctx) {
        return (T)((Reducible)this.visitor.visitOperator(ctx.getText()));
    }

    @Override
    public T visitConstant(OpenDistroSqlParser.ConstantContext ctx) {
        if (ctx.REAL_LITERAL() != null) {
            return (T)((Reducible)this.visitor.visitFloat(ctx.getText()));
        }
        if (ctx.dateType != null) {
            return (T)((Reducible)this.visitor.visitDate(ctx.getText()));
        }
        if (ctx.nullLiteral != null) {
            return (T)((Reducible)this.visitor.visitNull());
        }
        return (T)((Reducible)super.visitConstant(ctx));
    }

    @Override
    public T visitStringLiteral(OpenDistroSqlParser.StringLiteralContext ctx) {
        return (T)((Reducible)this.visitor.visitString(ctx.getText()));
    }

    @Override
    public T visitDecimalLiteral(OpenDistroSqlParser.DecimalLiteralContext ctx) {
        return (T)((Reducible)this.visitor.visitInteger(ctx.getText()));
    }

    @Override
    public T visitBooleanLiteral(OpenDistroSqlParser.BooleanLiteralContext ctx) {
        return (T)((Reducible)this.visitor.visitBoolean(ctx.getText()));
    }

    protected T defaultResult() {
        return (T)((Reducible)this.visitor.defaultValue());
    }

    protected T aggregateResult(T aggregate, T nextResult) {
        if (nextResult != this.defaultResult()) {
            return nextResult;
        }
        return aggregate;
    }

    private boolean isNamedArgument(OpenDistroSqlParser.BinaryComparisonPredicateContext ctx) {
        if (ctx.getParent() != null && ctx.getParent().getParent() != null && ctx.getParent().getParent().getParent() != null && ctx.getParent().getParent().getParent() instanceof OpenDistroSqlParser.ScalarFunctionCallContext) {
            OpenDistroSqlParser.ScalarFunctionCallContext parent = (OpenDistroSqlParser.ScalarFunctionCallContext)ctx.getParent().getParent().getParent();
            return parent.scalarFunctionName().functionNameBase().esFunctionNameBase() != null;
        }
        return false;
    }

    private T visitJoin(List<ParseTree> children, OpenDistroSqlParser.TableSourceItemContext tableCtx) {
        Object result = this.defaultResult();
        for (ParseTree child : children) {
            if (child == tableCtx) {
                result = (Reducible)this.visit((ParseTree)tableCtx);
                continue;
            }
            this.visit(child);
        }
        return (T)result;
    }

    private T visitSelectItem(ParserRuleContext item, OpenDistroSqlParser.UidContext uid) {
        Reducible result = (Reducible)this.visit((ParseTree)item);
        if (uid != null) {
            this.visitor.visitAs(uid.getText(), result);
        }
        return (T)result;
    }

    private T reduce(T reducer, ParserRuleContext ctx) {
        return this.reduce(reducer, ctx == null ? Collections.emptyList() : ctx.children);
    }

    private <Node extends ParseTree> T reduce(T reducer, List<Node> nodes) {
        List args = nodes == null ? Collections.emptyList() : nodes.stream().map(arg_0 -> ((AntlrSqlParseTreeVisitor)this).visit(arg_0)).filter(type -> type != this.defaultResult()).collect(Collectors.toList());
        return reducer.reduce(args);
    }

    private <Node1 extends ParseTree, Node2 extends ParseTree> List<ParseTree> asList(Node1 first, List<Node2> rest) {
        ArrayList<ParseTree> result = new ArrayList<ParseTree>(Collections.singleton(first));
        result.addAll(rest);
        return result;
    }
}

