/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.opendistroforelasticsearch.sql.legacy.antlr.semantic.visitor;

import com.amazon.opendistroforelasticsearch.sql.legacy.antlr.semantic.scope.Environment;
import com.amazon.opendistroforelasticsearch.sql.legacy.antlr.semantic.scope.Namespace;
import com.amazon.opendistroforelasticsearch.sql.legacy.antlr.semantic.scope.SemanticContext;
import com.amazon.opendistroforelasticsearch.sql.legacy.antlr.semantic.scope.Symbol;
import com.amazon.opendistroforelasticsearch.sql.legacy.antlr.semantic.types.Type;
import com.amazon.opendistroforelasticsearch.sql.legacy.antlr.semantic.types.base.ESDataType;
import com.amazon.opendistroforelasticsearch.sql.legacy.antlr.semantic.types.base.ESIndex;
import com.amazon.opendistroforelasticsearch.sql.legacy.antlr.visitor.EarlyExitAnalysisException;
import com.amazon.opendistroforelasticsearch.sql.legacy.antlr.visitor.GenericSqlParseTreeVisitor;
import com.amazon.opendistroforelasticsearch.sql.legacy.esdomain.LocalClusterState;
import com.amazon.opendistroforelasticsearch.sql.legacy.esdomain.mapping.FieldMappings;
import com.amazon.opendistroforelasticsearch.sql.legacy.esdomain.mapping.IndexMappings;
import com.amazon.opendistroforelasticsearch.sql.legacy.utils.StringUtils;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

public class ESMappingLoader
implements GenericSqlParseTreeVisitor<Type> {
    private final SemanticContext context;
    private final LocalClusterState clusterState;
    private final int threshold;

    public ESMappingLoader(SemanticContext context, LocalClusterState clusterState, int threshold) {
        this.context = context;
        this.clusterState = clusterState;
        this.threshold = threshold;
    }

    @Override
    public Type visitIndexName(String indexName) {
        if (this.isNotNested(indexName)) {
            this.defineIndexType(indexName);
            this.loadAllFieldsWithType(indexName);
        }
        return (Type)this.defaultValue();
    }

    @Override
    public void visitAs(String alias, Type type) {
        if (!(type instanceof ESIndex)) {
            return;
        }
        ESIndex index = (ESIndex)type;
        String indexName = type.getName();
        if (index.type() == ESIndex.IndexType.INDEX) {
            String aliasName = alias.isEmpty() ? indexName : alias;
            this.defineAllFieldNamesByAppendingAliasPrefix(indexName, aliasName);
        } else if (index.type() == ESIndex.IndexType.NESTED_FIELD && !alias.isEmpty()) {
            this.defineNestedFieldNamesByReplacingWithAlias(indexName, alias);
        }
    }

    private void defineIndexType(String indexName) {
        this.environment().define(new Symbol(Namespace.FIELD_NAME, indexName), new ESIndex(indexName, ESIndex.IndexType.INDEX));
    }

    private void loadAllFieldsWithType(String indexName) {
        Set<FieldMappings> mappings = this.getFieldMappings(indexName);
        mappings.forEach(mapping -> mapping.flat(this::defineFieldName));
    }

    private void defineAllFieldNamesByAppendingAliasPrefix(String indexName, String alias) {
        Set<FieldMappings> mappings = this.getFieldMappings(indexName);
        mappings.stream().forEach(mapping -> mapping.flat((fieldName, type) -> this.defineFieldName(alias + "." + fieldName, (String)type)));
    }

    private void defineNestedFieldNamesByReplacingWithAlias(String nestedFieldName, String alias) {
        Map<String, Type> typeByFullName = this.environment().resolveByPrefix(new Symbol(Namespace.FIELD_NAME, nestedFieldName));
        typeByFullName.forEach((fieldName, fieldType) -> this.defineFieldName(fieldName.replace(nestedFieldName, alias), (Type)fieldType));
    }

    private boolean isNotNested(String indexName) {
        return indexName.indexOf(46, 1) == -1;
    }

    private Set<FieldMappings> getFieldMappings(String indexName) {
        IndexMappings indexMappings = this.clusterState.getFieldMappings(new String[]{indexName});
        Set<FieldMappings> fieldMappingsSet = indexMappings.allMappings().stream().flatMap(typeMappings -> typeMappings.allMappings().stream()).collect(Collectors.toSet());
        for (FieldMappings fieldMappings : fieldMappingsSet) {
            int size = fieldMappings.data().size();
            if (size <= this.threshold) continue;
            throw new EarlyExitAnalysisException(StringUtils.format("Index [%s] has [%d] fields more than threshold [%d]", indexName, size, this.threshold));
        }
        return fieldMappingsSet;
    }

    private void defineFieldName(String fieldName, String type) {
        if ("NESTED".equalsIgnoreCase(type)) {
            this.defineFieldName(fieldName, new ESIndex(fieldName, ESIndex.IndexType.NESTED_FIELD));
        } else {
            this.defineFieldName(fieldName, ESDataType.typeOf(type));
        }
    }

    private void defineFieldName(String fieldName, Type type) {
        Symbol symbol = new Symbol(Namespace.FIELD_NAME, fieldName);
        this.environment().define(symbol, type);
    }

    private Environment environment() {
        return this.context.peek();
    }
}

