/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.opendistroforelasticsearch.sql.legacy.antlr.semantic.types.base;

import com.amazon.opendistroforelasticsearch.sql.legacy.antlr.semantic.types.Type;
import com.amazon.opendistroforelasticsearch.sql.legacy.antlr.semantic.types.base.BaseType;
import com.amazon.opendistroforelasticsearch.sql.legacy.antlr.semantic.types.base.ESIndex;
import com.amazon.opendistroforelasticsearch.sql.legacy.utils.StringUtils;
import com.google.common.collect.ImmutableMap;
import java.util.Map;

public enum ESDataType implements BaseType
{
    TYPE_ERROR(new ESDataType[0]),
    UNKNOWN(new ESDataType[0]),
    SHORT(new ESDataType[0]),
    LONG(new ESDataType[0]),
    INTEGER(SHORT, LONG),
    FLOAT(INTEGER),
    DOUBLE(FLOAT),
    NUMBER(DOUBLE),
    KEYWORD(new ESDataType[0]),
    TEXT(KEYWORD),
    STRING(TEXT),
    DATE_NANOS(new ESDataType[0]),
    DATE(DATE_NANOS, STRING),
    BOOLEAN(new ESDataType[0]),
    OBJECT(new ESDataType[0]),
    NESTED(new ESDataType[0]),
    COMPLEX(OBJECT, NESTED),
    GEO_POINT(new ESDataType[0]),
    ES_TYPE(NUMBER, DATE, BOOLEAN, COMPLEX, GEO_POINT);

    private static final Map<String, ESDataType> ALL_BASE_TYPES;
    private ESDataType parent;

    public static ESDataType typeOf(String str) {
        return ALL_BASE_TYPES.getOrDefault(StringUtils.toUpper(str), UNKNOWN);
    }

    private ESDataType(ESDataType ... compatibleTypes) {
        for (ESDataType subType : compatibleTypes) {
            subType.parent = this;
        }
    }

    @Override
    public String getName() {
        return this.name();
    }

    @Override
    public boolean isCompatible(Type other) {
        if (this == UNKNOWN || other == UNKNOWN) {
            return true;
        }
        if (!(other instanceof ESDataType)) {
            if (other instanceof ESIndex && ((ESIndex)other).type() == ESIndex.IndexType.NESTED_FIELD) {
                return this.isCompatible(NESTED);
            }
            return false;
        }
        ESDataType cur = (ESDataType)other;
        while (cur != null && cur != this) {
            cur = cur.parent;
        }
        return cur != null;
    }

    public String toString() {
        return "ES Data Type [" + this.getName() + "]";
    }

    static {
        ImmutableMap.Builder builder = new ImmutableMap.Builder();
        for (ESDataType type : ESDataType.values()) {
            builder.put((Object)type.name(), (Object)type);
        }
        ALL_BASE_TYPES = builder.build();
    }
}

