/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.opendistroforelasticsearch.sql.legacy.antlr.semantic.scope;

import com.amazon.opendistroforelasticsearch.sql.legacy.antlr.semantic.scope.Namespace;
import com.amazon.opendistroforelasticsearch.sql.legacy.antlr.semantic.scope.Symbol;
import com.amazon.opendistroforelasticsearch.sql.legacy.antlr.semantic.scope.SymbolTable;
import com.amazon.opendistroforelasticsearch.sql.legacy.antlr.semantic.types.Type;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;

public class Environment {
    private final Environment parent;
    private final SymbolTable symbolTable;

    public Environment(Environment parent) {
        this.parent = parent;
        this.symbolTable = new SymbolTable();
    }

    public void define(Symbol symbol, Type type) {
        this.symbolTable.store(symbol, type);
    }

    public Optional<Type> resolve(Symbol symbol) {
        Optional<Type> type = Optional.empty();
        Environment cur = this;
        while (cur != null && !(type = cur.symbolTable.lookup(symbol)).isPresent()) {
            cur = cur.parent;
        }
        return type;
    }

    public Map<String, Type> resolveByPrefix(Symbol prefix) {
        HashMap<String, Type> typeByName = new HashMap<String, Type>();
        Environment cur = this;
        while (cur != null) {
            typeByName.putAll(cur.symbolTable.lookupByPrefix(prefix));
            cur = cur.parent;
        }
        return typeByName;
    }

    public Map<String, Type> resolveAll(Namespace namespace) {
        HashMap<String, Type> result = new HashMap<String, Type>();
        Environment cur = this;
        while (cur != null) {
            cur.symbolTable.lookupAll(namespace).forEach(result::putIfAbsent);
            cur = cur.parent;
        }
        return result;
    }

    public boolean isEmpty(Namespace namespace) {
        Environment cur = this;
        while (cur != null) {
            if (!cur.symbolTable.isEmpty(namespace)) {
                return false;
            }
            cur = cur.parent;
        }
        return true;
    }

    public Environment getParent() {
        return this.parent;
    }
}

