/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.opendistroforelasticsearch.sql.legacy.antlr;

import com.amazon.opendistroforelasticsearch.sql.legacy.antlr.SqlAnalysisConfig;
import com.amazon.opendistroforelasticsearch.sql.legacy.antlr.parser.OpenDistroSqlLexer;
import com.amazon.opendistroforelasticsearch.sql.legacy.antlr.parser.OpenDistroSqlParser;
import com.amazon.opendistroforelasticsearch.sql.legacy.antlr.semantic.scope.SemanticContext;
import com.amazon.opendistroforelasticsearch.sql.legacy.antlr.semantic.types.Type;
import com.amazon.opendistroforelasticsearch.sql.legacy.antlr.semantic.visitor.ESMappingLoader;
import com.amazon.opendistroforelasticsearch.sql.legacy.antlr.semantic.visitor.SemanticAnalyzer;
import com.amazon.opendistroforelasticsearch.sql.legacy.antlr.semantic.visitor.TypeChecker;
import com.amazon.opendistroforelasticsearch.sql.legacy.antlr.syntax.CaseInsensitiveCharStream;
import com.amazon.opendistroforelasticsearch.sql.legacy.antlr.syntax.SyntaxAnalysisErrorListener;
import com.amazon.opendistroforelasticsearch.sql.legacy.antlr.visitor.AntlrSqlParseTreeVisitor;
import com.amazon.opendistroforelasticsearch.sql.legacy.antlr.visitor.EarlyExitAnalysisException;
import com.amazon.opendistroforelasticsearch.sql.legacy.esdomain.LocalClusterState;
import java.util.Optional;
import org.antlr.v4.runtime.ANTLRErrorListener;
import org.antlr.v4.runtime.CommonTokenStream;
import org.antlr.v4.runtime.Lexer;
import org.antlr.v4.runtime.TokenSource;
import org.antlr.v4.runtime.TokenStream;
import org.antlr.v4.runtime.tree.ParseTree;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class OpenDistroSqlAnalyzer {
    private static final Logger LOG = LogManager.getLogger();
    private final SqlAnalysisConfig config;

    public OpenDistroSqlAnalyzer(SqlAnalysisConfig config) {
        this.config = config;
    }

    public Optional<Type> analyze(String sql, LocalClusterState clusterState) {
        if (!this.isSelectStatement(sql) || !this.config.isAnalyzerEnabled()) {
            return Optional.empty();
        }
        try {
            return Optional.of(this.analyzeSemantic(this.analyzeSyntax(sql), clusterState));
        }
        catch (EarlyExitAnalysisException e) {
            LOG.debug("Analysis exits early and will skip remaining process", (Throwable)e);
            return Optional.empty();
        }
    }

    public ParseTree analyzeSyntax(String sql) {
        OpenDistroSqlParser parser = this.createParser(this.createLexer(sql));
        parser.addErrorListener((ANTLRErrorListener)new SyntaxAnalysisErrorListener());
        return parser.root();
    }

    public Type analyzeSemantic(ParseTree tree, LocalClusterState clusterState) {
        return (Type)tree.accept(new AntlrSqlParseTreeVisitor<Type>(this.createAnalyzer(clusterState)));
    }

    private SemanticAnalyzer createAnalyzer(LocalClusterState clusterState) {
        SemanticContext context = new SemanticContext();
        ESMappingLoader mappingLoader = new ESMappingLoader(context, clusterState, this.config.getAnalysisThreshold());
        TypeChecker typeChecker = new TypeChecker(context, this.config.isFieldSuggestionEnabled());
        return new SemanticAnalyzer(mappingLoader, typeChecker);
    }

    private OpenDistroSqlParser createParser(Lexer lexer) {
        return new OpenDistroSqlParser((TokenStream)new CommonTokenStream((TokenSource)lexer));
    }

    private OpenDistroSqlLexer createLexer(String sql) {
        return new OpenDistroSqlLexer(new CaseInsensitiveCharStream(sql));
    }

    private boolean isSelectStatement(String sql) {
        int endOfFirstWord = (sql = sql.replaceAll("\\R", " ").trim()).indexOf(32);
        String firstWord = sql.substring(0, endOfFirstWord > 0 ? endOfFirstWord : sql.length());
        return "SELECT".equalsIgnoreCase(firstWord);
    }
}

