/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.opendistroforelasticsearch.sql.planner.physical;

import com.amazon.opendistroforelasticsearch.sql.ast.tree.Sort;
import com.amazon.opendistroforelasticsearch.sql.data.model.ExprValue;
import com.amazon.opendistroforelasticsearch.sql.data.utils.ExprValueOrdering;
import com.amazon.opendistroforelasticsearch.sql.expression.Expression;
import com.amazon.opendistroforelasticsearch.sql.planner.physical.PhysicalPlan;
import com.amazon.opendistroforelasticsearch.sql.planner.physical.PhysicalPlanNodeVisitor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.PriorityQueue;
import lombok.Generated;
import org.apache.commons.lang3.tuple.Pair;

public class SortOperator
extends PhysicalPlan {
    private final PhysicalPlan input;
    private final List<Pair<Sort.SortOption, Expression>> sortList;
    private final Sorter sorter;
    private Iterator<ExprValue> iterator;

    public SortOperator(PhysicalPlan input, List<Pair<Sort.SortOption, Expression>> sortList) {
        this.input = input;
        this.sortList = sortList;
        Sorter.SorterBuilder sorterBuilder = Sorter.builder();
        for (Pair<Sort.SortOption, Expression> pair : sortList) {
            Sort.SortOption option = (Sort.SortOption)pair.getLeft();
            ExprValueOrdering ordering = Sort.SortOrder.ASC.equals((Object)option.getSortOrder()) ? ExprValueOrdering.natural() : ExprValueOrdering.natural().reverse();
            ordering = Sort.NullOrder.NULL_FIRST.equals((Object)option.getNullOrder()) ? ordering.nullsFirst() : ordering.nullsLast();
            sorterBuilder.comparator((Pair<Expression, Comparator<ExprValue>>)Pair.of((Object)((Expression)pair.getRight()), (Object)ordering));
        }
        this.sorter = sorterBuilder.build();
    }

    @Override
    public <R, C> R accept(PhysicalPlanNodeVisitor<R, C> visitor, C context) {
        return visitor.visitSort(this, context);
    }

    @Override
    public void open() {
        super.open();
        PriorityQueue<ExprValue> sorted = new PriorityQueue<ExprValue>(1, this.sorter::compare);
        while (this.input.hasNext()) {
            sorted.add((ExprValue)this.input.next());
        }
        this.iterator = this.iterator(sorted);
    }

    @Override
    public List<PhysicalPlan> getChild() {
        return Collections.singletonList(this.input);
    }

    @Override
    public boolean hasNext() {
        return this.iterator.hasNext();
    }

    @Override
    public ExprValue next() {
        return this.iterator.next();
    }

    private Iterator<ExprValue> iterator(final PriorityQueue<ExprValue> result) {
        return new Iterator<ExprValue>(){

            @Override
            public boolean hasNext() {
                return !result.isEmpty();
            }

            @Override
            public ExprValue next() {
                return (ExprValue)result.poll();
            }
        };
    }

    @Generated
    public String toString() {
        return "SortOperator(input=" + this.getInput() + ", sortList=" + this.getSortList() + ", sorter=" + this.sorter + ", iterator=" + this.iterator + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SortOperator)) {
            return false;
        }
        SortOperator other = (SortOperator)o;
        if (!other.canEqual(this)) {
            return false;
        }
        PhysicalPlan this$input = this.getInput();
        PhysicalPlan other$input = other.getInput();
        if (this$input == null ? other$input != null : !this$input.equals(other$input)) {
            return false;
        }
        List<Pair<Sort.SortOption, Expression>> this$sortList = this.getSortList();
        List<Pair<Sort.SortOption, Expression>> other$sortList = other.getSortList();
        return !(this$sortList == null ? other$sortList != null : !((Object)this$sortList).equals(other$sortList));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof SortOperator;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        PhysicalPlan $input = this.getInput();
        result = result * 59 + ($input == null ? 43 : $input.hashCode());
        List<Pair<Sort.SortOption, Expression>> $sortList = this.getSortList();
        result = result * 59 + ($sortList == null ? 43 : ((Object)$sortList).hashCode());
        return result;
    }

    @Generated
    public PhysicalPlan getInput() {
        return this.input;
    }

    @Generated
    public List<Pair<Sort.SortOption, Expression>> getSortList() {
        return this.sortList;
    }

    public static class Sorter
    implements Comparator<ExprValue> {
        private final List<Pair<Expression, Comparator<ExprValue>>> comparators;

        @Override
        public int compare(ExprValue o1, ExprValue o2) {
            for (Pair<Expression, Comparator<ExprValue>> comparator : this.comparators) {
                Expression expression = (Expression)comparator.getKey();
                int result = ((Comparator)comparator.getValue()).compare(expression.valueOf(o1.bindingTuples()), expression.valueOf(o2.bindingTuples()));
                if (result == 0) continue;
                return result;
            }
            return 0;
        }

        @Generated
        Sorter(List<Pair<Expression, Comparator<ExprValue>>> comparators) {
            this.comparators = comparators;
        }

        @Generated
        public static SorterBuilder builder() {
            return new SorterBuilder();
        }

        @Generated
        public static class SorterBuilder {
            @Generated
            private ArrayList<Pair<Expression, Comparator<ExprValue>>> comparators;

            @Generated
            SorterBuilder() {
            }

            @Generated
            public SorterBuilder comparator(Pair<Expression, Comparator<ExprValue>> comparator) {
                if (this.comparators == null) {
                    this.comparators = new ArrayList();
                }
                this.comparators.add(comparator);
                return this;
            }

            @Generated
            public SorterBuilder comparators(Collection<? extends Pair<Expression, Comparator<ExprValue>>> comparators) {
                if (comparators == null) {
                    throw new NullPointerException("comparators cannot be null");
                }
                if (this.comparators == null) {
                    this.comparators = new ArrayList();
                }
                this.comparators.addAll(comparators);
                return this;
            }

            @Generated
            public SorterBuilder clearComparators() {
                if (this.comparators != null) {
                    this.comparators.clear();
                }
                return this;
            }

            @Generated
            public Sorter build() {
                List<Pair<Expression, Comparator<ExprValue>>> comparators;
                switch (this.comparators == null ? 0 : this.comparators.size()) {
                    case 0: {
                        comparators = Collections.emptyList();
                        break;
                    }
                    case 1: {
                        comparators = Collections.singletonList(this.comparators.get(0));
                        break;
                    }
                    default: {
                        comparators = Collections.unmodifiableList(new ArrayList<Pair<Expression, Comparator<ExprValue>>>(this.comparators));
                    }
                }
                return new Sorter(comparators);
            }

            @Generated
            public String toString() {
                return "SortOperator.Sorter.SorterBuilder(comparators=" + this.comparators + ")";
            }
        }
    }
}

