/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.opendistroforelasticsearch.sql.planner.physical;

import com.amazon.opendistroforelasticsearch.sql.data.model.ExprTupleValue;
import com.amazon.opendistroforelasticsearch.sql.data.model.ExprValue;
import com.amazon.opendistroforelasticsearch.sql.executor.ExecutionEngine;
import com.amazon.opendistroforelasticsearch.sql.expression.NamedExpression;
import com.amazon.opendistroforelasticsearch.sql.planner.physical.PhysicalPlan;
import com.amazon.opendistroforelasticsearch.sql.planner.physical.PhysicalPlanNodeVisitor;
import com.google.common.collect.ImmutableMap;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import lombok.Generated;

public class ProjectOperator
extends PhysicalPlan {
    private final PhysicalPlan input;
    private final List<NamedExpression> projectList;

    @Override
    public <R, C> R accept(PhysicalPlanNodeVisitor<R, C> visitor, C context) {
        return visitor.visitProject(this, context);
    }

    @Override
    public List<PhysicalPlan> getChild() {
        return Collections.singletonList(this.input);
    }

    @Override
    public boolean hasNext() {
        return this.input.hasNext();
    }

    @Override
    public ExprValue next() {
        ExprValue inputValue = (ExprValue)this.input.next();
        ImmutableMap.Builder mapBuilder = new ImmutableMap.Builder();
        for (NamedExpression expr : this.projectList) {
            ExprValue exprValue = expr.valueOf(inputValue.bindingTuples());
            mapBuilder.put((Object)expr.getNameOrAlias(), (Object)exprValue);
        }
        return ExprTupleValue.fromExprValueMap((Map<String, ExprValue>)mapBuilder.build());
    }

    @Override
    public ExecutionEngine.Schema schema() {
        return new ExecutionEngine.Schema(this.getProjectList().stream().map(expr -> new ExecutionEngine.Schema.Column(expr.getName(), expr.getAlias(), expr.type())).collect(Collectors.toList()));
    }

    @Generated
    public String toString() {
        return "ProjectOperator(input=" + this.getInput() + ", projectList=" + this.getProjectList() + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ProjectOperator)) {
            return false;
        }
        ProjectOperator other = (ProjectOperator)o;
        if (!other.canEqual(this)) {
            return false;
        }
        PhysicalPlan this$input = this.getInput();
        PhysicalPlan other$input = other.getInput();
        if (this$input == null ? other$input != null : !this$input.equals(other$input)) {
            return false;
        }
        List<NamedExpression> this$projectList = this.getProjectList();
        List<NamedExpression> other$projectList = other.getProjectList();
        return !(this$projectList == null ? other$projectList != null : !((Object)this$projectList).equals(other$projectList));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof ProjectOperator;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        PhysicalPlan $input = this.getInput();
        result = result * 59 + ($input == null ? 43 : $input.hashCode());
        List<NamedExpression> $projectList = this.getProjectList();
        result = result * 59 + ($projectList == null ? 43 : ((Object)$projectList).hashCode());
        return result;
    }

    @Generated
    public ProjectOperator(PhysicalPlan input, List<NamedExpression> projectList) {
        this.input = input;
        this.projectList = projectList;
    }

    @Generated
    public PhysicalPlan getInput() {
        return this.input;
    }

    @Generated
    public List<NamedExpression> getProjectList() {
        return this.projectList;
    }
}

