/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.opendistroforelasticsearch.sql.planner.physical;

import com.amazon.opendistroforelasticsearch.sql.data.model.ExprTupleValue;
import com.amazon.opendistroforelasticsearch.sql.data.model.ExprValue;
import com.amazon.opendistroforelasticsearch.sql.data.model.ExprValueUtils;
import com.amazon.opendistroforelasticsearch.sql.data.type.ExprCoreType;
import com.amazon.opendistroforelasticsearch.sql.expression.Expression;
import com.amazon.opendistroforelasticsearch.sql.expression.ReferenceExpression;
import com.amazon.opendistroforelasticsearch.sql.expression.env.Environment;
import com.amazon.opendistroforelasticsearch.sql.planner.physical.PhysicalPlan;
import com.amazon.opendistroforelasticsearch.sql.planner.physical.PhysicalPlanNodeVisitor;
import com.google.common.collect.ImmutableMap;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import org.apache.commons.lang3.tuple.Pair;

public class EvalOperator
extends PhysicalPlan {
    private final PhysicalPlan input;
    private final List<Pair<ReferenceExpression, Expression>> expressionList;

    @Override
    public <R, C> R accept(PhysicalPlanNodeVisitor<R, C> visitor, C context) {
        return visitor.visitEval(this, context);
    }

    @Override
    public List<PhysicalPlan> getChild() {
        return Collections.singletonList(this.input);
    }

    @Override
    public boolean hasNext() {
        return this.input.hasNext();
    }

    @Override
    public ExprValue next() {
        ExprValue inputValue = (ExprValue)this.input.next();
        Map<String, ExprValue> evalMap = this.eval(inputValue.bindingTuples());
        if (ExprCoreType.STRUCT == inputValue.type()) {
            ImmutableMap.Builder resultBuilder = new ImmutableMap.Builder();
            Map<String, ExprValue> tupleValue = ExprValueUtils.getTupleValue(inputValue);
            for (Map.Entry<String, ExprValue> valueEntry : tupleValue.entrySet()) {
                if (evalMap.containsKey(valueEntry.getKey())) {
                    resultBuilder.put((Object)valueEntry.getKey(), (Object)evalMap.get(valueEntry.getKey()));
                    evalMap.remove(valueEntry.getKey());
                    continue;
                }
                resultBuilder.put(valueEntry);
            }
            resultBuilder.putAll(evalMap);
            return ExprTupleValue.fromExprValueMap((Map<String, ExprValue>)resultBuilder.build());
        }
        return inputValue;
    }

    private Map<String, ExprValue> eval(Environment<Expression, ExprValue> env) {
        LinkedHashMap<String, ExprValue> evalResultMap = new LinkedHashMap<String, ExprValue>();
        for (Pair<ReferenceExpression, Expression> pair : this.expressionList) {
            ReferenceExpression var = (ReferenceExpression)pair.getKey();
            ExprValue value = ((Expression)pair.getValue()).valueOf(env);
            env = Environment.extendEnv(env, var, value);
            evalResultMap.put(var.toString(), value);
        }
        return evalResultMap;
    }

    @Generated
    public String toString() {
        return "EvalOperator(input=" + this.getInput() + ", expressionList=" + this.getExpressionList() + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof EvalOperator)) {
            return false;
        }
        EvalOperator other = (EvalOperator)o;
        if (!other.canEqual(this)) {
            return false;
        }
        PhysicalPlan this$input = this.getInput();
        PhysicalPlan other$input = other.getInput();
        if (this$input == null ? other$input != null : !this$input.equals(other$input)) {
            return false;
        }
        List<Pair<ReferenceExpression, Expression>> this$expressionList = this.getExpressionList();
        List<Pair<ReferenceExpression, Expression>> other$expressionList = other.getExpressionList();
        return !(this$expressionList == null ? other$expressionList != null : !((Object)this$expressionList).equals(other$expressionList));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof EvalOperator;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        PhysicalPlan $input = this.getInput();
        result = result * 59 + ($input == null ? 43 : $input.hashCode());
        List<Pair<ReferenceExpression, Expression>> $expressionList = this.getExpressionList();
        result = result * 59 + ($expressionList == null ? 43 : ((Object)$expressionList).hashCode());
        return result;
    }

    @Generated
    public EvalOperator(PhysicalPlan input, List<Pair<ReferenceExpression, Expression>> expressionList) {
        this.input = input;
        this.expressionList = expressionList;
    }

    @Generated
    public PhysicalPlan getInput() {
        return this.input;
    }

    @Generated
    public List<Pair<ReferenceExpression, Expression>> getExpressionList() {
        return this.expressionList;
    }
}

