/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.opendistroforelasticsearch.sql.planner.physical;

import com.amazon.opendistroforelasticsearch.sql.data.model.ExprValue;
import com.amazon.opendistroforelasticsearch.sql.expression.Expression;
import com.amazon.opendistroforelasticsearch.sql.planner.physical.PhysicalPlan;
import com.amazon.opendistroforelasticsearch.sql.planner.physical.PhysicalPlanNodeVisitor;
import com.amazon.opendistroforelasticsearch.sql.storage.bindingtuple.BindingTuple;
import com.google.common.collect.ImmutableList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.BiFunction;
import java.util.function.Predicate;
import lombok.Generated;
import lombok.NonNull;

public class DedupeOperator
extends PhysicalPlan {
    private final PhysicalPlan input;
    private final List<Expression> dedupeList;
    private final Integer allowedDuplication;
    private final Boolean keepEmpty;
    private final Boolean consecutive;
    private final Deduper<List<ExprValue>> deduper;
    private ExprValue next;
    private static final Integer ALL_ONE_DUPLICATION = 1;
    private static final Boolean IGNORE_EMPTY = false;
    private static final Boolean NON_CONSECUTIVE = false;
    private static final Predicate<ExprValue> NULL_OR_MISSING = v -> v.isNull() || v.isMissing();
    private static final Integer SEEN_FIRST_TIME = 1;

    public @NonNull DedupeOperator(PhysicalPlan input, List<Expression> dedupeList) {
        this(input, dedupeList, ALL_ONE_DUPLICATION, IGNORE_EMPTY, NON_CONSECUTIVE);
    }

    public @NonNull DedupeOperator(PhysicalPlan input, List<Expression> dedupeList, Integer allowedDuplication, Boolean keepEmpty, Boolean consecutive) {
        this.input = input;
        this.dedupeList = dedupeList;
        this.allowedDuplication = allowedDuplication;
        this.keepEmpty = keepEmpty;
        this.consecutive = consecutive;
        this.deduper = this.consecutive != false ? Deduper.consecutiveDeduper() : Deduper.historicalDeduper();
    }

    @Override
    public <R, C> R accept(PhysicalPlanNodeVisitor<R, C> visitor, C context) {
        return visitor.visitDedupe(this, context);
    }

    @Override
    public List<PhysicalPlan> getChild() {
        return Collections.singletonList(this.input);
    }

    @Override
    public boolean hasNext() {
        while (this.input.hasNext()) {
            ExprValue next = (ExprValue)this.input.next();
            if (!this.keep(next)) continue;
            this.next = next;
            return true;
        }
        return false;
    }

    @Override
    public ExprValue next() {
        return this.next;
    }

    public boolean keep(ExprValue value) {
        BindingTuple bindingTuple = value.bindingTuples();
        ImmutableList.Builder dedupeKeyBuilder = new ImmutableList.Builder();
        for (Expression expression : this.dedupeList) {
            ExprValue exprValue = expression.valueOf(bindingTuple);
            if (NULL_OR_MISSING.test(exprValue)) {
                return this.keepEmpty;
            }
            dedupeKeyBuilder.add((Object)exprValue);
        }
        ImmutableList dedupeKey = dedupeKeyBuilder.build();
        int seenTimes = this.deduper.seenTimes((List<ExprValue>)dedupeKey);
        return seenTimes <= this.allowedDuplication;
    }

    @Generated
    public Deduper<List<ExprValue>> getDeduper() {
        return this.deduper;
    }

    @Generated
    public ExprValue getNext() {
        return this.next;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DedupeOperator)) {
            return false;
        }
        DedupeOperator other = (DedupeOperator)o;
        if (!other.canEqual(this)) {
            return false;
        }
        PhysicalPlan this$input = this.getInput();
        PhysicalPlan other$input = other.getInput();
        if (this$input == null ? other$input != null : !this$input.equals(other$input)) {
            return false;
        }
        List<Expression> this$dedupeList = this.getDedupeList();
        List<Expression> other$dedupeList = other.getDedupeList();
        if (this$dedupeList == null ? other$dedupeList != null : !((Object)this$dedupeList).equals(other$dedupeList)) {
            return false;
        }
        Integer this$allowedDuplication = this.getAllowedDuplication();
        Integer other$allowedDuplication = other.getAllowedDuplication();
        if (this$allowedDuplication == null ? other$allowedDuplication != null : !((Object)this$allowedDuplication).equals(other$allowedDuplication)) {
            return false;
        }
        Boolean this$keepEmpty = this.getKeepEmpty();
        Boolean other$keepEmpty = other.getKeepEmpty();
        if (this$keepEmpty == null ? other$keepEmpty != null : !((Object)this$keepEmpty).equals(other$keepEmpty)) {
            return false;
        }
        Boolean this$consecutive = this.getConsecutive();
        Boolean other$consecutive = other.getConsecutive();
        return !(this$consecutive == null ? other$consecutive != null : !((Object)this$consecutive).equals(other$consecutive));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof DedupeOperator;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        PhysicalPlan $input = this.getInput();
        result = result * 59 + ($input == null ? 43 : $input.hashCode());
        List<Expression> $dedupeList = this.getDedupeList();
        result = result * 59 + ($dedupeList == null ? 43 : ((Object)$dedupeList).hashCode());
        Integer $allowedDuplication = this.getAllowedDuplication();
        result = result * 59 + ($allowedDuplication == null ? 43 : ((Object)$allowedDuplication).hashCode());
        Boolean $keepEmpty = this.getKeepEmpty();
        result = result * 59 + ($keepEmpty == null ? 43 : ((Object)$keepEmpty).hashCode());
        Boolean $consecutive = this.getConsecutive();
        result = result * 59 + ($consecutive == null ? 43 : ((Object)$consecutive).hashCode());
        return result;
    }

    @Generated
    public PhysicalPlan getInput() {
        return this.input;
    }

    @Generated
    public List<Expression> getDedupeList() {
        return this.dedupeList;
    }

    @Generated
    public Integer getAllowedDuplication() {
        return this.allowedDuplication;
    }

    @Generated
    public Boolean getKeepEmpty() {
        return this.keepEmpty;
    }

    @Generated
    public Boolean getConsecutive() {
        return this.consecutive;
    }

    static class Deduper<K> {
        private final BiFunction<Map<K, Integer>, K, Integer> seenFirstTime;
        private final Map<K, Integer> seenMap = new ConcurrentHashMap<K, Integer>();

        public static <K> Deduper<K> historicalDeduper() {
            return new Deduper<Object>((map, key) -> {
                map.put(key, SEEN_FIRST_TIME);
                return SEEN_FIRST_TIME;
            });
        }

        public static <K> Deduper<K> consecutiveDeduper() {
            return new Deduper<Object>((map, key) -> {
                map.clear();
                map.put(key, SEEN_FIRST_TIME);
                return SEEN_FIRST_TIME;
            });
        }

        public int seenTimes(K dedupeKey) {
            if (this.seenMap.containsKey(dedupeKey)) {
                return this.seenMap.computeIfPresent(dedupeKey, (k, v) -> v + 1);
            }
            return this.seenFirstTime.apply(this.seenMap, dedupeKey);
        }

        @Generated
        public Deduper(BiFunction<Map<K, Integer>, K, Integer> seenFirstTime) {
            this.seenFirstTime = seenFirstTime;
        }
    }
}

