/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.opendistroforelasticsearch.sql.planner.physical;

import com.amazon.opendistroforelasticsearch.sql.data.model.ExprTupleValue;
import com.amazon.opendistroforelasticsearch.sql.data.model.ExprValue;
import com.amazon.opendistroforelasticsearch.sql.expression.Expression;
import com.amazon.opendistroforelasticsearch.sql.expression.NamedExpression;
import com.amazon.opendistroforelasticsearch.sql.expression.aggregation.AggregationState;
import com.amazon.opendistroforelasticsearch.sql.expression.aggregation.NamedAggregator;
import com.amazon.opendistroforelasticsearch.sql.planner.physical.PhysicalPlan;
import com.amazon.opendistroforelasticsearch.sql.planner.physical.PhysicalPlanNodeVisitor;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import lombok.Generated;

public class AggregationOperator
extends PhysicalPlan {
    private final PhysicalPlan input;
    private final List<NamedAggregator> aggregatorList;
    private final List<NamedExpression> groupByExprList;
    private final Group group;
    private Iterator<ExprValue> iterator;

    public AggregationOperator(PhysicalPlan input, List<NamedAggregator> aggregatorList, List<NamedExpression> groupByExprList) {
        this.input = input;
        this.aggregatorList = aggregatorList;
        this.groupByExprList = groupByExprList;
        this.group = new Group();
    }

    @Override
    public <R, C> R accept(PhysicalPlanNodeVisitor<R, C> visitor, C context) {
        return visitor.visitAggregation(this, context);
    }

    @Override
    public List<PhysicalPlan> getChild() {
        return Collections.singletonList(this.input);
    }

    @Override
    public boolean hasNext() {
        return this.iterator.hasNext();
    }

    @Override
    public ExprValue next() {
        return this.iterator.next();
    }

    @Override
    public void open() {
        super.open();
        while (this.input.hasNext()) {
            this.group.push((ExprValue)this.input.next());
        }
        this.iterator = this.group.result().iterator();
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AggregationOperator)) {
            return false;
        }
        AggregationOperator other = (AggregationOperator)o;
        if (!other.canEqual(this)) {
            return false;
        }
        PhysicalPlan this$input = this.getInput();
        PhysicalPlan other$input = other.getInput();
        if (this$input == null ? other$input != null : !this$input.equals(other$input)) {
            return false;
        }
        List<NamedAggregator> this$aggregatorList = this.getAggregatorList();
        List<NamedAggregator> other$aggregatorList = other.getAggregatorList();
        if (this$aggregatorList == null ? other$aggregatorList != null : !((Object)this$aggregatorList).equals(other$aggregatorList)) {
            return false;
        }
        List<NamedExpression> this$groupByExprList = this.getGroupByExprList();
        List<NamedExpression> other$groupByExprList = other.getGroupByExprList();
        return !(this$groupByExprList == null ? other$groupByExprList != null : !((Object)this$groupByExprList).equals(other$groupByExprList));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof AggregationOperator;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        PhysicalPlan $input = this.getInput();
        result = result * 59 + ($input == null ? 43 : $input.hashCode());
        List<NamedAggregator> $aggregatorList = this.getAggregatorList();
        result = result * 59 + ($aggregatorList == null ? 43 : ((Object)$aggregatorList).hashCode());
        List<NamedExpression> $groupByExprList = this.getGroupByExprList();
        result = result * 59 + ($groupByExprList == null ? 43 : ((Object)$groupByExprList).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "AggregationOperator(input=" + this.getInput() + ", aggregatorList=" + this.getAggregatorList() + ", groupByExprList=" + this.getGroupByExprList() + ", group=" + this.group + ", iterator=" + this.iterator + ")";
    }

    @Generated
    public PhysicalPlan getInput() {
        return this.input;
    }

    @Generated
    public List<NamedAggregator> getAggregatorList() {
        return this.aggregatorList;
    }

    @Generated
    public List<NamedExpression> getGroupByExprList() {
        return this.groupByExprList;
    }

    @VisibleForTesting
    public class Group {
        private final Map<GroupKey, List<Map.Entry<NamedAggregator, AggregationState>>> groupListMap = new HashMap<GroupKey, List<Map.Entry<NamedAggregator, AggregationState>>>();

        public void push(ExprValue inputValue) {
            GroupKey groupKey = new GroupKey(inputValue);
            this.groupListMap.computeIfAbsent(groupKey, k -> AggregationOperator.this.aggregatorList.stream().map(aggregator -> new AbstractMap.SimpleEntry<NamedAggregator, AggregationState>((NamedAggregator)aggregator, aggregator.create())).collect(Collectors.toList()));
            this.groupListMap.computeIfPresent(groupKey, (key, aggregatorList) -> {
                aggregatorList.forEach(entry -> ((NamedAggregator)entry.getKey()).iterate(inputValue.bindingTuples(), (AggregationState)entry.getValue()));
                return aggregatorList;
            });
        }

        public List<ExprValue> result() {
            ImmutableList.Builder resultBuilder = new ImmutableList.Builder();
            for (Map.Entry<GroupKey, List<Map.Entry<NamedAggregator, AggregationState>>> entry : this.groupListMap.entrySet()) {
                LinkedHashMap<String, ExprValue> map = new LinkedHashMap<String, ExprValue>();
                map.putAll(entry.getKey().groupKeyMap());
                for (Map.Entry<NamedAggregator, AggregationState> stateEntry : entry.getValue()) {
                    map.put(stateEntry.getKey().getName(), stateEntry.getValue().result());
                }
                resultBuilder.add((Object)ExprTupleValue.fromExprValueMap(map));
            }
            return resultBuilder.build();
        }

        @Generated
        public Group() {
        }
    }

    @VisibleForTesting
    public class GroupKey {
        private final List<ExprValue> groupByValueList = new ArrayList<ExprValue>();

        public GroupKey(ExprValue value) {
            for (Expression groupExpr : AggregationOperator.this.groupByExprList) {
                this.groupByValueList.add(groupExpr.valueOf(value.bindingTuples()));
            }
        }

        public LinkedHashMap<String, ExprValue> groupKeyMap() {
            LinkedHashMap<String, ExprValue> map = new LinkedHashMap<String, ExprValue>();
            for (int i = 0; i < AggregationOperator.this.groupByExprList.size(); ++i) {
                map.put(((NamedExpression)AggregationOperator.this.groupByExprList.get(i)).getNameOrAlias(), this.groupByValueList.get(i));
            }
            return map;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof GroupKey)) {
                return false;
            }
            GroupKey other = (GroupKey)o;
            if (!other.canEqual(this)) {
                return false;
            }
            List<ExprValue> this$groupByValueList = this.groupByValueList;
            List<ExprValue> other$groupByValueList = other.groupByValueList;
            return !(this$groupByValueList == null ? other$groupByValueList != null : !((Object)this$groupByValueList).equals(other$groupByValueList));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof GroupKey;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            List<ExprValue> $groupByValueList = this.groupByValueList;
            result = result * 59 + ($groupByValueList == null ? 43 : ((Object)$groupByValueList).hashCode());
            return result;
        }
    }
}

