/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.opendistroforelasticsearch.sql.expression.window.ranking;

import com.amazon.opendistroforelasticsearch.sql.data.model.ExprIntegerValue;
import com.amazon.opendistroforelasticsearch.sql.data.model.ExprValue;
import com.amazon.opendistroforelasticsearch.sql.data.type.ExprCoreType;
import com.amazon.opendistroforelasticsearch.sql.data.type.ExprType;
import com.amazon.opendistroforelasticsearch.sql.expression.Expression;
import com.amazon.opendistroforelasticsearch.sql.expression.FunctionExpression;
import com.amazon.opendistroforelasticsearch.sql.expression.env.Environment;
import com.amazon.opendistroforelasticsearch.sql.expression.function.FunctionName;
import com.amazon.opendistroforelasticsearch.sql.expression.window.WindowDefinition;
import com.amazon.opendistroforelasticsearch.sql.expression.window.WindowFunctionExpression;
import com.amazon.opendistroforelasticsearch.sql.expression.window.frame.CurrentRowWindowFrame;
import com.amazon.opendistroforelasticsearch.sql.expression.window.frame.WindowFrame;
import com.amazon.opendistroforelasticsearch.sql.storage.bindingtuple.BindingTuple;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.tuple.Pair;

public abstract class RankingWindowFunction
extends FunctionExpression
implements WindowFunctionExpression {
    protected int rank;

    public RankingWindowFunction(FunctionName functionName) {
        super(functionName, Collections.emptyList());
    }

    @Override
    public ExprType type() {
        return ExprCoreType.INTEGER;
    }

    @Override
    public WindowFrame createWindowFrame(WindowDefinition definition) {
        return new CurrentRowWindowFrame(definition);
    }

    @Override
    public ExprValue valueOf(Environment<Expression, ExprValue> valueEnv) {
        return new ExprIntegerValue(this.rank((CurrentRowWindowFrame)valueEnv));
    }

    protected abstract int rank(CurrentRowWindowFrame var1);

    protected boolean isSortFieldValueDifferent(CurrentRowWindowFrame frame) {
        if (this.isSortItemsNotDefined(frame)) {
            return false;
        }
        List<Expression> sortItems = frame.getWindowDefinition().getSortList().stream().map(Pair::getRight).collect(Collectors.toList());
        List<ExprValue> previous = this.resolve(frame, sortItems, frame.previous());
        List<ExprValue> current = this.resolve(frame, sortItems, frame.current());
        return !current.equals(previous);
    }

    private boolean isSortItemsNotDefined(CurrentRowWindowFrame frame) {
        return frame.getWindowDefinition().getSortList().isEmpty();
    }

    private List<ExprValue> resolve(WindowFrame frame, List<Expression> expressions, ExprValue row) {
        BindingTuple valueEnv = row.bindingTuples();
        return expressions.stream().map(expr -> expr.valueOf(valueEnv)).collect(Collectors.toList());
    }

    @Override
    public String toString() {
        return this.getFunctionName() + "()";
    }
}

