/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.opendistroforelasticsearch.sql.expression.text;

import com.amazon.opendistroforelasticsearch.sql.data.model.ExprIntegerValue;
import com.amazon.opendistroforelasticsearch.sql.data.model.ExprStringValue;
import com.amazon.opendistroforelasticsearch.sql.data.model.ExprValue;
import com.amazon.opendistroforelasticsearch.sql.data.type.ExprCoreType;
import com.amazon.opendistroforelasticsearch.sql.expression.function.BuiltinFunctionName;
import com.amazon.opendistroforelasticsearch.sql.expression.function.BuiltinFunctionRepository;
import com.amazon.opendistroforelasticsearch.sql.expression.function.FunctionDSL;
import com.amazon.opendistroforelasticsearch.sql.expression.function.FunctionName;
import com.amazon.opendistroforelasticsearch.sql.expression.function.FunctionResolver;
import lombok.Generated;

public final class TextFunction {
    private static String EMPTY_STRING = "";

    public static void register(BuiltinFunctionRepository repository) {
        repository.register(TextFunction.substr());
        repository.register(TextFunction.substring());
        repository.register(TextFunction.ltrim());
        repository.register(TextFunction.rtrim());
        repository.register(TextFunction.trim());
        repository.register(TextFunction.lower());
        repository.register(TextFunction.upper());
        repository.register(TextFunction.concat());
        repository.register(TextFunction.concat_ws());
        repository.register(TextFunction.length());
        repository.register(TextFunction.strcmp());
        repository.register(TextFunction.right());
    }

    private static FunctionResolver substringSubstr(FunctionName functionName) {
        return FunctionDSL.define(functionName, FunctionDSL.impl(FunctionDSL.nullMissingHandling(TextFunction::exprSubstrStart), ExprCoreType.STRING, ExprCoreType.STRING, ExprCoreType.INTEGER), FunctionDSL.impl(FunctionDSL.nullMissingHandling(TextFunction::exprSubstrStartLength), ExprCoreType.STRING, ExprCoreType.STRING, ExprCoreType.INTEGER, ExprCoreType.INTEGER));
    }

    private static FunctionResolver substring() {
        return TextFunction.substringSubstr(BuiltinFunctionName.SUBSTRING.getName());
    }

    private static FunctionResolver substr() {
        return TextFunction.substringSubstr(BuiltinFunctionName.SUBSTR.getName());
    }

    private static FunctionResolver ltrim() {
        return FunctionDSL.define(BuiltinFunctionName.LTRIM.getName(), FunctionDSL.impl(FunctionDSL.nullMissingHandling(v -> new ExprStringValue(v.stringValue().stripLeading())), ExprCoreType.STRING, ExprCoreType.STRING));
    }

    private static FunctionResolver rtrim() {
        return FunctionDSL.define(BuiltinFunctionName.RTRIM.getName(), FunctionDSL.impl(FunctionDSL.nullMissingHandling(v -> new ExprStringValue(v.stringValue().stripTrailing())), ExprCoreType.STRING, ExprCoreType.STRING));
    }

    private static FunctionResolver trim() {
        return FunctionDSL.define(BuiltinFunctionName.TRIM.getName(), FunctionDSL.impl(FunctionDSL.nullMissingHandling(v -> new ExprStringValue(v.stringValue().trim())), ExprCoreType.STRING, ExprCoreType.STRING));
    }

    private static FunctionResolver lower() {
        return FunctionDSL.define(BuiltinFunctionName.LOWER.getName(), FunctionDSL.impl(FunctionDSL.nullMissingHandling(v -> new ExprStringValue(v.stringValue().toLowerCase())), ExprCoreType.STRING, ExprCoreType.STRING));
    }

    private static FunctionResolver upper() {
        return FunctionDSL.define(BuiltinFunctionName.UPPER.getName(), FunctionDSL.impl(FunctionDSL.nullMissingHandling(v -> new ExprStringValue(v.stringValue().toUpperCase())), ExprCoreType.STRING, ExprCoreType.STRING));
    }

    private static FunctionResolver concat() {
        return FunctionDSL.define(BuiltinFunctionName.CONCAT.getName(), FunctionDSL.impl(FunctionDSL.nullMissingHandling((str1, str2) -> new ExprStringValue(str1.stringValue() + str2.stringValue())), ExprCoreType.STRING, ExprCoreType.STRING, ExprCoreType.STRING));
    }

    private static FunctionResolver concat_ws() {
        return FunctionDSL.define(BuiltinFunctionName.CONCAT_WS.getName(), FunctionDSL.impl(FunctionDSL.nullMissingHandling((sep, str1, str2) -> new ExprStringValue(str1.stringValue() + sep.stringValue() + str2.stringValue())), ExprCoreType.STRING, ExprCoreType.STRING, ExprCoreType.STRING, ExprCoreType.STRING));
    }

    private static FunctionResolver length() {
        return FunctionDSL.define(BuiltinFunctionName.LENGTH.getName(), FunctionDSL.impl(FunctionDSL.nullMissingHandling(str -> new ExprIntegerValue(str.stringValue().getBytes().length)), ExprCoreType.INTEGER, ExprCoreType.STRING));
    }

    private static FunctionResolver strcmp() {
        return FunctionDSL.define(BuiltinFunctionName.STRCMP.getName(), FunctionDSL.impl(FunctionDSL.nullMissingHandling((str1, str2) -> new ExprIntegerValue(Integer.compare(str1.stringValue().compareTo(str2.stringValue()), 0))), ExprCoreType.INTEGER, ExprCoreType.STRING, ExprCoreType.STRING));
    }

    private static FunctionResolver right() {
        return FunctionDSL.define(BuiltinFunctionName.RIGHT.getName(), FunctionDSL.impl(FunctionDSL.nullMissingHandling(TextFunction::exprRight), ExprCoreType.STRING, ExprCoreType.STRING, ExprCoreType.INTEGER));
    }

    private static ExprValue exprSubstrStart(ExprValue exprValue, ExprValue start) {
        int startIdx = start.integerValue();
        if (startIdx == 0) {
            return new ExprStringValue(EMPTY_STRING);
        }
        String str = exprValue.stringValue();
        return TextFunction.exprSubStr(str, startIdx, str.length());
    }

    private static ExprValue exprSubstrStartLength(ExprValue exprValue, ExprValue start, ExprValue length) {
        int startIdx = start.integerValue();
        int len = length.integerValue();
        if (startIdx == 0 || len == 0) {
            return new ExprStringValue(EMPTY_STRING);
        }
        String str = exprValue.stringValue();
        return TextFunction.exprSubStr(str, startIdx, len);
    }

    private static ExprValue exprSubStr(String str, int start, int len) {
        int n = start = start > 0 ? start - 1 : str.length() + start;
        if (start > str.length()) {
            return new ExprStringValue(EMPTY_STRING);
        }
        if (start + len > str.length()) {
            return new ExprStringValue(str.substring(start));
        }
        return new ExprStringValue(str.substring(start, start + len));
    }

    private static ExprValue exprRight(ExprValue str, ExprValue len) {
        return new ExprStringValue(str.stringValue().substring(str.stringValue().length() - len.integerValue()));
    }

    @Generated
    private TextFunction() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

