/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.opendistroforelasticsearch.sql.expression.function;

import com.amazon.opendistroforelasticsearch.sql.exception.ExpressionEvaluationException;
import com.amazon.opendistroforelasticsearch.sql.expression.Expression;
import com.amazon.opendistroforelasticsearch.sql.expression.function.FunctionBuilder;
import com.amazon.opendistroforelasticsearch.sql.expression.function.FunctionImplementation;
import com.amazon.opendistroforelasticsearch.sql.expression.function.FunctionName;
import com.amazon.opendistroforelasticsearch.sql.expression.function.FunctionResolver;
import com.amazon.opendistroforelasticsearch.sql.expression.function.FunctionSignature;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import lombok.Generated;

public class BuiltinFunctionRepository {
    private final Map<FunctionName, FunctionResolver> functionResolverMap;

    public void register(FunctionResolver resolver) {
        this.functionResolverMap.put(resolver.getFunctionName(), resolver);
    }

    public FunctionImplementation compile(FunctionName functionName, List<Expression> expressions) {
        FunctionBuilder resolvedFunctionBuilder = this.resolve(new FunctionSignature(functionName, expressions.stream().map(expression -> expression.type()).collect(Collectors.toList())));
        return resolvedFunctionBuilder.apply(expressions);
    }

    public FunctionBuilder resolve(FunctionSignature functionSignature) {
        FunctionName functionName = functionSignature.getFunctionName();
        if (this.functionResolverMap.containsKey(functionName)) {
            return this.functionResolverMap.get(functionName).resolve(functionSignature);
        }
        throw new ExpressionEvaluationException(String.format("unsupported function name: %s", functionName.getFunctionName()));
    }

    @Generated
    public BuiltinFunctionRepository(Map<FunctionName, FunctionResolver> functionResolverMap) {
        this.functionResolverMap = functionResolverMap;
    }
}

