/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.opendistroforelasticsearch.sql.expression.datetime;

import com.amazon.opendistroforelasticsearch.sql.data.model.ExprDateValue;
import com.amazon.opendistroforelasticsearch.sql.data.model.ExprDatetimeValue;
import com.amazon.opendistroforelasticsearch.sql.data.model.ExprIntegerValue;
import com.amazon.opendistroforelasticsearch.sql.data.model.ExprLongValue;
import com.amazon.opendistroforelasticsearch.sql.data.model.ExprStringValue;
import com.amazon.opendistroforelasticsearch.sql.data.model.ExprTimeValue;
import com.amazon.opendistroforelasticsearch.sql.data.model.ExprTimestampValue;
import com.amazon.opendistroforelasticsearch.sql.data.model.ExprValue;
import com.amazon.opendistroforelasticsearch.sql.data.type.ExprCoreType;
import com.amazon.opendistroforelasticsearch.sql.expression.datetime.CalendarLookup;
import com.amazon.opendistroforelasticsearch.sql.expression.datetime.DateTimeFormatterUtil;
import com.amazon.opendistroforelasticsearch.sql.expression.function.BuiltinFunctionName;
import com.amazon.opendistroforelasticsearch.sql.expression.function.BuiltinFunctionRepository;
import com.amazon.opendistroforelasticsearch.sql.expression.function.FunctionDSL;
import com.amazon.opendistroforelasticsearch.sql.expression.function.FunctionName;
import com.amazon.opendistroforelasticsearch.sql.expression.function.FunctionResolver;
import java.time.LocalDate;
import java.time.format.TextStyle;
import java.util.Locale;
import java.util.concurrent.TimeUnit;
import lombok.Generated;

public final class DateTimeFunction {
    private static final Long DAYS_0000_TO_1970 = 719528L;

    public static void register(BuiltinFunctionRepository repository) {
        repository.register(DateTimeFunction.adddate());
        repository.register(DateTimeFunction.date());
        repository.register(DateTimeFunction.date_add());
        repository.register(DateTimeFunction.date_sub());
        repository.register(DateTimeFunction.day());
        repository.register(DateTimeFunction.dayName());
        repository.register(DateTimeFunction.dayOfMonth());
        repository.register(DateTimeFunction.dayOfWeek());
        repository.register(DateTimeFunction.dayOfYear());
        repository.register(DateTimeFunction.from_days());
        repository.register(DateTimeFunction.hour());
        repository.register(DateTimeFunction.microsecond());
        repository.register(DateTimeFunction.minute());
        repository.register(DateTimeFunction.month());
        repository.register(DateTimeFunction.monthName());
        repository.register(DateTimeFunction.quarter());
        repository.register(DateTimeFunction.second());
        repository.register(DateTimeFunction.subdate());
        repository.register(DateTimeFunction.time());
        repository.register(DateTimeFunction.time_to_sec());
        repository.register(DateTimeFunction.timestamp());
        repository.register(DateTimeFunction.date_format());
        repository.register(DateTimeFunction.to_days());
        repository.register(DateTimeFunction.week());
        repository.register(DateTimeFunction.year());
    }

    private static FunctionResolver add_date(FunctionName functionName) {
        return FunctionDSL.define(functionName, FunctionDSL.impl(FunctionDSL.nullMissingHandling(DateTimeFunction::exprAddDateInterval), ExprCoreType.DATETIME, ExprCoreType.STRING, ExprCoreType.INTERVAL), FunctionDSL.impl(FunctionDSL.nullMissingHandling(DateTimeFunction::exprAddDateInterval), ExprCoreType.DATETIME, ExprCoreType.DATE, ExprCoreType.INTERVAL), FunctionDSL.impl(FunctionDSL.nullMissingHandling(DateTimeFunction::exprAddDateInterval), ExprCoreType.DATETIME, ExprCoreType.DATETIME, ExprCoreType.INTERVAL), FunctionDSL.impl(FunctionDSL.nullMissingHandling(DateTimeFunction::exprAddDateInterval), ExprCoreType.DATETIME, ExprCoreType.TIMESTAMP, ExprCoreType.INTERVAL), FunctionDSL.impl(FunctionDSL.nullMissingHandling(DateTimeFunction::exprAddDateDays), ExprCoreType.DATE, ExprCoreType.DATE, ExprCoreType.LONG), FunctionDSL.impl(FunctionDSL.nullMissingHandling(DateTimeFunction::exprAddDateDays), ExprCoreType.DATETIME, ExprCoreType.DATETIME, ExprCoreType.LONG), FunctionDSL.impl(FunctionDSL.nullMissingHandling(DateTimeFunction::exprAddDateDays), ExprCoreType.DATETIME, ExprCoreType.TIMESTAMP, ExprCoreType.LONG), FunctionDSL.impl(FunctionDSL.nullMissingHandling(DateTimeFunction::exprAddDateDays), ExprCoreType.DATETIME, ExprCoreType.STRING, ExprCoreType.LONG));
    }

    private static FunctionResolver adddate() {
        return DateTimeFunction.add_date(BuiltinFunctionName.ADDDATE.getName());
    }

    private static FunctionResolver date() {
        return FunctionDSL.define(BuiltinFunctionName.DATE.getName(), FunctionDSL.impl(FunctionDSL.nullMissingHandling(DateTimeFunction::exprDate), ExprCoreType.DATE, ExprCoreType.STRING), FunctionDSL.impl(FunctionDSL.nullMissingHandling(DateTimeFunction::exprDate), ExprCoreType.DATE, ExprCoreType.DATE), FunctionDSL.impl(FunctionDSL.nullMissingHandling(DateTimeFunction::exprDate), ExprCoreType.DATE, ExprCoreType.DATETIME), FunctionDSL.impl(FunctionDSL.nullMissingHandling(DateTimeFunction::exprDate), ExprCoreType.DATE, ExprCoreType.TIMESTAMP));
    }

    private static FunctionResolver date_add() {
        return DateTimeFunction.add_date(BuiltinFunctionName.DATE_ADD.getName());
    }

    private static FunctionResolver sub_date(FunctionName functionName) {
        return FunctionDSL.define(functionName, FunctionDSL.impl(FunctionDSL.nullMissingHandling(DateTimeFunction::exprSubDateInterval), ExprCoreType.DATETIME, ExprCoreType.STRING, ExprCoreType.INTERVAL), FunctionDSL.impl(FunctionDSL.nullMissingHandling(DateTimeFunction::exprSubDateInterval), ExprCoreType.DATETIME, ExprCoreType.DATE, ExprCoreType.INTERVAL), FunctionDSL.impl(FunctionDSL.nullMissingHandling(DateTimeFunction::exprSubDateInterval), ExprCoreType.DATETIME, ExprCoreType.DATETIME, ExprCoreType.INTERVAL), FunctionDSL.impl(FunctionDSL.nullMissingHandling(DateTimeFunction::exprSubDateInterval), ExprCoreType.DATETIME, ExprCoreType.TIMESTAMP, ExprCoreType.INTERVAL), FunctionDSL.impl(FunctionDSL.nullMissingHandling(DateTimeFunction::exprSubDateDays), ExprCoreType.DATE, ExprCoreType.DATE, ExprCoreType.LONG), FunctionDSL.impl(FunctionDSL.nullMissingHandling(DateTimeFunction::exprSubDateDays), ExprCoreType.DATETIME, ExprCoreType.DATETIME, ExprCoreType.LONG), FunctionDSL.impl(FunctionDSL.nullMissingHandling(DateTimeFunction::exprSubDateDays), ExprCoreType.DATETIME, ExprCoreType.TIMESTAMP, ExprCoreType.LONG), FunctionDSL.impl(FunctionDSL.nullMissingHandling(DateTimeFunction::exprSubDateDays), ExprCoreType.DATETIME, ExprCoreType.STRING, ExprCoreType.LONG));
    }

    private static FunctionResolver date_sub() {
        return DateTimeFunction.sub_date(BuiltinFunctionName.DATE_SUB.getName());
    }

    private static FunctionResolver day() {
        return FunctionDSL.define(BuiltinFunctionName.DAY.getName(), FunctionDSL.impl(FunctionDSL.nullMissingHandling(DateTimeFunction::exprDayOfMonth), ExprCoreType.INTEGER, ExprCoreType.DATE), FunctionDSL.impl(FunctionDSL.nullMissingHandling(DateTimeFunction::exprDayOfMonth), ExprCoreType.INTEGER, ExprCoreType.DATETIME), FunctionDSL.impl(FunctionDSL.nullMissingHandling(DateTimeFunction::exprDayOfMonth), ExprCoreType.INTEGER, ExprCoreType.TIMESTAMP), FunctionDSL.impl(FunctionDSL.nullMissingHandling(DateTimeFunction::exprDayOfMonth), ExprCoreType.INTEGER, ExprCoreType.STRING));
    }

    private static FunctionResolver dayName() {
        return FunctionDSL.define(BuiltinFunctionName.DAYNAME.getName(), FunctionDSL.impl(FunctionDSL.nullMissingHandling(DateTimeFunction::exprDayName), ExprCoreType.STRING, ExprCoreType.DATE), FunctionDSL.impl(FunctionDSL.nullMissingHandling(DateTimeFunction::exprDayName), ExprCoreType.STRING, ExprCoreType.DATETIME), FunctionDSL.impl(FunctionDSL.nullMissingHandling(DateTimeFunction::exprDayName), ExprCoreType.STRING, ExprCoreType.TIMESTAMP), FunctionDSL.impl(FunctionDSL.nullMissingHandling(DateTimeFunction::exprDayName), ExprCoreType.STRING, ExprCoreType.STRING));
    }

    private static FunctionResolver dayOfMonth() {
        return FunctionDSL.define(BuiltinFunctionName.DAYOFMONTH.getName(), FunctionDSL.impl(FunctionDSL.nullMissingHandling(DateTimeFunction::exprDayOfMonth), ExprCoreType.INTEGER, ExprCoreType.DATE), FunctionDSL.impl(FunctionDSL.nullMissingHandling(DateTimeFunction::exprDayOfMonth), ExprCoreType.INTEGER, ExprCoreType.DATETIME), FunctionDSL.impl(FunctionDSL.nullMissingHandling(DateTimeFunction::exprDayOfMonth), ExprCoreType.INTEGER, ExprCoreType.TIMESTAMP), FunctionDSL.impl(FunctionDSL.nullMissingHandling(DateTimeFunction::exprDayOfMonth), ExprCoreType.INTEGER, ExprCoreType.STRING));
    }

    private static FunctionResolver dayOfWeek() {
        return FunctionDSL.define(BuiltinFunctionName.DAYOFWEEK.getName(), FunctionDSL.impl(FunctionDSL.nullMissingHandling(DateTimeFunction::exprDayOfWeek), ExprCoreType.INTEGER, ExprCoreType.DATE), FunctionDSL.impl(FunctionDSL.nullMissingHandling(DateTimeFunction::exprDayOfWeek), ExprCoreType.INTEGER, ExprCoreType.DATETIME), FunctionDSL.impl(FunctionDSL.nullMissingHandling(DateTimeFunction::exprDayOfWeek), ExprCoreType.INTEGER, ExprCoreType.TIMESTAMP), FunctionDSL.impl(FunctionDSL.nullMissingHandling(DateTimeFunction::exprDayOfWeek), ExprCoreType.INTEGER, ExprCoreType.STRING));
    }

    private static FunctionResolver dayOfYear() {
        return FunctionDSL.define(BuiltinFunctionName.DAYOFYEAR.getName(), FunctionDSL.impl(FunctionDSL.nullMissingHandling(DateTimeFunction::exprDayOfYear), ExprCoreType.INTEGER, ExprCoreType.DATE), FunctionDSL.impl(FunctionDSL.nullMissingHandling(DateTimeFunction::exprDayOfYear), ExprCoreType.INTEGER, ExprCoreType.DATETIME), FunctionDSL.impl(FunctionDSL.nullMissingHandling(DateTimeFunction::exprDayOfYear), ExprCoreType.INTEGER, ExprCoreType.TIMESTAMP), FunctionDSL.impl(FunctionDSL.nullMissingHandling(DateTimeFunction::exprDayOfYear), ExprCoreType.INTEGER, ExprCoreType.STRING));
    }

    private static FunctionResolver from_days() {
        return FunctionDSL.define(BuiltinFunctionName.FROM_DAYS.getName(), FunctionDSL.impl(FunctionDSL.nullMissingHandling(DateTimeFunction::exprFromDays), ExprCoreType.DATE, ExprCoreType.LONG));
    }

    private static FunctionResolver hour() {
        return FunctionDSL.define(BuiltinFunctionName.HOUR.getName(), FunctionDSL.impl(FunctionDSL.nullMissingHandling(DateTimeFunction::exprHour), ExprCoreType.INTEGER, ExprCoreType.STRING), FunctionDSL.impl(FunctionDSL.nullMissingHandling(DateTimeFunction::exprHour), ExprCoreType.INTEGER, ExprCoreType.TIME), FunctionDSL.impl(FunctionDSL.nullMissingHandling(DateTimeFunction::exprHour), ExprCoreType.INTEGER, ExprCoreType.DATETIME), FunctionDSL.impl(FunctionDSL.nullMissingHandling(DateTimeFunction::exprHour), ExprCoreType.INTEGER, ExprCoreType.TIMESTAMP));
    }

    private static FunctionResolver microsecond() {
        return FunctionDSL.define(BuiltinFunctionName.MICROSECOND.getName(), FunctionDSL.impl(FunctionDSL.nullMissingHandling(DateTimeFunction::exprMicrosecond), ExprCoreType.INTEGER, ExprCoreType.STRING), FunctionDSL.impl(FunctionDSL.nullMissingHandling(DateTimeFunction::exprMicrosecond), ExprCoreType.INTEGER, ExprCoreType.TIME), FunctionDSL.impl(FunctionDSL.nullMissingHandling(DateTimeFunction::exprMicrosecond), ExprCoreType.INTEGER, ExprCoreType.DATETIME), FunctionDSL.impl(FunctionDSL.nullMissingHandling(DateTimeFunction::exprMicrosecond), ExprCoreType.INTEGER, ExprCoreType.TIMESTAMP));
    }

    private static FunctionResolver minute() {
        return FunctionDSL.define(BuiltinFunctionName.MINUTE.getName(), FunctionDSL.impl(FunctionDSL.nullMissingHandling(DateTimeFunction::exprMinute), ExprCoreType.INTEGER, ExprCoreType.STRING), FunctionDSL.impl(FunctionDSL.nullMissingHandling(DateTimeFunction::exprMinute), ExprCoreType.INTEGER, ExprCoreType.TIME), FunctionDSL.impl(FunctionDSL.nullMissingHandling(DateTimeFunction::exprMinute), ExprCoreType.INTEGER, ExprCoreType.DATETIME), FunctionDSL.impl(FunctionDSL.nullMissingHandling(DateTimeFunction::exprMinute), ExprCoreType.INTEGER, ExprCoreType.TIMESTAMP));
    }

    private static FunctionResolver month() {
        return FunctionDSL.define(BuiltinFunctionName.MONTH.getName(), FunctionDSL.impl(FunctionDSL.nullMissingHandling(DateTimeFunction::exprMonth), ExprCoreType.INTEGER, ExprCoreType.DATE), FunctionDSL.impl(FunctionDSL.nullMissingHandling(DateTimeFunction::exprMonth), ExprCoreType.INTEGER, ExprCoreType.DATETIME), FunctionDSL.impl(FunctionDSL.nullMissingHandling(DateTimeFunction::exprMonth), ExprCoreType.INTEGER, ExprCoreType.TIMESTAMP), FunctionDSL.impl(FunctionDSL.nullMissingHandling(DateTimeFunction::exprMonth), ExprCoreType.INTEGER, ExprCoreType.STRING));
    }

    private static FunctionResolver monthName() {
        return FunctionDSL.define(BuiltinFunctionName.MONTHNAME.getName(), FunctionDSL.impl(FunctionDSL.nullMissingHandling(DateTimeFunction::exprMonthName), ExprCoreType.STRING, ExprCoreType.DATE), FunctionDSL.impl(FunctionDSL.nullMissingHandling(DateTimeFunction::exprMonthName), ExprCoreType.STRING, ExprCoreType.DATETIME), FunctionDSL.impl(FunctionDSL.nullMissingHandling(DateTimeFunction::exprMonthName), ExprCoreType.STRING, ExprCoreType.TIMESTAMP), FunctionDSL.impl(FunctionDSL.nullMissingHandling(DateTimeFunction::exprMonthName), ExprCoreType.STRING, ExprCoreType.STRING));
    }

    private static FunctionResolver quarter() {
        return FunctionDSL.define(BuiltinFunctionName.QUARTER.getName(), FunctionDSL.impl(FunctionDSL.nullMissingHandling(DateTimeFunction::exprQuarter), ExprCoreType.INTEGER, ExprCoreType.DATE), FunctionDSL.impl(FunctionDSL.nullMissingHandling(DateTimeFunction::exprQuarter), ExprCoreType.INTEGER, ExprCoreType.DATETIME), FunctionDSL.impl(FunctionDSL.nullMissingHandling(DateTimeFunction::exprQuarter), ExprCoreType.INTEGER, ExprCoreType.TIMESTAMP), FunctionDSL.impl(FunctionDSL.nullMissingHandling(DateTimeFunction::exprQuarter), ExprCoreType.INTEGER, ExprCoreType.STRING));
    }

    private static FunctionResolver second() {
        return FunctionDSL.define(BuiltinFunctionName.SECOND.getName(), FunctionDSL.impl(FunctionDSL.nullMissingHandling(DateTimeFunction::exprSecond), ExprCoreType.INTEGER, ExprCoreType.STRING), FunctionDSL.impl(FunctionDSL.nullMissingHandling(DateTimeFunction::exprSecond), ExprCoreType.INTEGER, ExprCoreType.TIME), FunctionDSL.impl(FunctionDSL.nullMissingHandling(DateTimeFunction::exprSecond), ExprCoreType.INTEGER, ExprCoreType.DATETIME), FunctionDSL.impl(FunctionDSL.nullMissingHandling(DateTimeFunction::exprSecond), ExprCoreType.INTEGER, ExprCoreType.TIMESTAMP));
    }

    private static FunctionResolver subdate() {
        return DateTimeFunction.sub_date(BuiltinFunctionName.SUBDATE.getName());
    }

    private static FunctionResolver time() {
        return FunctionDSL.define(BuiltinFunctionName.TIME.getName(), FunctionDSL.impl(FunctionDSL.nullMissingHandling(DateTimeFunction::exprTime), ExprCoreType.TIME, ExprCoreType.STRING), FunctionDSL.impl(FunctionDSL.nullMissingHandling(DateTimeFunction::exprTime), ExprCoreType.TIME, ExprCoreType.DATE), FunctionDSL.impl(FunctionDSL.nullMissingHandling(DateTimeFunction::exprTime), ExprCoreType.TIME, ExprCoreType.DATETIME), FunctionDSL.impl(FunctionDSL.nullMissingHandling(DateTimeFunction::exprTime), ExprCoreType.TIME, ExprCoreType.TIME), FunctionDSL.impl(FunctionDSL.nullMissingHandling(DateTimeFunction::exprTime), ExprCoreType.TIME, ExprCoreType.TIMESTAMP));
    }

    private static FunctionResolver time_to_sec() {
        return FunctionDSL.define(BuiltinFunctionName.TIME_TO_SEC.getName(), FunctionDSL.impl(FunctionDSL.nullMissingHandling(DateTimeFunction::exprTimeToSec), ExprCoreType.LONG, ExprCoreType.STRING), FunctionDSL.impl(FunctionDSL.nullMissingHandling(DateTimeFunction::exprTimeToSec), ExprCoreType.LONG, ExprCoreType.TIME), FunctionDSL.impl(FunctionDSL.nullMissingHandling(DateTimeFunction::exprTimeToSec), ExprCoreType.LONG, ExprCoreType.TIMESTAMP), FunctionDSL.impl(FunctionDSL.nullMissingHandling(DateTimeFunction::exprTimeToSec), ExprCoreType.LONG, ExprCoreType.DATETIME));
    }

    private static FunctionResolver timestamp() {
        return FunctionDSL.define(BuiltinFunctionName.TIMESTAMP.getName(), FunctionDSL.impl(FunctionDSL.nullMissingHandling(DateTimeFunction::exprTimestamp), ExprCoreType.TIMESTAMP, ExprCoreType.STRING), FunctionDSL.impl(FunctionDSL.nullMissingHandling(DateTimeFunction::exprTimestamp), ExprCoreType.TIMESTAMP, ExprCoreType.DATE), FunctionDSL.impl(FunctionDSL.nullMissingHandling(DateTimeFunction::exprTimestamp), ExprCoreType.TIMESTAMP, ExprCoreType.DATETIME), FunctionDSL.impl(FunctionDSL.nullMissingHandling(DateTimeFunction::exprTimestamp), ExprCoreType.TIMESTAMP, ExprCoreType.TIMESTAMP));
    }

    private static FunctionResolver to_days() {
        return FunctionDSL.define(BuiltinFunctionName.TO_DAYS.getName(), FunctionDSL.impl(FunctionDSL.nullMissingHandling(DateTimeFunction::exprToDays), ExprCoreType.LONG, ExprCoreType.STRING), FunctionDSL.impl(FunctionDSL.nullMissingHandling(DateTimeFunction::exprToDays), ExprCoreType.LONG, ExprCoreType.TIMESTAMP), FunctionDSL.impl(FunctionDSL.nullMissingHandling(DateTimeFunction::exprToDays), ExprCoreType.LONG, ExprCoreType.DATE), FunctionDSL.impl(FunctionDSL.nullMissingHandling(DateTimeFunction::exprToDays), ExprCoreType.LONG, ExprCoreType.DATETIME));
    }

    private static FunctionResolver week() {
        return FunctionDSL.define(BuiltinFunctionName.WEEK.getName(), FunctionDSL.impl(FunctionDSL.nullMissingHandling(DateTimeFunction::exprWeekWithoutMode), ExprCoreType.INTEGER, ExprCoreType.DATE), FunctionDSL.impl(FunctionDSL.nullMissingHandling(DateTimeFunction::exprWeekWithoutMode), ExprCoreType.INTEGER, ExprCoreType.DATETIME), FunctionDSL.impl(FunctionDSL.nullMissingHandling(DateTimeFunction::exprWeekWithoutMode), ExprCoreType.INTEGER, ExprCoreType.TIMESTAMP), FunctionDSL.impl(FunctionDSL.nullMissingHandling(DateTimeFunction::exprWeekWithoutMode), ExprCoreType.INTEGER, ExprCoreType.STRING), FunctionDSL.impl(FunctionDSL.nullMissingHandling(DateTimeFunction::exprWeek), ExprCoreType.INTEGER, ExprCoreType.DATE, ExprCoreType.INTEGER), FunctionDSL.impl(FunctionDSL.nullMissingHandling(DateTimeFunction::exprWeek), ExprCoreType.INTEGER, ExprCoreType.DATETIME, ExprCoreType.INTEGER), FunctionDSL.impl(FunctionDSL.nullMissingHandling(DateTimeFunction::exprWeek), ExprCoreType.INTEGER, ExprCoreType.TIMESTAMP, ExprCoreType.INTEGER), FunctionDSL.impl(FunctionDSL.nullMissingHandling(DateTimeFunction::exprWeek), ExprCoreType.INTEGER, ExprCoreType.STRING, ExprCoreType.INTEGER));
    }

    private static FunctionResolver year() {
        return FunctionDSL.define(BuiltinFunctionName.YEAR.getName(), FunctionDSL.impl(FunctionDSL.nullMissingHandling(DateTimeFunction::exprYear), ExprCoreType.INTEGER, ExprCoreType.DATE), FunctionDSL.impl(FunctionDSL.nullMissingHandling(DateTimeFunction::exprYear), ExprCoreType.INTEGER, ExprCoreType.DATETIME), FunctionDSL.impl(FunctionDSL.nullMissingHandling(DateTimeFunction::exprYear), ExprCoreType.INTEGER, ExprCoreType.TIMESTAMP), FunctionDSL.impl(FunctionDSL.nullMissingHandling(DateTimeFunction::exprYear), ExprCoreType.INTEGER, ExprCoreType.STRING));
    }

    private static FunctionResolver date_format() {
        return FunctionDSL.define(BuiltinFunctionName.DATE_FORMAT.getName(), FunctionDSL.impl(FunctionDSL.nullMissingHandling(DateTimeFormatterUtil::getFormattedDate), ExprCoreType.STRING, ExprCoreType.STRING, ExprCoreType.STRING), FunctionDSL.impl(FunctionDSL.nullMissingHandling(DateTimeFormatterUtil::getFormattedDate), ExprCoreType.STRING, ExprCoreType.DATE, ExprCoreType.STRING), FunctionDSL.impl(FunctionDSL.nullMissingHandling(DateTimeFormatterUtil::getFormattedDate), ExprCoreType.STRING, ExprCoreType.DATETIME, ExprCoreType.STRING), FunctionDSL.impl(FunctionDSL.nullMissingHandling(DateTimeFormatterUtil::getFormattedDate), ExprCoreType.STRING, ExprCoreType.TIMESTAMP, ExprCoreType.STRING));
    }

    private static ExprValue exprAddDateInterval(ExprValue date, ExprValue expr) {
        ExprDatetimeValue exprValue = new ExprDatetimeValue(date.datetimeValue().plus(expr.intervalValue()));
        return exprValue.timeValue().toSecondOfDay() == 0 ? new ExprDateValue(exprValue.dateValue()) : exprValue;
    }

    private static ExprValue exprAddDateDays(ExprValue date, ExprValue days) {
        ExprDatetimeValue exprValue = new ExprDatetimeValue(date.datetimeValue().plusDays(days.longValue()));
        return exprValue.timeValue().toSecondOfDay() == 0 ? new ExprDateValue(exprValue.dateValue()) : exprValue;
    }

    private static ExprValue exprDate(ExprValue exprValue) {
        if (exprValue instanceof ExprStringValue) {
            return new ExprDateValue(exprValue.stringValue());
        }
        return new ExprDateValue(exprValue.dateValue());
    }

    private static ExprValue exprDayName(ExprValue date) {
        return new ExprStringValue(date.dateValue().getDayOfWeek().getDisplayName(TextStyle.FULL, Locale.getDefault()));
    }

    private static ExprValue exprDayOfMonth(ExprValue date) {
        return new ExprIntegerValue(date.dateValue().getDayOfMonth());
    }

    private static ExprValue exprDayOfWeek(ExprValue date) {
        return new ExprIntegerValue(date.dateValue().getDayOfWeek().getValue() % 7 + 1);
    }

    private static ExprValue exprDayOfYear(ExprValue date) {
        return new ExprIntegerValue(date.dateValue().getDayOfYear());
    }

    private static ExprValue exprFromDays(ExprValue exprValue) {
        return new ExprDateValue(LocalDate.ofEpochDay(exprValue.longValue() - DAYS_0000_TO_1970));
    }

    private static ExprValue exprHour(ExprValue time) {
        return new ExprIntegerValue(time.timeValue().getHour());
    }

    private static ExprValue exprMicrosecond(ExprValue time) {
        return new ExprIntegerValue(TimeUnit.MICROSECONDS.convert(time.timeValue().getNano(), TimeUnit.NANOSECONDS));
    }

    private static ExprValue exprMinute(ExprValue time) {
        return new ExprIntegerValue(time.timeValue().getMinute());
    }

    private static ExprValue exprMonth(ExprValue date) {
        return new ExprIntegerValue(date.dateValue().getMonthValue());
    }

    private static ExprValue exprMonthName(ExprValue date) {
        return new ExprStringValue(date.dateValue().getMonth().getDisplayName(TextStyle.FULL, Locale.getDefault()));
    }

    private static ExprValue exprQuarter(ExprValue date) {
        int month = date.dateValue().getMonthValue();
        return new ExprIntegerValue(month / 3 + (month % 3 == 0 ? 0 : 1));
    }

    private static ExprValue exprSecond(ExprValue time) {
        return new ExprIntegerValue(time.timeValue().getSecond());
    }

    private static ExprValue exprSubDateDays(ExprValue date, ExprValue days) {
        ExprDatetimeValue exprValue = new ExprDatetimeValue(date.datetimeValue().minusDays(days.longValue()));
        return exprValue.timeValue().toSecondOfDay() == 0 ? new ExprDateValue(exprValue.dateValue()) : exprValue;
    }

    private static ExprValue exprSubDateInterval(ExprValue date, ExprValue expr) {
        ExprDatetimeValue exprValue = new ExprDatetimeValue(date.datetimeValue().minus(expr.intervalValue()));
        return exprValue.timeValue().toSecondOfDay() == 0 ? new ExprDateValue(exprValue.dateValue()) : exprValue;
    }

    private static ExprValue exprTime(ExprValue exprValue) {
        if (exprValue instanceof ExprStringValue) {
            return new ExprTimeValue(exprValue.stringValue());
        }
        return new ExprTimeValue(exprValue.timeValue());
    }

    private static ExprValue exprTimestamp(ExprValue exprValue) {
        if (exprValue instanceof ExprStringValue) {
            return new ExprTimestampValue(exprValue.stringValue());
        }
        return new ExprTimestampValue(exprValue.timestampValue());
    }

    private static ExprValue exprTimeToSec(ExprValue time) {
        return new ExprLongValue(time.timeValue().toSecondOfDay());
    }

    private static ExprValue exprToDays(ExprValue date) {
        return new ExprLongValue(date.dateValue().toEpochDay() + DAYS_0000_TO_1970);
    }

    private static ExprValue exprWeek(ExprValue date, ExprValue mode) {
        return new ExprIntegerValue(CalendarLookup.getWeekNumber(mode.integerValue(), date.dateValue()));
    }

    private static ExprValue exprWeekWithoutMode(ExprValue date) {
        return DateTimeFunction.exprWeek(date, new ExprIntegerValue(0));
    }

    private static ExprValue exprYear(ExprValue date) {
        return new ExprIntegerValue(date.dateValue().getYear());
    }

    @Generated
    private DateTimeFunction() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

