/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.opendistroforelasticsearch.sql.expression.datetime;

import com.amazon.opendistroforelasticsearch.sql.data.model.ExprStringValue;
import com.amazon.opendistroforelasticsearch.sql.data.model.ExprValue;
import com.amazon.opendistroforelasticsearch.sql.expression.datetime.CalendarLookup;
import com.google.common.collect.ImmutableMap;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

class DateTimeFormatterUtil {
    private static final int SUFFIX_SPECIAL_START_TH = 11;
    private static final int SUFFIX_SPECIAL_END_TH = 13;
    private static final String SUFFIX_SPECIAL_TH = "th";
    private static final Map<Integer, String> SUFFIX_CONVERTER = ImmutableMap.builder().put((Object)1, (Object)"st").put((Object)2, (Object)"nd").put((Object)3, (Object)"rd").build();
    private static final Map<String, DateTimeFormatHandler> HANDLERS = ImmutableMap.builder().put((Object)"%a", date -> "EEE").put((Object)"%b", date -> "LLL").put((Object)"%c", date -> "MM").put((Object)"%d", date -> "dd").put((Object)"%e", date -> "d").put((Object)"%H", date -> "HH").put((Object)"%h", date -> "hh").put((Object)"%I", date -> "hh").put((Object)"%i", date -> "mm").put((Object)"%j", date -> "DDD").put((Object)"%k", date -> "H").put((Object)"%l", date -> "h").put((Object)"%p", date -> "a").put((Object)"%M", date -> "LLLL").put((Object)"%m", date -> "MM").put((Object)"%r", date -> "hh:mm:ss a").put((Object)"%S", date -> "ss").put((Object)"%s", date -> "ss").put((Object)"%T", date -> "HH:mm:ss").put((Object)"%W", date -> "EEEE").put((Object)"%Y", date -> "yyyy").put((Object)"%y", date -> "yy").put((Object)"%D", date -> String.format("'%d%s'", date.getDayOfMonth(), DateTimeFormatterUtil.getSuffix(date.getDayOfMonth()))).put((Object)"%f", date -> String.format("'%d'", date.getNano() / 1000)).put((Object)"%w", date -> String.format("'%d'", date.getDayOfWeek().getValue())).put((Object)"%U", date -> String.format("'%d'", CalendarLookup.getWeekNumber(0, date.toLocalDate()))).put((Object)"%u", date -> String.format("'%d'", CalendarLookup.getWeekNumber(1, date.toLocalDate()))).put((Object)"%V", date -> String.format("'%d'", CalendarLookup.getWeekNumber(2, date.toLocalDate()))).put((Object)"%v", date -> String.format("'%d'", CalendarLookup.getWeekNumber(3, date.toLocalDate()))).put((Object)"%X", date -> String.format("'%d'", CalendarLookup.getYearNumber(2, date.toLocalDate()))).put((Object)"%x", date -> String.format("'%d'", CalendarLookup.getYearNumber(3, date.toLocalDate()))).build();
    private static final Pattern pattern = Pattern.compile("%.");
    private static final String MOD_LITERAL = "%";

    private DateTimeFormatterUtil() {
    }

    static ExprValue getFormattedDate(ExprValue dateExpr, ExprValue formatExpr) {
        LocalDateTime date = dateExpr.datetimeValue();
        Matcher matcher = pattern.matcher(formatExpr.stringValue());
        StringBuffer format = new StringBuffer();
        while (matcher.find()) {
            matcher.appendReplacement(format, HANDLERS.getOrDefault(matcher.group(), d -> String.format("'%s'", matcher.group().replaceFirst(MOD_LITERAL, ""))).getFormat(date));
        }
        matcher.appendTail(format);
        return new ExprStringValue(date.format(DateTimeFormatter.ofPattern(format.toString(), Locale.ENGLISH)));
    }

    private static String getSuffix(int val) {
        if (11 <= val && val <= 13) {
            return SUFFIX_SPECIAL_TH;
        }
        return SUFFIX_CONVERTER.getOrDefault(val % 10, SUFFIX_SPECIAL_TH);
    }

    static interface DateTimeFormatHandler {
        public String getFormat(LocalDateTime var1);
    }
}

